#include "MapSystem.h"
#include "MyView.h"
#include "GameMap.h"
#include "GamePxa.h"
#include "MyGame.h"
#include "main.h"
MapSystem::~MapSystem()
{
	if (tas.pSRV)
		tas.pSRV->Release();
	if (tas.pTexture)
		tas.pTexture->Release();
}

void MapSystem::Init(MyDX11Renderer* pRenderer, MyView* pView, GameMap* gameMap, GamePxa* gamePxa, std::weak_ptr<Entity>* mychar_ptr_Player1, std::weak_ptr<Entity>* mychar_ptr_Player2, MyGame* pGame)
{
	this->pRenderer = pRenderer;
	this->pView = pView;
	this->gameMap = gameMap;
	this->gamePxa = gamePxa;
	this->mychar_ptr_Player1 = mychar_ptr_Player1;
	this->mychar_ptr_Player2 = mychar_ptr_Player2;
	this->pGame = pGame;
}

void MapSystem::SetShow(bool bShow)
{
	this->bShow = bShow;
	std::weak_ptr<Entity> players[2];
	players[0] = *mychar_ptr_Player1;
	players[1] = *mychar_ptr_Player2;
	for (auto i = 0; i < _countof(players); i++)
	{
		auto wplayer = players[i].lock();
		if (wplayer)
		{
			wplayer->inputLock.SetMap(true);
			wplayer->inputLock.SetOk(true);
			wplayer->input.SetMap(false);
			wplayer->input.SetOk(false);
		}
	}
}

bool MapSystem::GetShow()
{
	return bShow;
}

void MapSystem::Step()
{
	bool bSwitch = false;
	std::weak_ptr<Entity> players[2];
	players[0] = *mychar_ptr_Player1;
	players[1] = *mychar_ptr_Player2;
	for (auto i = 0; i < _countof(players); i++)
	{
		auto wplayer = players[i].lock();
		if (wplayer)
		{
			if (wplayer->input.GetMap())
			{
				wplayer->inputLock.SetMap(true);
				wplayer->inputLock.SetOk(true);
				bSwitch = true;
			}
		}
	}
	//ʾͼ
	if (bSwitch)
	{
		bShow = !bShow;
		flash_counter = flash_interval;
	}
	if (bShow)
	{
		bool bClose = false;
		for (auto i = 0; i < _countof(players); i++)
		{
			auto wplayer = players[i].lock();
			if (wplayer)
			{
				if (wplayer->input.GetOk() || wplayer->input.GetCancel())
				{
					wplayer->inputLock.SetMap(true);
					wplayer->inputLock.SetOk(true);
					bClose = true;
				}
			}
		}
		if (bClose)
		{
			bShow = false;
			//˳ͼʱסӦм
			pGame->LockAllPlayerJump();
		}
			
		if (flash_counter > 0)
			flash_counter--;
		if (flash_counter == 0)
		{
			showMcPos = !showMcPos;
			flash_counter = flash_interval;
		}
	}
}

void MapSystem::Draw(MyMapLayer* pLayer)
{
	if (!bShow || !pLayer)
		return;
	MyRect rc;
	float pixelSize = 2;
	float offx, offy;
	//Сͼ
	int* pMapW, * pMapH;
	gameMap->GetMapSize(&pMapW, &pMapH);
	int mapW = *pMapW, mapH = *pMapH;
	pRenderer->SetPenDraw();
	auto& step = pLayer->step_pxm;
	auto& pxaData = *gamePxa->GetPxa(pLayer->pxaName.c_str());
	offx = (pView->window_w - mapW * pixelSize * pView->scale) / 2;
	offy = (pView->window_h - mapH * pixelSize * pView->scale) / 2;
	//Сͼ
	rc.Set1(offx, offy, mapW * pixelSize * pView->scale, mapH * pixelSize * pView->scale);
	pRenderer->AddFillRect(&rc, RGBA(0x0a, 0x24, 0x18, 0xff));
	for (auto& t : step)
	{
		//0ŵ
		if (t.second == 0)
			continue;
		auto iter = pxaData.pxa.find(t.second);
		auto pxaID = 0;
		if (iter != pxaData.pxa.end())
			pxaID = iter->second;
		float srcX = (float)LOWORD(t.second);
		float srcY = (float)HIWORD(t.second);
		float dstX = (float)LOWORD(t.first);
		float dstY = (float)HIWORD(t.first);
		rc.Set1(offx + (dstX * pixelSize) * pView->scale,
			offy + (dstY * pixelSize) * pView->scale,
			pixelSize * pView->scale,
			pixelSize * pView->scale);
		
		switch (pxaID)
		{
		default:
			break;
		case 0x1:
			//װε
			pRenderer->AddFillRect(&rc, RGBA(0x1e, 0x51, 0x3a, 0xff));
			break;
		case 0x2:
		case 0x12:
		case 0x3:
		case 0x13:
		case 0x6:
		case 0x16:
		case 0x7:
		case 0x17:
		case 0xa:
		case 0x1a:
		case 0xb:
		case 0x1b:
		case 0xc:
		case 0x1c:
		case 0xd:
		case 0x1d:
		case 0xe:
		case 0x1e:
			//ƹ
			pRenderer->AddFillRect(&rc, RGBA(0x2b, 0x76, 0x66, 0xff));
			break;
		case 0x41:
		case 0x42:
		case 0x51:
		case 0x52:
			//Ƽ̵
			pRenderer->AddFillRect(&rc, RGBA(0xff, 0, 0, 0xff));
			break;
		case 0x11:
		case 0x14:
		case 0x15:
		case 0x18:
		case 0x19:
		case 0x1f:
		case 0x70:
		case 0x71:
		case 0x72:
		case 0x73:
		case 0x74:
		case 0x75:
		case 0x76:
		case 0x77:
			//ˮе
			pRenderer->AddFillRect(&rc, RGBA(0, 0, 0xff, 0xff));
			break;
		}
	}
	//λ
	if (showMcPos)
	{
		std::weak_ptr<Entity> players[2];
		players[0] = *mychar_ptr_Player1;
		players[1] = *mychar_ptr_Player2;
		for (auto i = 0; i < _countof(players); i++)
		{
			auto wplayer = players[i].lock();
			if (wplayer)
			{
				rc.Set1(offx + ((wplayer->x - wplayer->cbRect.left) / 16 * pixelSize) * pView->scale,
					offy + ((wplayer->y - wplayer->cbRect.top) / 16 * pixelSize) * pView->scale,
					(wplayer->cbRect.left + wplayer->cbRect.right) / 16 * pixelSize * pView->scale,
					(wplayer->cbRect.top + wplayer->cbRect.bottom) / 16 * pixelSize * pView->scale);
				pRenderer->AddFillRect(&rc, RGBA(0xff, 0xff, 0xff, 0xff));
			}
		}
	}
	pRenderer->DrawFillRect();
	//Ʒ
	if (roomName != gameMap->GetMapShowName())
	{
		roomName = gameMap->GetMapShowName();
		OnResetScale();
	}
	if (roomName.length())
	{
		rc.Set1((pView->window_w - tas.w) / 2,
			8 * pView->scale,
			(float)tas.w,
			(float)tas.h);
		pRenderer->SetTPenDraw(tas.pSRV);
		pRenderer->AddRenderCopy(nullptr, &rc, RGBA(0xff, 0xff, 0xff, 0xff));
		pRenderer->DrawRenderCopy();
	}
}

void MapSystem::OnResetScale()
{
	if (!gameMap)
		return;
	roomName = gameMap->GetMapShowName();
	if (!roomName.length())
		return;
	if (tas.pSRV)
		tas.pSRV->Release();
	if (tas.pTexture)
		tas.pTexture->Release();
	MyView& view = *pView;
	SDL_Color c;
	c.r = c.g = c.b = c.a = 0xff;
	auto font = pRenderer->MyLoadFont(highQualityFont.c_str(), (int)(12 * view.scale));
	auto s = TTF_RenderUNICODE_Blended(font, (const Uint16*)roomName.c_str(), c);
	TTF_CloseFont(font);
	tas.w = s->w;
	tas.h = s->h;
	pRenderer->MyCreateTextureFromSDLSurface(&tas.pTexture, s);
	pRenderer->MyCreateShaderResourceView(&tas.pSRV, tas.pTexture);
	SDL_FreeSurface(s);
}

void MapSystem::Reset()
{
	bShow = false;
}
