#include "JudgeHit.h"
#include "MyView.h"
#include "Entity.h"

void CoyoteTime(std::shared_ptr<Entity>& we)
{
	if (we->cbRect.cbBottom)
		we->coyote_counter = we->coyote_max;
	else
	{
		if (we->vy <= 0)
			we->coyote_counter = 0;
		if (we->coyote_counter > 0)
		{
			we->coyote_counter--;
			we->cbRect.cbBottom = true;
		}
	}
}

void JH_BlockLT(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//
	y1 = Y * 16.0f + 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	if (x - l <= x1 &&
		x + r >= x2 &&
		y - t <= y1 &&
		y - t >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_BlockRT(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//
	y1 = Y * 16.0f + 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f + offset;//ש
	if (x - l <= x1 &&
		x + r >= x2 &&
		y - t <= y1 &&
		y - t >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_BlockPointLT(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//
	y1 = Y * 16.0f + 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y - t >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_BlockPointRT(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//
	y1 = Y * 16.0f + 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y - t >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_BlockLB(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//ײ
	y1 = Y * 16.0f - 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	if (x - l <= x1 &&
		x + r >= x2 &&
		y + b >= y1 &&
		y + b <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_BlockRB(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//ײ
	y1 = Y * 16.0f - 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f + offset;//ש
	if (x - l <= x1 &&
		x + r >= x2 &&
		y + b >= y1 &&
		y + b <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_BlockPointLB(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//ײ
	y1 = Y * 16.0f - 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 &&
		y + b <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_BlockPointRB(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//ײ
	y1 = Y * 16.0f - 8 + offset;//ש
	y2 = Y * 16.0f + offset;//ש
	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 &&
		y + b <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_BlockLeft(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//
	y1 = Y * 16.0f + 8 + offset;//ש
	y2 = Y * 16.0f - 8 + offset;//ש
	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f + offset;//ש
	if (y - t <= y1 &&
		y + b >= y2 &&
		x - l <= x1 &&
		x - l >= x2)
	{
		if (we->cbRect.enableSoild)
		{
			x = x1 + l;
			if (we->vx < 0)
				we->vx = 0;
		}
		we->cbRect.cbLeft = true;
		we->cbRect.pxaLeft = pxa;
	}
}

void JH_BlockRight(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	//ұ
	y1 = Y * 16.0f + 8 + offset;//ש
	y2 = Y * 16.0f - 8 + offset;//ש
	x1 = X * 16.0f - 8 + offset;//ש
	x2 = X * 16.0f + offset;//ש
	if (y - t <= y1 &&
		y + b >= y2 &&
		x + r >= x1 &&
		x + r <= x2)
	{
		if (we->cbRect.enableSoild)
		{
			x = x1 - r;
			if (we->vx > 0)
				we->vx = 0;
		}
		we->cbRect.cbRight = true;
		we->cbRect.pxaRight = pxa;
	}
}

void JH_SlopeA(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f - (x - X * 16.0f) / 2 + 8 + offset;//仯
	y2 = Y * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y + b >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_SlopeB(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f - (x - X * 16.0f) / 2 + offset;//仯
	y2 = Y * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y + b >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_SlopeC(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f + (x - X * 16.0f) / 2 - 8 + offset;//仯
	y2 = Y * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y + b >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_SlopeD(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f + (x - X * 16.0f) / 2 + offset;//仯
	y2 = Y * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y + b >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_SlopeE(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f + (x - X * 16.0f) / 2 - 8 + offset;//仯
	y2 = Y * 16.0f + 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 &&
		y - t <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_SlopeF(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f + (x - X * 16.0f) / 2 + offset;//仯
	y2 = Y * 16.0f + 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 &&
		y - t <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_SlopeG(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f - (x - X * 16.0f) / 2 + 8 + offset;//仯
	y2 = Y * 16.0f + 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 &&
		y - t <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_SlopeH(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f - (x - X * 16.0f) / 2 + offset;//仯
	y2 = Y * 16.0f + 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 &&
		y - t <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_SlopeI(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f - (x - X * 16.0f) + 8 + offset;//仯
	y2 = Y * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y + b >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_SlopeJ(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f + (x - X * 16.0f) - 8 + offset;//仯
	y2 = Y * 16.0f - 8 + offset;//ש
	if (x <= x1 &&
		x >= x2 &&
		y - t <= y1 &&
		y + b >= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 + t;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH_SlopeK(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f + (x - X * 16.0f) - 8 + offset;//仯
	y2 = Y * 16.0f + 8 + offset;//ש
	float adjust = 0;
	if (we->vx > 0)
		adjust = abs(we->vx);
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 - adjust &&
		y - t <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_SlopeL(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	auto& x = we->x;
	auto& y = we->y;
	auto& t = we->cbRect.top;
	auto& b = we->cbRect.bottom;
	auto& l = we->cbRect.left;
	auto& r = we->cbRect.right;
	float x1, x2, y1, y2;

	x1 = X * 16.0f + 8 + offset;//ש
	x2 = X * 16.0f - 8 + offset;//ש
	y1 = Y * 16.0f - (x - X * 16.0f) + 8 + offset;//仯
	y2 = Y * 16.0f + 8 + offset;//ש
	float adjust = 0;
	if (we->vx < 0)
		adjust = abs(we->vx);
	if (x <= x1 &&
		x >= x2 &&
		y + b >= y1 - adjust &&
		y - t <= y2)
	{
		if (we->cbRect.enableSoild)
		{
			y = y1 - b;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH_InWater(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	MyRect src, dst;
	src.Set1(
		we->x - we->cbRect.left,
		we->y - we->cbRect.top,
		we->cbRect.left + we->cbRect.right,
		we->cbRect.top + we->cbRect.bottom);
	if (we->cbRect.fullWaterBlock)
	{
		dst.Set1(X * 16.0f - 8 + offset,
			Y * 16.0f - 8 + offset,
			16.0f,
			16.0f);
	}
	else
	{
		dst.Set1(X * 16.0f - 7 + offset,
			Y * 16.0f - 7 + offset,
			14.0f,
			14.0f);
	}
	if (src.IntersectRect(&dst))
		we->cbRect.inWater = true;
}

bool JH_SpikeTouch(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	MyRect src, dst;
	src.Set1(
		we->x - we->cbRect.left,
		we->y - we->cbRect.top,
		we->cbRect.left + we->cbRect.right,
		we->cbRect.top + we->cbRect.bottom);
	dst.Set1(X * 16.0f - 4 + offset,
		Y * 16.0f - 4 + offset,
		8.0f,
		8.0f);
	bool ret = src.IntersectRect(&dst);
	if (ret)
		we->cbRect.onTrap = true;
	if (we->ignoreTrap)
		return false;
	if (we->ignoreTrap_counter > 0)
		return false;
	return ret;
}

void JH_SpikeDamage(std::shared_ptr<Entity>& we, int damage)
{
	int spikeDamage;
	bool bHurt = we->Hurt(std::weak_ptr<Entity>(), damage, we->lr == 0 ? 315.0f : 225.0f, 0, 0, 2, 2, &spikeDamage);
	if (spikeDamage > 0)
		we->ignoreTrap_counter = 180;
	//ʾ˺ֵ
	if (we->gameFunc->dmgNum && bHurt && we->type != 1)
		we->gameFunc->SetDmgNum(we->gameFunc->dmgNum, damage, we->x, we->y - 16, 0, we);
}

void JH_InSpike(std::shared_ptr<Entity>& we, int X, int Y, int offset, int damage)
{
	if (JH_SpikeTouch(we, X, Y, offset))
		JH_SpikeDamage(we, damage);
}

void JH_InLava(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	MyRect src, dst;
	src.Set1(
		we->x - we->cbRect.left,
		we->y - we->cbRect.top,
		we->cbRect.left + we->cbRect.right,
		we->cbRect.top + we->cbRect.bottom);
	dst.Set1(X * 16.0f - 4 + offset,
		Y * 16.0f - 4 + offset,
		8.0f,
		8.0f);
	if (src.IntersectRect(&dst))
	{
		we->cbRect.inLava = true;
		we->cbRect.inWater = true;
		we->cbRect.onTrap = true;
		if (we->ignoreTrap)
			return;
		if (we->ignoreTrap_counter > 0)
			return;
		JH_SpikeDamage(we, we->cbRect.lavaDmg);
	}
}

void JH_NPC_BlockT(std::shared_ptr<Entity>& we, std::shared_ptr<Entity>& wmc)
{
	float x1, x2, y1, y2;
	//
	y1 = we->y + we->cbRect.bottom;//
	y2 = (we->y + we->cbRect.bottom + we->y - we->cbRect.top) / 2;//
	x1 = we->x + we->cbRect.right - 3;//
	x2 = we->x - we->cbRect.left + 3;//

	if (wmc->x - wmc->cbRect.left <= x1 &&
		wmc->x + wmc->cbRect.right >= x2 &&
		wmc->y - wmc->cbRect.top <= y1 &&
		wmc->y - wmc->cbRect.top >= y2)
	{
		if (wmc->cbRect.enableSoild)
		{
			wmc->y = y1 + wmc->cbRect.top;
			if (wmc->vy < 0)
				wmc->vy = 0;
			wmc->cbRect.movingPlatformTop = we;
		}
		//ιڹƶƽ̨ʱ
		if (we->cbRect.enableMovePlatform && we->hp > 0 &&
			wmc->type == 2 && wmc->attackState && wmc->damaged_counter < wmc->damaged_limit)
		{
			//ڻʣ๥ʱֻƿײ
			wmc->y = y1 + wmc->cbRect.top;
		}
		else
		{
			wmc->cbRect.cbTop = true;
			wmc->cbRect.pxaTop = 2;
		}
	}
}

void JH_NPC_BlockB(std::shared_ptr<Entity>& we, std::shared_ptr<Entity>& wmc)
{
	float x1, x2, y1, y2;
	//ײ
	y1 = we->y - we->cbRect.top;//
	y2 = (we->y + we->cbRect.bottom + we->y - we->cbRect.top) / 2;//
	x1 = we->x + we->cbRect.right - 1;//
	x2 = we->x - we->cbRect.left + 1;//

	if (wmc->x - wmc->cbRect.left <= x1 &&
		wmc->x + wmc->cbRect.right >= x2 &&
		wmc->y + wmc->cbRect.bottom >= y1 &&
		wmc->y + wmc->cbRect.bottom <= y2)
	{
		if (wmc->cbRect.enableSoild)
		{
			wmc->y = y1 - wmc->cbRect.bottom;
			if (wmc->vy > 0)
				wmc->vy = 0;
			wmc->cbRect.movingPlatformBottom = we;
		}
		//ιڹƶƽ̨ʱ
		if (we->cbRect.enableMovePlatform && we->hp > 0 &&
			wmc->type == 2 && wmc->attackState && wmc->damaged_counter < wmc->damaged_limit)
		{
			//ڻʣ๥ʱֻƿײ
			wmc->y = y1 - wmc->cbRect.bottom;
		}
		else
		{
			wmc->cbRect.cbBottom = true;
			wmc->cbRect.pxaBottom = 2;
		}
	}
}

void JH_NPC_BlockL(std::shared_ptr<Entity>& we, std::shared_ptr<Entity>& wmc)
{
	float x1, x2, y1, y2;
	//
	y1 = we->y + we->cbRect.bottom - 3;//
	y2 = we->y - we->cbRect.top + 3;//
	x1 = we->x + we->cbRect.right;//
	x2 = (we->x + we->cbRect.right + we->x - we->cbRect.left) / 2;//
	if (wmc->y - wmc->cbRect.top <= y1 &&
		wmc->y + wmc->cbRect.bottom >= y2 &&
		wmc->x - wmc->cbRect.left <= x1 &&
		wmc->x - wmc->cbRect.left >= x2)
	{
		if (wmc->cbRect.enableSoild)
		{
			wmc->x = x1 + wmc->cbRect.left;
			if (wmc->vx < 0)
				wmc->vx = 0;
			wmc->cbRect.movingPlatformLeft = we;
		}
		//ιڹƶƽ̨ʱ
		if (we->cbRect.enableMovePlatform && we->hp > 0 &&
			wmc->type == 2 && wmc->attackState && wmc->damaged_counter < wmc->damaged_limit)
		{
			//ڻʣ๥ʱֻƿײ
			wmc->x = x1 + wmc->cbRect.left;
		}
		else
		{
			wmc->cbRect.cbLeft = true;
			wmc->cbRect.pxaLeft = 2;
		}
	}
}

void JH_NPC_BlockR(std::shared_ptr<Entity>& we, std::shared_ptr<Entity>& wmc)
{
	float x1, x2, y1, y2;
	//ұ
	y1 = we->y + we->cbRect.bottom - 3;//
	y2 = we->y - we->cbRect.top + 3;//
	x1 = we->x - we->cbRect.left;//
	x2 = (we->x + we->cbRect.right + we->x - we->cbRect.left) / 2;//
	if (wmc->y - wmc->cbRect.top <= y1 &&
		wmc->y + wmc->cbRect.bottom >= y2 &&
		wmc->x + wmc->cbRect.right >= x1 &&
		wmc->x + wmc->cbRect.right <= x2)
	{
		if (wmc->cbRect.enableSoild)
		{
			wmc->x = x1 - wmc->cbRect.right;
			if (wmc->vx > 0)
				wmc->vx = 0;
			wmc->cbRect.movingPlatformRight = we;
		}
		//ιڹƶƽ̨ʱ
		if (we->cbRect.enableMovePlatform && we->hp > 0 &&
			wmc->type == 2 && wmc->attackState && wmc->damaged_counter < wmc->damaged_limit)
		{
			//ڻʣ๥ʱֻƿײ
			wmc->x = x1 - wmc->cbRect.right;
		}
		else
		{
			wmc->cbRect.cbRight = true;
			wmc->cbRect.pxaRight = 2;
		}
	}
}

void JH2_JudgeHitMyCharBlock_L(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->y - we->cbRect.top <= (Y * 0x10 + offset + 4)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 4)
		&& we->x - we->cbRect.left <= (X * 0x10 + offset + 8)
		&& we->x - we->cbRect.left >= X * 0x10 + offset)
	{
		if (we->cbRect.enableSoild)
		{
			we->x = (X * 0x10 + +offset + 8) + we->cbRect.left;
			if (we->vx < 0)
				we->vx = 0;
		}
		we->cbRect.cbLeft = true;
		we->cbRect.pxaLeft = pxa;
	}
}

void JH2_JudgeHitMyCharBlock_R(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->y - we->cbRect.top <= (Y * 0x10 + offset + 4)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 4)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 8)
		&& we->x + we->cbRect.right <= X * 0x10 + offset)
	{
		if (we->cbRect.enableSoild)
		{
			we->x = (X * 0x10 + offset - 8 ) - we->cbRect.right;
			if (we->vx > 0)
				we->vx = 0;
		}
		we->cbRect.cbRight = true;
		we->cbRect.pxaRight = pxa;
	}
}

void JH2_JudgeHitMyCharBlock_T(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 5)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 5)
		&& we->y - we->cbRect.top <= (Y * 0x10 + offset + 8)
		&& we->y - we->cbRect.top >= Y * 0x10 + offset)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset + 8 ) + we->cbRect.top;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH2_JudgeHitMyCharBlock_D(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 5)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 5)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 8)
		&& we->y + we->cbRect.bottom <= Y * 0x10 + offset)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset - 8 ) - we->cbRect.bottom;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleA(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y - we->cbRect.top <= (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 + 4
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 + 4 + we->cbRect.top;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleB(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y - we->cbRect.top <= (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 - 4
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 - 4 + we->cbRect.top;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleC(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y - we->cbRect.top <= (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 - 4
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 - 4 + we->cbRect.top;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleD(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y - we->cbRect.top <= (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 + 4
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 + 4 + we->cbRect.top;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleE(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 8)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 8)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 9)
		&& we->y + we->cbRect.bottom <= Y * 0x10 + offset)
		we->cbRect.onSlopeLSide = true;
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 - 4
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 - 4 - we->cbRect.bottom;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.onSlopeL = true;
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleF(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 8)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 8)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 9)
		&& we->y + we->cbRect.bottom <= Y * 0x10 + offset)
		we->cbRect.onSlopeLSide = true;
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 + 4
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) / 2 + 4 - we->cbRect.bottom;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.onSlopeL = true;
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleG(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 8)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 8)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 9)
		&& we->y + we->cbRect.bottom <= Y * 0x10 + offset)
		we->cbRect.onSlopeRSide = true;
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 + 4
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 + 4 - we->cbRect.bottom;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.onSlopeR = true;
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleH(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 8)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 8)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 9)
		&& we->y + we->cbRect.bottom <= Y * 0x10 + offset)
		we->cbRect.onSlopeRSide = true;
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 - 4
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) / 2 - 4 - we->cbRect.bottom;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.onSlopeR = true;
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleI(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y - we->cbRect.top <= (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset))
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) + we->cbRect.top;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleJ(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y - we->cbRect.top <= (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset))
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) + we->cbRect.top;
			if (we->vy < 0)
				we->vy = 0;
		}
		we->cbRect.cbTop = true;
		we->cbRect.pxaTop = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleK(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 8)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 8)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 9)
		&& we->y + we->cbRect.bottom <= Y * 0x10 + offset)
		we->cbRect.onSlopeLSide = true;
	if (we->x < X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset))
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) + (we->x - (X * 0x10 + offset)) - we->cbRect.bottom;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.onSlopeL = true;
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH2_JudgeHitMyCharTriangleL(std::shared_ptr<Entity>& we, int X, int Y, int offset, int pxa)
{
	if (we->x - we->cbRect.left <= (X * 0x10 + offset + 8)
		&& we->x + we->cbRect.right >= (X * 0x10 + offset - 8)
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset - 9)
		&& we->y + we->cbRect.bottom <= Y * 0x10 + offset)
		we->cbRect.onSlopeRSide = true;
	if (we->x <= X * 0x10 + offset + 8
		&& we->x >= X * 0x10 + offset - 8
		&& we->y + we->cbRect.bottom >= (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset))
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 8)
	{
		if (we->cbRect.enableSoild)
		{
			we->y = (Y * 0x10 + offset) - (we->x - (X * 0x10 + offset)) - we->cbRect.bottom;
			if (we->vy > 0)
				we->vy = 0;
		}
		we->cbRect.onSlopeR = true;
		we->cbRect.cbBottom = true;
		we->cbRect.pxaBottom = pxa;
	}
}

void JH2_JudgeHitMyCharWater(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->cbRect.fullWaterBlock)
	{
		if (we->x - we->cbRect.left <= X * 0x10 + offset + 8
			&& we->x + we->cbRect.right >= X * 0x10 + offset - 8
			&& we->y - we->cbRect.top <= Y * 0x10 + offset + 8
			&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 8)
		{
			we->cbRect.inWater = true;
		}
	}
	else
	{
		if (we->x - we->cbRect.left <= X * 0x10 + offset + 5
			&& we->x + we->cbRect.right >= X * 0x10 + offset - 5
			&& we->y - we->cbRect.top <= Y * 0x10 + offset + 5
			&& we->y + we->cbRect.bottom >= Y * 0x10 + offset)
		{
			we->cbRect.inWater = true;
		}
	}
}

void JH_JudgeHitMyCharVectL(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 4;
	}
}

void JH_JudgeHitMyCharVectLU(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 7;
	}
}

void JH_JudgeHitMyCharVectU(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 8;
	}
}

void JH_JudgeHitMyCharVectRU(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 9;
	}
}

void JH_JudgeHitMyCharVectR(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 6;
	}
}

void JH_JudgeHitMyCharVectLD(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 1;
	}
}

void JH_JudgeHitMyCharVectD(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 2;
	}
}

void JH_JudgeHitMyCharVectRD(std::shared_ptr<Entity>& we, int X, int Y, int offset)
{
	if (we->x - we->cbRect.left <= X * 0x10 + offset + 6
		&& we->x + we->cbRect.right >= X * 0x10 + offset - 6
		&& we->y - we->cbRect.top <= Y * 0x10 + offset + 6
		&& we->y + we->cbRect.bottom >= Y * 0x10 + offset - 6)
	{
		we->cbRect.inWind = true;
		we->cbRect.windDir = 3;
	}
}

bool JH_BreakStarBlock(std::shared_ptr<Entity>& we, int X, int Y, int offset,
	std::vector<LONG>& pxmData, std::map<LONG, LONG>& updatedPxmArr, int pxmArr_w)
{
	if (!we->cbRect.breakStarBlock)
		return false;
	MyRect src, dst;
	src.Set1(X * 16.0f, Y * 16.0f, 16.0f, 16.0f);
	dst.Set1(we->x - we->cbRect.left, we->y - we->cbRect.top,
		we->cbRect.left + we->cbRect.right, we->cbRect.top + we->cbRect.bottom);
	if (src.IntersectRect(&dst))
	{
		//ƻש
		LONG updatePos = MAKELONG(X, Y);
		LONG pxaVal = pxmData[Y * pxmArr_w + X] - 1;
		updatedPxmArr.insert(std::make_pair(updatePos, pxaVal));
		pxmData[Y * pxmArr_w + X] = pxaVal;
		we->damaged_counter = we->damaged_limit;
		we->Feedback(std::weak_ptr<Entity>());
		return true;
	}
	return false;
}

