#pragma once
#include "global.h"
#include "Entity.h"
#include "EntityRes.h"
#include "MyView.h"
#include "UiBossHpBar.h"
//ϷϷ
class GameUI
{
public:
	GameUI();
	virtual ~GameUI();
	void Init(MyDX11Renderer* pRenderer, MyView* pView, EntityRes* entityResCopy);
	void Reset();
	void OnResetScale();
	void Step();
	void Draw(float deltaTime);
	void SetVisible(bool bVisiable);
	PlayerUIData* GetPlayerUIData(int playerIndex);
	UiBossHpBar* GetBossHpBar();
	std::weak_ptr<Entity>* GetPlayerKey(int playerIndex);
	void Swap();
private:
	void DrawPlayerBoard();//UI
	void DrawPlayer1UI();//1UI
	void DrawPlayer2UI();//2UI
	void DrawAddNum(float srcX, float srcY, float dstX, float dstY, int num, bool order = false);//
	void DrawAddOxygenNum(float srcX, float srcY, float dstX, float dstY, int num, bool order = false);//ƴ
	MyDX11Renderer* pRenderer = nullptr;
	MyView* pView = nullptr;
	EntityRes entityRes;
	bool showPlayer2UI = false;//2UI
	//1
	PlayerUIData player1UI;
	//2
	PlayerUIData player2UI;
	bool bVisiable = false;
	//Чʵ
	std::list<std::shared_ptr<Entity>> Ui;//ʵ
	MyView uiView;
	//UIλÿ
	float offY = 0;
	//Ч
	int bubbleInterval = 0;
	void BubbleStep();
	//Ͷﶯ
	void ThrowItemStep();
	//˸
	void FlashStep();
	//ܰʾ
	std::list<std::shared_ptr<Entity>> ui_player1Key;//ʵ
	std::list<std::shared_ptr<Entity>> ui_player2Key;//ʵ
	std::weak_ptr<Entity> keyArrPlayer1[20];//ָֻ
	std::weak_ptr<Entity> keyArrPlayer2[20];
	//Bossս
	UiBossHpBar bossHpBar;
};

