#include "GamePid.h"
#include <tinyxml2.h>
#include "main.h"
PidData* GamePid::GetPid(const wchar_t* pidName)
{
	auto iter = loadedPid.find(pidName);
	if (iter == loadedPid.end())
	{
		PidData pidData;
		LoadPid(&pidData, pidName);
		loadedPid.insert(std::make_pair(pidName, pidData));
		return &loadedPid.at(pidName);
	}
	return &iter->second;
}

void GamePid::ReloadLanguage()
{
	loadedPid.clear();
}

void GamePid::LoadPid(PidData* outPidData, const wchar_t* pidName)
{
	wchar_t wbuff[MAX_PATH];
	bool languageFolder = false;
	if (language_now.length() == 0)
	{
		swprintf_s(wbuff, L"./data/pid/%s.pid", pidName);
	}
	else
	{
		swprintf_s(wbuff, L"./data/language/%s/pid/%s.pid", language_now.c_str(), pidName);
		languageFolder = true;
	}
	//ļ
	FILE* fp = nullptr;
	if (languageFolder)
	{
		//ȷϷļǷ
		_wfopen_s(&fp, wbuff, L"rb");
	}
	if (!fp)
	{
		//ļڣʹĬļ
		swprintf_s(wbuff, L"./data/pid/%s.pid", pidName);
		_wfopen_s(&fp, wbuff, L"rb");
	}
	if (!fp)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"pidļ%s޷ʧ", wbuff);
		MessageBoxW(hwnd, err, L"Դ", MB_ICONERROR);
		return;
	}
	fseek(fp, 0, SEEK_END);
	size_t fileLen = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	std::vector<BYTE> file_buff;
	file_buff.resize(fileLen);
	fread_s(file_buff.data(), file_buff.size(), fileLen, 1, fp);
	fclose(fp);
	std::vector<BYTE> byte_buff;
	size_t len = 0;
	ZLibUncompressData(&byte_buff, &len, file_buff.data(), fileLen);
	LoadPidXML(outPidData, (const wchar_t*)byte_buff.data());
}

void PidLoadXML(std::unordered_map<std::wstring, AniPrep>* aniList, tinyxml2::XMLElement* xmlElement)
{
	if (xmlElement == nullptr)
		return;
	//趨ǩ
	if (strcmp(xmlElement->Name(), "Animation") == 0)
	{
		AniPrep aniPrep;
		//ȡ
		std::vector<wchar_t> name;
		GBKToUTF16(xmlElement->Attribute("Name"), &name);
		aniPrep.loop = xmlElement->BoolAttribute("Loop");
		aniPrep.speed = xmlElement->IntAttribute("Speed");
		aniPrep.texture_left = xmlElement->IntAttribute("Texture_Left", 16);
		aniPrep.texture_right = xmlElement->IntAttribute("Texture_Right", 16);
		aniPrep.texture_up = xmlElement->IntAttribute("Texture_Up", 16);
		aniPrep.texture_down = xmlElement->IntAttribute("Texture_Down", 16);
		//
		for (auto p = xmlElement->FirstChildElement(); p != nullptr; p = p->NextSiblingElement())
		{
			//LayerԪ
			if (strcmp(p->Name(), "Layer") != 0)
				continue;
			AniLayer layer;
			//α
			for (auto t = p->FirstChildElement(); t != nullptr; t = t->NextSiblingElement())
			{
				//RectԪ
				if (strcmp(t->Name(), "Frame") != 0)
					continue;
				AniFrame frame;
				frame.id = t->IntAttribute("id");
				frame.offx = t->FloatAttribute("offx");
				frame.offy = t->FloatAttribute("offy");
				layer.frameList.push_back(frame);
			}
			aniPrep.layerList.push_back(layer);
		}
		aniList->insert(std::make_pair(name.data(), aniPrep));
		//ӽڵ
		PidLoadXML(aniList, xmlElement->FirstChildElement());
	}
	//ֵܽڵ
	PidLoadXML(aniList, xmlElement->NextSiblingElement());
}

void GamePid::LoadPidXML(PidData* outPidData, const wchar_t* xml)
{
	std::vector<char> gbk_buff;
	UTF16ToGBK(xml, &gbk_buff);
	tinyxml2::XMLDocument xmlDoc;
	xmlDoc.Parse(gbk_buff.data());
	tinyxml2::XMLElement* elem = nullptr;
	//ѰTileSetԪ
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "TileSet"))
		{
			elem = pElem;
			break;
		}
	}
	if (elem)
	{
		//ȡTileSet
		outPidData->pid_tile_w = elem->IntAttribute("TileW");
		outPidData->pid_tile_h = elem->IntAttribute("TileH");
		outPidData->bInterArea = elem->BoolAttribute("InterArea");
	}
	//ѰPidԪ
	elem = nullptr;
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "Pid"))
		{
			elem = pElem;
			break;
		}	
	}
	if (elem)
	{
		//еRectԪ
		for (elem = elem->FirstChildElement(); elem; elem = elem->NextSiblingElement())
		{
			//RectԪ
			if (strcmp(elem->Name(), "Rect"))
				continue;
			//stepֵ
			MyRect rc;
			auto& step = outPidData->pidList;
			rc.left = elem->FloatAttribute("left");
			rc.right = elem->FloatAttribute("right");
			rc.top = elem->FloatAttribute("top");
			rc.bottom = elem->FloatAttribute("bottom");
			int id = elem->IntAttribute("id");
			step[id] = rc;
		}
	}
	//ѰAniԪ
	elem = nullptr;
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "Ani"))
		{
			elem = pElem;
			break;
		}
	}
	if (elem)
	{
		PidLoadXML(&outPidData->aniList, elem->FirstChildElement());
	}
}
