#pragma once
#include "global.h"
//
struct InputSetting_Keyboard
{
	SDL_Scancode op_up = SDL_SCANCODE_UP;
	SDL_Scancode op_down = SDL_SCANCODE_DOWN;
	SDL_Scancode op_left = SDL_SCANCODE_LEFT;
	SDL_Scancode op_right = SDL_SCANCODE_RIGHT;
	SDL_Scancode op_ok = SDL_SCANCODE_Z;
	SDL_Scancode op_cancel = SDL_SCANCODE_X;
	SDL_Scancode op_jump = SDL_SCANCODE_Z;
	SDL_Scancode op_atk = SDL_SCANCODE_X;
	SDL_Scancode op_menu = SDL_SCANCODE_ESCAPE;
	SDL_Scancode op_inventory = SDL_SCANCODE_Q;
	SDL_Scancode op_map = SDL_SCANCODE_W;
	SDL_Scancode op_pagePrev = SDL_SCANCODE_C;
	SDL_Scancode op_pageNext = SDL_SCANCODE_V;
	SDL_Scancode op_switchMc = SDL_SCANCODE_LSHIFT;
	SDL_Scancode op_skill_1 = SDL_SCANCODE_A;
	SDL_Scancode op_skill_2 = SDL_SCANCODE_S;
	SDL_Scancode op_skill_3 = SDL_SCANCODE_D;
	SDL_Scancode op_skill_4 = SDL_SCANCODE_F;
	SDL_Scancode op_skill_5 = SDL_SCANCODE_G;
	SDL_Scancode op_skill_6 = SDL_SCANCODE_H;
};

struct InputSetting_Joystick
{
	InputSetting_Joystick();
	SDL_GameController* pGameController = nullptr;//ĸֱ
	SDL_GameControllerButtonBind op_up;
	SDL_GameControllerButtonBind op_down;
	SDL_GameControllerButtonBind op_left;
	SDL_GameControllerButtonBind op_right;
	SDL_GameControllerButtonBind op_ok;
	SDL_GameControllerButtonBind op_cancel;
	SDL_GameControllerButtonBind op_jump;
	SDL_GameControllerButtonBind op_atk;
	SDL_GameControllerButtonBind op_menu;
	SDL_GameControllerButtonBind op_inventory;
	SDL_GameControllerButtonBind op_map;
	SDL_GameControllerButtonBind op_pagePrev;
	SDL_GameControllerButtonBind op_pageNext;
	SDL_GameControllerButtonBind op_switchMc;
	SDL_GameControllerButtonBind op_skill_1;
	SDL_GameControllerButtonBind op_skill_2;
	SDL_GameControllerButtonBind op_skill_3;
	SDL_GameControllerButtonBind op_skill_4;
	SDL_GameControllerButtonBind op_skill_5;
	SDL_GameControllerButtonBind op_skill_6;
};

struct GameInput
{
	GameInput() = default;
	GameInput(DWORD key);
	static const DWORD keybit_up =        0b00000000000000000000000000000001;
	static const DWORD keybit_down =      0b00000000000000000000000000000010;
	static const DWORD keybit_left =      0b00000000000000000000000000000100;
	static const DWORD keybit_right =     0b00000000000000000000000000001000;
	static const DWORD keybit_ok =        0b00000000000000000000000000010000;
	static const DWORD keybit_cancel =    0b00000000000000000000000000100000;
	static const DWORD keybit_jump =      0b00000000000000000000000001000000;
	static const DWORD keybit_atk =       0b00000000000000000000000010000000;
	static const DWORD keybit_menu =      0b00000000000000000000000100000000;
	static const DWORD keybit_inventory = 0b00000000000000000000001000000000;
	static const DWORD keybit_map =       0b00000000000000000000010000000000;
	static const DWORD keybit_pagePrev =  0b00000000000000000000100000000000;
	static const DWORD keybit_pageNext =  0b00000000000000000001000000000000;
	static const DWORD keybit_switchMc =  0b00000000000000000010000000000000;
	static const DWORD keybit_skill_1 =   0b00000000000000000100000000000000;
	static const DWORD keybit_skill_2 =   0b00000000000000001000000000000000;
	static const DWORD keybit_skill_3 =   0b00000000000000010000000000000000;
	static const DWORD keybit_skill_4 =   0b00000000000000100000000000000000;
	static const DWORD keybit_skill_5 =   0b00000000000001000000000000000000;
	static const DWORD keybit_skill_6 =   0b00000000000010000000000000000000;
	DWORD key = 0;
	bool GetUp();
	bool GetDown();
	bool GetLeft();
	bool GetRight();
	bool GetOk();
	bool GetCancel();
	bool GetJump();
	bool GetAtk();
	bool GetMenu();
	bool GetInventory();
	bool GetMap();
	bool GetPagePrev();
	bool GetPageNext();
	bool GetSwitchMc();
	bool GetSkill_1();
	bool GetSkill_2();
	bool GetSkill_3();
	bool GetSkill_4();
	bool GetSkill_5();
	bool GetSkill_6();
	void SetUp(bool pressed);
	void SetDown(bool pressed);
	void SetLeft(bool pressed);
	void SetRight(bool pressed);
	void SetOk(bool pressed);
	void SetCancel(bool pressed);
	void SetJump(bool pressed);
	void SetAtk(bool pressed);
	void SetMenu(bool pressed);
	void SetInventory(bool pressed);
	void SetMap(bool pressed);
	void SetPagePrev(bool pressed);
	void SetPageNext(bool pressed);
	void SetSwitchMc(bool pressed);
	void SetSkill_1(bool pressed);
	void SetSkill_2(bool pressed);
	void SetSkill_3(bool pressed);
	void SetSkill_4(bool pressed);
	void SetSkill_5(bool pressed);
	void SetSkill_6(bool pressed);
};
