#pragma pack_matrix( row_major )
/*-----------------ȫֶ--------------------*/
struct VSOutput
{
    float4 pos : SV_POSITION;
    float4 color : COLOR;
    float2 tex : TEXCOORD;
};
cbuffer CBuff : register(b0)
{
	matrix mvp;
	float window_w;
	float window_h;
	float scale;
	float offX;
	float offY;
	float texture_w;
	float texture_h;
	float zBuffer;
	float HSV_h;
	float HSV_s;
	float HSV_v;
	float daylight;
}
/*-----------------ɫ--------------------*/
#ifdef VERTEXSHADER
struct VSInput
{
	float3 pos : POSITION;
	float4 color : COLOR;
	float2 tex : TEXCOORD;
};

VSOutput VSMain(VSInput input)
{
	VSOutput vsOut;
	vsOut.pos = mul(float4(input.pos, 1.0f), mvp);
	vsOut.color = input.color;
	vsOut.tex = input.tex;
	return vsOut;
}
#endif

/*----------------------ɫ-------------------------*/
#ifdef PIXELSHADER
Texture2D entitylight : register(t0);
Texture2D stagebuffer : register(t1);
SamplerState splr : register(s0);

float3 RGB2HSV(float3 c)
{
	float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
	float4 p = lerp(float4(c.bg, K.wz), float4(c.gb, K.xy), step(c.b, c.g));
	float4 q = lerp(float4(p.xyw, c.r), float4(c.r, p.yzx), step(p.x, c.r));

	float d = q.x - min(q.w, q.y);
	float e = 1.0e-10;
	return float3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

float3 HSV2RGB(float3 c)
{
	float4 K = float4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	float3 p = abs(frac(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * lerp(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

float4 PSMain(VSOutput vsOut) : SV_TARGET
{
	//ʵɫ
	float4 entityColor = entitylight.Sample(splr, vsOut.tex);
	//̨ɫ
	float4 stageColor = stagebuffer.Sample(splr, vsOut.tex);
	//
	float4 entityLight = entityColor;
	if (entityLight.a < daylight)
		entityLight.a = daylight;
	float4 srcC = stageColor;
	srcC.r *= entityLight.a * entityLight.r;
	srcC.g *= entityLight.a * entityLight.g;
	srcC.b *= entityLight.a * entityLight.b;
	srcC.a = stageColor.a;
	//HSV
	float4 colorAdjust = srcC;
	float3 hsv = RGB2HSV(colorAdjust.rgb);
	float4 outC = float4(HSV2RGB(float3(
		clamp(hsv.x + HSV_h, -1, 1),
		clamp(hsv.y + HSV_s, 0, 1),
		clamp(hsv.z + HSV_v, 0, 1)
	)), colorAdjust.a);
	//ɫ
	return outC;
}
#endif
