#pragma pack_matrix( row_major )
/*-----------------ȫֶ--------------------*/
struct VSOutput
{
    float4 pos : SV_POSITION;
    float4 color : COLOR;
    float2 tex : TEXCOORD;
};
cbuffer CBuff : register(b0)
{
	matrix mvp;
	float window_w;
	float window_h;
	float scale;
	float offX;
	float offY;
	float texture_w;
	float texture_h;
	float zBuffer;
	float HSV_h;
	float HSV_s;
	float HSV_v;
	float daylight;
}
cbuffer CBuff2 : register(b1)
{
	float buffalpha;
}
/*-----------------ɫ--------------------*/
#ifdef VERTEXSHADER
struct VSInput
{
	float3 pos : POSITION;
	float4 color : COLOR;
	float2 tex : TEXCOORD;
};

VSOutput VSMain(VSInput input)
{
	VSOutput vsOut;
	vsOut.pos = mul(float4(input.pos, 1.0f), mvp);
	vsOut.color = input.color;
	vsOut.tex = input.tex;
	return vsOut;
}
#endif

/*----------------------ɫ-------------------------*/
#ifdef PIXELSHADER
Texture2D tex : register(t0);
SamplerState splr : register(s0);

float4 PSMain(VSOutput vsOut) : SV_TARGET
{
	float2 uv_up = vsOut.tex + float2(0, 1 / texture_h) * scale;
	float2 uv_down = vsOut.tex + float2(0, -1 / texture_h) * scale;
	float2 uv_left = vsOut.tex + float2(-1 / texture_w, 0) * scale;
	float2 uv_right = vsOut.tex + float2(1 / texture_w, 0) * scale;

	float4 color_up = tex.Sample(splr, uv_up) * vsOut.color;
	float4 color_down = tex.Sample(splr, uv_down) * vsOut.color;
	float4 color_left = tex.Sample(splr, uv_left) * vsOut.color;
	float4 color_right = tex.Sample(splr, uv_right) * vsOut.color;

	float4 outline = color_up + color_down + color_left + color_right;
	outline.rgb = float3(1, 1, 0);
	outline.a *= buffalpha;
	float4 color_src = tex.Sample(splr, vsOut.tex) * vsOut.color;
	float4 color = outline;
	if (color_src.a == 1)
		color = color_src;
	return color;
}
#endif
