#pragma pack_matrix( row_major )
/*-----------------ȫֶ--------------------*/
struct VSOutput
{
    float4 pos : SV_POSITION;
    float4 color : COLOR;
    float2 tex : TEXCOORD;
};
cbuffer CBuff : register(b0)
{
	matrix mvp;
	float window_w;
	float window_h;
	float scale;
	float offX;
	float offY;
	float texture_w;
	float texture_h;
}
/*-----------------ɫ--------------------*/
#ifdef VERTEXSHADER
struct VSInput
{
	float3 pos : POSITION;
	float4 color : COLOR;
	float2 tex : TEXCOORD;
};

VSOutput VSMain(VSInput input)
{
	VSOutput vsOut;
	vsOut.pos = mul(float4(input.pos, 1.0f), mvp);
	vsOut.color = input.color;
	vsOut.tex = input.tex;
	return vsOut;
}
#endif

/*----------------------ɫ-------------------------*/
#ifdef PIXELSHADER
Texture2D tex : register(t0);
Texture2D backbuff : register(t1);
SamplerState splr : register(s0);

float4 PSMain(VSOutput vsOut) : SV_TARGET
{
	float2 winSize = float2(window_w, window_h);
	float dx = floor(vsOut.pos.x) % (2 * scale);
	float dy = floor(vsOut.pos.y) % (2 * scale);
	float2 uv = (vsOut.pos.xy + float2(-dx, -dy)) / winSize;
	return backbuff.Sample(splr, uv) * vsOut.color;
}
#endif
