#pragma once
#include "global.h"
#include <memory>
#include <unordered_set>
/*--------------------Ĳ----------------------*/
class Entity;
template<typename T>
class Rect;
struct GetRectEntity
{
	Rect<float>& operator()(Entity*) const;
};
template<typename T, typename GetRect, typename Equal>
class Quadtree;
/*---------------------Entityͷ-----------------------*/
//ԶϢ
#define MYDXLIST_SELCHANGED WM_USER + 100
#define MYPICBUTTON_LBUTTONDOWN WM_USER + 101
#define MYPICBUTTON_LBUTTONUP WM_USER + 102
struct MyRGBA
{
	UINT8 r;
	UINT8 g;
	UINT8 b;
	UINT8 a;
	void Set(DWORD c);
	DWORD Get();
};

struct MyTextureAndSRV
{
	ID3D11Texture2D* pTexture = nullptr;
	ID3D11ShaderResourceView* pSRV = nullptr;
};

//趨ʵֱ
struct MyLabelXML
{
	CString name;
};

struct MyCalendarClickZone
{
	MyRect rect;
	int month;
	int day;
	bool diary = false;
};

struct MyCharacterInfo
{
	int id = -1;//id
	CString facePng;//ͷͼƬ
	int lifeType;// 0 1
	CString image;//ӡ
	CString name;//
	CString mcpos;//ɫλ
	CString mcChar;//ɫԸ
	int gender;//Ա 0 1 2
	CString ideal;//
	CString labelXML;//xmlǩ
};

struct MyWorldSet
{
	CString name;
	CString info;
	std::unordered_map<std::wstring, MyLabelXML> labelMap;//ص趨ʵֱ
};

struct MyView;
struct MyViewDrawFor
{
	void Init(MyView* view);
	MyView* view = nullptr;
	//for
	int draw_xMax, draw_yMax;
	int count_h;
	float rc_draw_x, rc_draw_y, rc_draw_w, rc_draw_h;
	int _x, _y;
	//ѭ
	void DrawForYBegin(int** outY = nullptr);
	bool DrawForY();
	void DrawForYInc();
	void DrawForXBegin(int** outX = nullptr);
	bool DrawForX(MyRect* outRect = nullptr);
	void DrawForXInc();
};

//༭ͼ
struct MyView
{
	void Init(CDialog* dlg, MyDX11Renderer* pRenderer);
	void Reset();
	CDialog* dlg = nullptr;
	MyDX11Renderer* pRenderer = nullptr;//Ⱦ
	float scale = 4;//༭ͼų̶
	float offX = 0, offY = 0;//
	float window_w = 0, window_h = 0;//Ŀ괰ڴС
	float grid_w = 16, grid_h = 16;//С
	int count_w = 16, count_max = 32;//
	//ʾק
	bool moveMode = false;//Ƿק״̬
	CPoint moveStartPos;//קʼ
	float offX_start = 0, offY_start = 0;//קʼԭ
	//
	int cursorX = 0, cursorY = 0;//ǰĹλ
	int cursorW = 1, cursorH = 1;//ǰĴС
	int cursorX_selected = 0, cursorY_selected = 0;//ǰĹλ
	int cursorW_selected = 1, cursorH_selected = 1;//С
	int cursorX_last = 0, cursorY_last = 0;
	bool selecting = false;//ѡ
	bool drawSelectedCursor = true;//ѡ
	bool allowSelectOut = false;//Ƶ
	//ѡ
	void BeginSelect(CPoint pt);
	void Select(CPoint pt);
	void EndSelect();
	//ƹ
	void DrawTransparentBk(DWORD c1 = RGBA(0x80, 0x80, 0x80, 0xff), DWORD c2 = RGBA(0xc0, 0xc0, 0xc0, 0xff));//͸
	void DrawBorderLine(bool center = false);//Ʊ߽
	void DrawGrid(DWORD c = RGBA(0xff, 0, 0xff, 0xff));//
	void DrawCursor();//ƹ
	//ڱ༭
	void WindowBind_OnRButtonDown(CPoint point);
	void WindowBind_OnRButtonUp();
	void SetScrollBar();
	//ºΪ棬Ҫ»ơ
	bool WindowBind_OnMouseMove(CPoint point);
	bool WindowBind_OnMouseWheel(short zDelta, CPoint pt);
	bool WindowBind_OnVScroll(UINT nSBCode, UINT nPos);
	bool WindowBind_OnHScroll(UINT nSBCode, UINT nPos);
};


struct MyUndoRedoDataOp
{
	void* (*NewData)() = nullptr;
	void* (*NewCopyOfData)(void*) = nullptr;
	void (*ReleaseData)(void*) = nullptr;
};

struct MyUndoRedo
{
	MyUndoRedo() = default;
	MyUndoRedo(const MyUndoRedo& src);//ʵ
	MyUndoRedo& operator=(const MyUndoRedo& src);//ʵ
	~MyUndoRedo();
	bool canStep = false;
	int maxSize = 10;//
	std::unordered_map<std::string, MyUndoRedoDataOp> dataOpMap;//ͱ
	std::unordered_map<std::string, void*> step;//
	std::unordered_map<std::string, std::list<void*>> redo;
	std::unordered_map<std::string, std::list<void*>> undo;
	std::list<std::string> dataTypeList_redo;//˳
	std::list<std::string> dataTypeList_undo;//˳
	void AddDataType(const char* dataTypeName, MyUndoRedoDataOp op);
	void BeginStep(const char* dataTypeName);
	void EndStep();//βҪUpdateUndoRedoMenuState();
	void Undo();
	void Redo();
	bool UndoEmpty();
	bool RedoEmpty();
	void Clear();
	void ClearUndoRedo();
	void* GetStep(const char* dataTypeName);
};

//֡
struct MyAniFrame
{
	int id = 0;//pid
	float offx = 0;
	float offy = 0;
};
bool operator ==(const MyAniFrame& l, const MyAniFrame& r);

//
struct MyAniLayer
{
	std::vector<MyAniFrame> rcList;
};
bool operator ==(const MyAniLayer& l, const MyAniLayer& r);

#define CANIEDITOR_DATATYPE_ANI_STR "std::vector<MyAniLayer>"
#define CANIEDITOR_DATATYPE_ANI std::vector<MyAniLayer>
//
struct MyAniSet
{
	MyAniSet();
	int playSpeed = 6;//ٶ
	bool loop = false;//ѭ
	int texture_up = 16;
	int texture_down = 16;
	int texture_left = 16;
	int texture_right = 16;
	MyUndoRedo undoRedo;//
	CANIEDITOR_DATATYPE_ANI* GetStep();
};
bool operator ==(const MyAniSet& l, const MyAniSet& r);

//ʵ
struct EntityFlag
{
	//
	bool tCheck = false;//ʱ¼
	bool tTouch = false;//Ӵʵʱ¼
	bool tDeath = false;//ʱ¼
	bool tCrush = false;//ƶƽ̨ѹʱ¼
	bool tHurt = false;//ʵʱ¼
	bool tDamage = false;//ʵ˺ʱ¼
	//ͼ
	bool fShow = false;//idʱڵͼʱ
	bool fHide = false;//idʱڵͼʱʧ
	//
	bool skShow = false;//skʱڵͼʱ
	bool skHide = false;//skʱڵͼʱʧ
	//ѡ
	bool lr = false;//Է
	bool text = false;//ıڲ˵
	bool save = false;//ʵͨϷ¼ؽбȡ
	bool simpAni = false;//ʹ0Ŷ ʵIDΪpngļ
};
bool operator ==(const EntityFlag& l, const EntityFlag& r);

//ʵؽṹ
struct EntityLoad
{
	std::wstring name;//ʵ
	int x = 0, y = 0;//
	std::wstring eid;//ʵ
	std::wstring eventName;//¼
	std::wstring arg;//ò
	std::wstring arg2;//ò
	std::wstring arg3;//ò
	EntityFlag flag;//
};
bool operator ==(const EntityLoad& l, const EntityLoad& r);

#define CMAPEDITOR_DATATYPE_PXM_STR "std::unordered_map<LONG,LONG>"
#define CMAPEDITOR_DATATYPE_PXM std::unordered_map<LONG,LONG>
#define CMAPEDITOR_DATATYPE_PXE_STR "std::unordered_map<int,EntityLoad>"
#define CMAPEDITOR_DATATYPE_PXE std::unordered_map<int,EntityLoad>
#define CPXAEDITOR_DATATYPE_PXA_STR "std::unordered_map<LONG, int>"
#define CPXAEDITOR_DATATYPE_PXA std::unordered_map<LONG, int>

class Entity;
struct MapLayer;
//״̬
struct CbRect
{
	//ѡ
	bool enableCbRect = false;//ײ㣨ӴǽõӴǽͣ
	bool enableSoild = false;//ǽżӴǽ壬ǽѸſ
	bool enableSelfSoild = false;//ǽ壨ʵſ
	bool enableMovePlatform = false;//ƽ̨ԣʵſ
	bool ignoreMovePlatform = false;//ƶƽ̨
	bool breakStarBlock = false;//ƻש
	//ʵײΧ
	float left = 8;
	float top = 8;
	float right = 8;
	float bottom = 8;
	//Ƿǽ
	bool cbLeft = 0;
	bool cbTop = 0;
	bool cbRight = 0;
	bool cbBottom = 0;
	//ǽ
	int pxaLeft = 0;
	int pxaTop = 0;
	int pxaRight = 0;
	int pxaBottom = 0;
	//Ƿվб
	bool onSlopeL = false;//б
	bool onSlopeLSide = false;//б
	bool onSlopeR = false;//б
	bool onSlopeRSide = false;//б
	//ǷӴ
	bool onTrap = false;
	//Ӵƶƽ̨
	std::weak_ptr<Entity> movingPlatformLeft;
	std::weak_ptr<Entity> movingPlatformTop;
	std::weak_ptr<Entity> movingPlatformRight;
	std::weak_ptr<Entity> movingPlatformBottom;
	//ˮ
	bool inWater = false;
	bool waterBlock = false;//ܽˮ
	bool fullWaterBlock = false;//ˮײˮײ16x16
	//
	bool inWind = false;
	int windDir = 0;//ķ789456123
	//ҽ
	bool inLava = false;
	int lavaDmg = 127;//ҽ˺
	//
	DWORD roomColor = UINT_MAX;
	std::vector<LONG>* pxmArr = nullptr;
	std::vector<int>* pxaArr = nullptr;
	std::map<LONG, LONG>* updatedPxmArr = nullptr;
	int pxmArr_w = 0;
	int pxaArr_w = 0;
	void (*Collision)(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w) = nullptr;
	SDL_FRect qtRect;
};

//Ż
struct Animation
{
	std::wstring png;//ļ
	std::wstring sprite_index;//
	int image_index = 0;//֡±
	float image_counter = 0;
	float image_counter_speed = 1.0f;//ٶ
	std::set<int> hideLayerList;//صͼб
};

//ɫ
struct EntityShader
{
	bool usingShader = false;//Ƿɫ
	std::wstring ps;//ɫ
	std::wstring vs;//ɫ
	std::vector<float> args;//ɫĲб
};
//ʵ
struct EntityLight
{
	bool usingLight = false;//ǷǷʵ
	void* layer = nullptr;//ͼͼ
};

struct EntityLayer
{
	std::list<std::shared_ptr<Entity>> Ls;//ʵ
	std::list<std::shared_ptr<Entity>> Ls2;//ʾϷʵ
	std::list<std::shared_ptr<Entity>> Am;//ҵ
	std::list<std::shared_ptr<Entity>> Pe;//Ч
	std::vector<std::shared_ptr<Entity>> addList;//ʵ
	std::unordered_set<Entity*> treeCheck;
	Quadtree <Entity*, GetRectEntity, std::equal_to<Entity*>>* quadTree = nullptr;
	virtual ~EntityLayer();
};

//·
struct PathCell
{
	float vec1_x;//
	float vec1_y;
	float dis;
};

//ɵѰ·
struct PathGrid
{
	std::vector<PathCell> vecMap;//ͼ
	void* mapLayer = nullptr;
};

//Ϸܺ
struct GameFunc
{
	void (*PlaySound)(const wchar_t* soundName) = nullptr;//wav
	int (*PlayLoopSound)(const wchar_t* soundName) = nullptr;//ѭ
	void (*StopLoopSound)(int channelID) = nullptr;//ֹͣѭ
	bool (*GetFullScreen)() = nullptr;//Ƿȫ
	void (*SetFullScreen)(bool bFullScreen) = nullptr;//ʾȫ
	bool (*GetShowDebug)() = nullptr;//ǷʾϢ
	void (*SetShowDebug)(bool bShowDebug) = nullptr;//ʾϢ
	void (*EnlargeWindow)() = nullptr;//Ŵ󴰿
	void (*ReduceWindow)() = nullptr;//С
	int (*GetMusicVolume)() = nullptr;//ȡ[0-10]
	void (*SetMusicVolume)(int vol) = nullptr;//
	int (*GetSoundVolume)() = nullptr;//ȡЧ[0-10]
	void (*SetSoundVolume)(int vol) = nullptr;//Ч
	void (*OpenGameController)() = nullptr;//´ӵֱ豸
	void (*GetScanCodeName)(std::vector<wchar_t>* outName, SDL_Scancode key) = nullptr;//ȡɨ
	void (*GetGameControllerKeyName)(std::vector<wchar_t>* outName, void* keyBind) = nullptr;//ȡֱ
	void (*GetGameControllerName)(std::vector<wchar_t>* outName, SDL_GameController* pGameController) = nullptr;//ȡֱ豸
	void (*ResetKeyboard)() = nullptr;//ü״̬
	bool (*GetAnyKeyPress)(SDL_Scancode* outKey) = nullptr;//ȡⰴ
	bool (*GetAnyGameControllerKeyPress)(SDL_GameController* pGameController, void* keyBind) = nullptr;//ȡֱⰴ
	bool (*GetKey)(SDL_Scancode key) = nullptr;//ȡɨǷ
	void (*ResetKeySetting_Player1Keyboard)() = nullptr;//1м̰
	void (*ResetKeySetting_Player1Joystick)() = nullptr;//1ֱ
	void (*ResetKeySetting_Player2Keyboard)() = nullptr;//2м̰
	void (*ResetKeySetting_Player2Joystick)() = nullptr;//2ֱ
	void* (*GetInputSetting_Player1Keyboard)() = nullptr;//ȡ1
	void* (*GetInputSetting_Player1Joystick)() = nullptr;//ȡ1ֱ
	void* (*GetInputSetting_Player2Keyboard)() = nullptr;//ȡ2
	void* (*GetInputSetting_Player2Joystick)() = nullptr;//ȡ2ֱ
	SDL_GameController* (*GetGameControllerFromIndex)(int index) = nullptr;//±ȡֱ豸
	int (*GetPlayer1ControllerType)() = nullptr;//ȡ1
	int (*GetPlayer2ControllerType)() = nullptr;//ȡ2
	void (*SetPlayer1ControllerType)(int type) = nullptr;//1
	void (*SetPlayer2ControllerType)(int type) = nullptr;//2
	void (*LoadConfig)() = nullptr;//Ϸѡ
	void (*SaveConfig)() = nullptr;//Ϸѡ
	void* entityRes = nullptr;//ʵԴָ
	std::weak_ptr<Entity> (*GetMyChar_Player1)(void* entityRes) = nullptr;//ȡ1ʵ
	std::weak_ptr<Entity> (*GetMyChar_Player1_menuKeyboard)(void* entityRes) = nullptr;//ȡ1Ĳ˵ʵ
	std::weak_ptr<Entity> (*GetMyChar_Player2)(void* entityRes) = nullptr;//ȡ2ʵ
	std::weak_ptr<Entity> (*GetMyChar_Player2_menuKeyboard)(void* entityRes) = nullptr;//ȡ2Ĳ˵ʵ
	std::unordered_map<MapLayer*, EntityLayer>* (*GetLoadedEntity)(void* entityRes) = nullptr;//ȡǰеʵ
	void (*GetDisplayInfo)(void* entityRes, float* outWindow_w, float* outWindow_h, float* outScale, float* outOffX, float* outOffY) = nullptr;//ȡʾϢ
	void (*GetMousePos)(void* entityRes, float* pX, float* pY) = nullptr;//ȡӦʵλ
	bool (*InScreen)(void* entityRes, float x, float y) = nullptr;//ǷĻʾΧ
	void (*GridTouch)(void* entityRes, std::weak_ptr<Entity> e, EntityLayer* targetLayer) = nullptr;//ȡʵӴʵ
	void* gameMap = nullptr;//Ϸͼָ
	MapLayer* (*GetMapLayer)(void* gameMap, const wchar_t* layerName);//ȡͼͼ
	void* mapSizeGetter = nullptr;
	void (*GetMapSize)(void* mapSizeGetter, int* outMapW, int* outMapH) = nullptr;//ȡߴ
	void (*SetNewNameOption)(const wchar_t* gameName, int playerNum, int difficulty) = nullptr;//Ϸ
	void (*SetSaveName)(const wchar_t* saveName) = nullptr;//õǰ浵ļ
	void (*DelSave)(const wchar_t* saveName) = nullptr;//ɾ浵
	void (*SaveNameGetRoomName)(std::wstring* outRoomName, const wchar_t* saveName) = nullptr;//浵ȡ
	void (*WriteData)(const wchar_t* eid, const wchar_t* field, const wchar_t* value) = nullptr;//д
	const wchar_t* (*ReadData)(const wchar_t* eid, const wchar_t* field, const wchar_t* defaultVal) = nullptr;//ȡ
	void (*SetPauseMenuBackGame)(bool bBack) = nullptr;//ͣ˵Ϸ
	void (*SetPauseMenuBackTitle)(bool bBack) = nullptr;//ͣ˵ر⻭
	void* dmgNum = nullptr;//˺ָ
	void (*SetDmgNum)(void* dmgNum, int val, float x, float y, int style, std::weak_ptr<Entity> e) = nullptr;//һ˺ֵʾ
	std::shared_ptr<Entity> (*GameCreateEntity)(const wchar_t* name) = nullptr;//һʵڴУdll
	void (*SetEntity)(std::shared_ptr<Entity> parent, std::shared_ptr<Entity> newE) = nullptr;//һʵ
	void* gameScript = nullptr;//Ϸűָ
	void (*StartEvent)(void* gameScript, const wchar_t* eventName, const wchar_t* triggerType) = nullptr;//¼
	bool (*IsLockKeyboard)(void* gameScript) = nullptr;//Ƿ
	bool (*ScriptIsRunning)(void* gameScript) = nullptr;//Ƿ¼
	void* gameUI = nullptr;
	void* (*GetPlayerUIData)(void* gameUI, int playerIndex) = nullptr;//ȡUIʾ
	void (*StopMusic)() = nullptr;//ֹͣ
	void (*ScreenShot)() = nullptr;//ȡͼ
	void (*QuitGame)() = nullptr;//˳Ϸ
	const wchar_t* (*GetLanguage)() = nullptr;//ȡϷ
	void (*SetLanguage)(const wchar_t* lang) = nullptr;//
	void (*GetAllLanguage)(std::vector<std::wstring>* languageList) = nullptr;//ȡе
	void (*ReloadLanguage)() = nullptr;//Ч
	void (*SetLastPlaySlot)(int slotPage, int index) = nullptr;//Ĵ浵λ
	void (*GetLastPlaySlot)(int* outSlotPage, int* outIndex) = nullptr;//ȡĴ浵λ
	std::set<std::wstring>* flagSet = nullptr;//Ϸ
	std::set<std::wstring>* skipSet = nullptr;//
	PathCell* (*GetPath)(std::weak_ptr<Entity> e, float dstX, float dstY, float srcX, float srcY) = nullptr;//ȡѰ·
	bool (*LineTest)(std::weak_ptr<Entity> e, float srcX, float srcY, float dstX, float dstY) = nullptr;//ֱ߲
	void* game = nullptr;
	void (*SetMyChar_Player1)(void* game, std::weak_ptr<Entity> e) = nullptr;//1Ŀʵ
	void (*SetMyChar_Player2)(void* game, std::weak_ptr<Entity> e) = nullptr;//2Ŀʵ
	void (*SetGlobalEntity)(void* game, std::shared_ptr<Entity> we, const wchar_t* globalEntityID) = nullptr;//ʵõȫ
	std::weak_ptr<Entity> (*GetGlobalEntity)(void* game, const wchar_t* globalEntityID) = nullptr;//ȡȫʵָ
	std::unordered_map<std::wstring, std::weak_ptr<Entity>>* (*GetGlobalEntityTable)(void* game) = nullptr;//ȡȫʵָ
	int (*GetPlayerIndex)(void* game, std::weak_ptr<Entity> e) = nullptr;//ȡǰʵ±
	std::weak_ptr<Entity> (*GetPlayerDistance)(void* game, float x, float y) = nullptr;//ȡõ
	std::weak_ptr<Entity>(*GetPlayerDistanceLR)(void* game, float x, float y, int lr) = nullptr;//ȡõһ
	std::weak_ptr<Entity>(*GetPlayerDistanceWithLineTest)(void* game, float x, float y) = nullptr;//ȡõĿֱ
	std::weak_ptr<Entity>(*GetPlayerDistanceLRWithLineTest)(void* game, float x, float y, int lr) = nullptr;//ȡõһĿֱ
	void (*SetQuake)(void* game, int times, int mode) = nullptr;//mode:0С1󶶶
	void (*SetLocalCamera)(void* game, std::weak_ptr<Entity> e, float focusTimes) = nullptr;//þֲ
	void (*UnsetLocalCamera)(void* game, std::weak_ptr<Entity> e) = nullptr;//ȡõλľ۽
	bool (*InBossFight)(void* game) = nullptr;//ǷBossս
	std::weak_ptr<Entity>(*GetCheckEventPlayer)(void* game) = nullptr;//ȡһڵ¼
	int (*PlayerHaveItem)(void* game, const wchar_t* regID) = nullptr;//ӵĳƷ
	int (*PlayerAddItem)(void* game, const wchar_t* regID, int num) = nullptr;//ƷظƷ
	int (*PlayerDeleteItem)(void* game, const wchar_t* regID, int num) = nullptr;//ƳƷ-1ΪƳȫ,ʣ
	int* pGameOption_playerNum = nullptr;
	int* pGameOption_difficulty = nullptr;
	void (*DecodeRecord)(const wchar_t* recordStr, const void** outInputArr, size_t* outDataSize) = nullptr;//¼
	void* slotDrawer = nullptr;
	void (*SlotPageEnableDraw)(void* slotDrawer, bool bEnable) = nullptr;//ô浵ҳ
	void (*SlotPageDrawClear)(void* slotDrawer) = nullptr;//浵ҳб
	void (*SlotPageAddDraw)(void* slotDrawer, const wchar_t* saveName, std::weak_ptr<Entity> player1Icon, std::weak_ptr<Entity> player2Icon) = nullptr;//ҪƵҴ浵Ϣб
	void (*SlotPageReset)(void* slotDrawer) = nullptr;//ô浵ҳ
	void* gameFlash = nullptr;
	void (*SetScreenFlash)(void* gameFlash, int times) = nullptr;//Ļ˸
};

struct PenVertex
{
	float x = 0, y = 0;//
	DWORD c = 0xffffffff;//ɫ
};

//Ϸ
class Entity
	: public std::enable_shared_from_this<Entity>
{
public:
	Entity() = default;
	Entity(int type);
	virtual ~Entity() = default;
	//
	virtual void Init(std::weak_ptr<Entity> self);//ʼ
	virtual void Step();
	virtual void SetState(int stateID, int lr);
	virtual void SetState(std::wstring stateName, int lr);
	virtual void DeltaTime(float deltaTime);//Ƹ
	virtual void Collision();//ִײ
	virtual void ClearCollisionResult();//һεײ
	virtual void BeginMovingPlatform();//ƶƽ̨ڴٶ֮ǰã
	virtual void EndMovingPlatform();//ƶƽ̨ڴٶ֮ã
	virtual void LoadSaveData();//ر
	virtual void WriteSaveData();//д뱣
	virtual bool Touch(std::weak_ptr<Entity> e);//ܺ
	virtual bool DeathByMovingPlatform();//ⱻƶƽ̨ѹ
	virtual bool Pathfinding(float targetX, float targetY, float* outDirX, float* outDirY);//Ѱ·ֻ16x16Сķ
	virtual int GetMapPxa(int x, int y);//ȡͼĳεpxaֵ
	virtual float GetShootingAngle();//ȡ
	virtual void KeepOnSlopes();//б
	virtual void GetCameraPos(float* outX, float* outY);//ȡ
	virtual void ImmUpdate();//ĳЩ
	virtual void KeepInMap();//ˮƽֹͼ
	virtual bool IsOutOfMap(int r = 8);//Ƿڵͼ֮
	virtual void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList);//ȡʵͼ
	virtual void Wind();//ܷӰ
	virtual void Destroy();//ɾʵ
	virtual void CopyFrom(std::shared_ptr<Entity>& another);//ԼһԼͬʵһģһ
	virtual void GetAnimateOffset(float& outDx, float& outDy);//ȡƫ
	//Ϸʼֵ\
	GameFunc* gameFunc = nullptr;
	//Ա
	float x = 0, y = 0;//
	float draw_x = 0, draw_y = 0;//꣨Lerpƣ
	float last_x = 0, last_y = 0;//꣨Lerpƣ
	float vx = 0, vy = 0;//ٶ
	int lr = 0, ud = 0;//
	bool initCheck = false;//ǿInit飬Ϊfalseлᵯʾ
	bool speedDir = false;//岻ʹ÷ʹٶֵΪ򣬸ñӰһЩ񵲼ܵж
	bool noDir = false;//޷ȫ򣩷Է赲̣
	//ʵײ
	CbRect cbRect;
	//ʾͼ
	Animation ani;
	//Ƿʹ
	bool inUsing = true;
	//
	bool hide = false;//ػֹͣʵ Ҳжϲ
	bool drawBeforeOtherEntity = false;//ʵ֮ǰ
	bool drawAfterPlayer = false;//Ƿʾ֮
	bool topDraw = false;//Ƿ񶥼ƣfade֮ϣ
	//
	EntityLoad el;
	//ʼ
	int type = 0;//0ʵ 1 2ҩ 3
	//
	DWORD color = 0xffffffff;//Ⱦɫ
	DWORD input;//Ϸ
	DWORD inputLock;//סϷ
	bool enableAI = false;//AI
	std::weak_ptr<Entity> ai;//AI
	std::wstring aiName;//õAI
	float axis[19];//ҡ˷ òеĻ
	//ʱ
	int coyote_counter = 0;
	int coyote_max = 3;
	//ǷǿʰȡƷ
	bool isItem = false;
	//ڵ¼ң
	bool inCheckingEvent = false;
	bool faceToBackEnd = false;//¼ź
	bool blockJump = false;//ֹ¼
	bool initCollision = true;//һʱִײ
	//ֵ
	int hp = 0;//ֵ
	int hp_max = 0;//ֵ
	int dropExp = 0;//ľ
	//
	int mp = 0;
	int mp_max = 0;
	//
	bool ignoreTrap = false;//
	int ignoreTrap_counter = 0;//ʱ
	int shock_counter = 0;//ζʱ䣨ֻͼƻζ
	//
	std::map<Entity*, int> damaged;//Entity*ֹȡ
	bool attackState = true;//Ƿù״̬ʵã
	int attackState_reset_counter_max = -1;//״̬ʧЧ״̬ʱ䣬 -1Ϊ
	int attackState_reset_counter = -1;
	int damaged_counter = 0;//ѹĴ
	int damaged_limit = 0;// 0
	int damage_reset_counter = -1;//Ŀٴˢ¹֡ʱ䣬 -1Ϊ
	std::weak_ptr<Entity> attackParent;//ĸʵ
	bool isTrap = false;//ʵ壨ʵ᳢Թʵ壩
	virtual bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage);
	virtual void Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy);
	virtual void Feedback(std::weak_ptr<Entity> target);
	virtual void AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage);//Ч
	virtual void AddDamagedEntity(Entity* e);//ⲿdamagedıд
	//ץȡ
	virtual std::weak_ptr<Entity> BeginCaught(std::weak_ptr<Entity> e);//ʼĳλץȡлץȡ״̬Ĳ
	virtual void EndCaught(std::weak_ptr<Entity> e);//ĳλץȡ(˳ץȡ״̬
	float caughtDifficulty = 0;//ץȡõλѶȣһЩֱץȡõλļжã0ǳ򵥣0.5ͨ1ѣ
	bool ignoreCaught = false;//ץȡ
	int ignoreCaught_counter = 0;//ץȡʱ
	//Ӵ
	std::vector<std::weak_ptr<Entity>> touchList;//Ӵʵб
	virtual void GridTouch(EntityLayer* targetLayer = nullptr);//½Ӵʵб
	virtual void AddTouchList(std::weak_ptr<Entity> e);//ⲿtouchListıд
	//Ʒ
	virtual bool Item(std::weak_ptr<Entity> src);//isItem=trueʹãΪʰȡƷʵ壨һңӴãܱĿʰȡ
	virtual void Gain(std::weak_ptr<Entity> item);//ʵ壨һңʰȡƷ
	//һЩϢ
	virtual void ReloadLanguage();//Ϸ
	//㼶 ʵڲ
	MapLayer* mapLayer = nullptr;
	EntityLayer* entityLayer = nullptr;
	//Զ
	std::vector<PenVertex> lineList;
	virtual int AddLine(std::vector<PenVertex>& lineList, int index, float x1, float y1, DWORD c1, float x2, float y2, DWORD c2);
	virtual int AddRect(std::vector<PenVertex>& lineList, int index, float left, float top, float right, float bottom,
		DWORD c_lu, DWORD c_ru, DWORD c_ld, DWORD c_rd);
	virtual int AddArc(std::vector<PenVertex>& lineList, int index, float r, float startAngle, float endAngle, DWORD c_start, DWORD c_end);
	std::vector<PenVertex> fillList;
	virtual int AddFillRect(std::vector<PenVertex>& fillList, int index, float left, float top, float right, float bottom,
		DWORD c_lu, DWORD c_ru, DWORD c_ld, DWORD c_rd);
	virtual int AddFillFadeCircle(std::vector<PenVertex>& fillList, int index, float radius, float featherSize, DWORD c);
	virtual int AddFillFadeRect(std::vector<PenVertex>& fillList, int index, float left, float top, float right, float bottom, float featherSize,
		DWORD c_lu, DWORD c_ru, DWORD c_ld, DWORD c_rd);
	//ɫ
	EntityShader shader;
	//ʵ
	EntityLight light;
	//ȫʵID
	std::wstring globalEntityID;
	//һ
	std::weak_ptr<Entity> self;
};

struct MapLayer
{
	bool visible = true;//Ƿɼ
	std::wstring tempLayerName;//ʱͼ
	//
	std::wstring pxaName;//ʹõĵ
	//ͼ
	int layerType = 0;
	//ͼ
	float offx = 0.0f;//ͼxƫ
	float offy = 0.0f;//ͼyƫ
	float myFar = 0;//Ӱʾƶ
	//ѭ
	bool loopH = false;
	bool loopV = false;
	float speedH = 0;
	float speedV = 0;
	//ͨ
	float order = 100.0f;
	int jumpFrame = 0;//ŵͼ󣬻ȽʵԾ֡
	//
	float dayLight = 1.0f;//
	float tinyHSV[3];//ϸ΢HSV
	float lightConst = 1.0f;//յĹӰ0-1
	//ɫ
	DWORD color;//rgbaȾɫ
	//Ƽ
	bool enableClipZone = false;
	MyRect clipZone;
};
//ͼͼ
struct MyMapLayer : 
	public MapLayer
{
	//༭
	int nextPxeID = 0;
	int selected_entity = -1;//ѡʵ
	//ʵеĵͼ
	std::vector<LONG> pxmArr;//pxm
	std::map<LONG, LONG> updatedPxmArr;//µpxm
	int pxmArr_w = 0;
	int pxmArr_h = 0;
	void UpdatePxmArr(int pxaArr_w);//step_pxmݸµpxmArr
	//֡Ծ
	int jumpFrame_counter = 0;
	//
	MyUndoRedo undoRedo;
	CMAPEDITOR_DATATYPE_PXM* GetPxmStep();
	CMAPEDITOR_DATATYPE_PXE* GetPxeStep();
	bool operator <(const MyMapLayer& r) const;
};
bool operator ==(const MyMapLayer& l, const MyMapLayer& r);

//ͼ
struct MyMapSet
{
	std::wstring mapName;//ͼʾ
	int mapW, mapH;//ͼߴ
	std::unordered_map<std::wstring, MyMapLayer> layerList;//ͼб
};
bool operator ==(const MyMapSet& l, const MyMapSet& r);
CString StrAddLr(CString text);//ıس XMLı\r

struct PxaData
{
	CPXAEDITOR_DATATYPE_PXA pxa;
	int tileW;
	int tileH;
	//ʵеĵͼ
	std::vector<int> pxaArr;
	int pxaArr_w = 0;
	int pxaArr_h = 0;
	void UpdatePxaArr();//pxaݸµpxaArr
};