#pragma once
#include "global.h"
#include "MyStructDef.h"
//DirectX11Ⱦб
struct CMyDXListDrawView
{
	float offY = 0;//ԭ
	float window_w = 0, window_h = 0;//ͻС
	float lineHeight;//и
	int selected = -1;//ѡ±
	float icon_w, icon_h;//Сͼʾߴ
};
struct CMyDXListDrawItem
{
	CString name;//бʾ
	CString png;//бʾͼƬ
};

class CMyDXList : public CDialog
{
	DECLARE_DYNAMIC(CMyDXList)
	DECLARE_MESSAGE_MAP()
public:
	CMyDXList(CWnd* pParent = nullptr);   // ׼캯
	virtual ~CMyDXList();
	// Ի
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_CMYDXLIST };
#endif
	void Draw();
	void Init(float lineHeight, float icon_w, float icon_h);
	void SetCurSel(int index);
	int GetCurSel();
	void AddItem(CString text, CString picName);
	void SetMenu(int selectedMenu, int notSelectedMenu = 0);
	void Clear();
	bool Empty();
protected:
	void DoDataExchange(CDataExchange* pDX) override;
	BOOL OnInitDialog() override;
public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
private:
	void UpdateSel(CPoint point);
	void SetVScrollBar();
	void SendSelChangeMsg();
	ID3D11ShaderResourceView* GetTexture(CString pngName);
	std::vector<CMyDXListDrawItem> itemList;
	std::unordered_map<std::wstring, MyTextureAndSRV> loadedTexture;
	MyDX11Renderer pRenderer;
	CMyDXListDrawView view;
	TTF_Font* pFont_simsun70 = nullptr;
	std::unordered_map<wchar_t, MyFontData> pFontMap70;
	int selectedMenu, notSelectedMenu;
public:
	
};

