#include "CMapEditorDraw.h"
#include "resource.h"
#include "CMapEditor.h"

IMPLEMENT_DYNAMIC(CMapEditorDraw, CDialog)

BEGIN_MESSAGE_MAP(CMapEditorDraw, CDialog)
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEWHEEL()
	ON_WM_MOUSEMOVE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
END_MESSAGE_MAP()

CMapEditorDraw::CMapEditorDraw(CWnd* pParent)
	: CDialog(IDD_CMAPEDITOR_DRAW, pParent)
{
}

CMapEditorDraw::~CMapEditorDraw()
{
	if (pFont_simsun28)
		TTF_CloseFont(pFont_simsun28);
	for (auto& p : pFontMap28)
	{
		if (p.second.pTexture)
			p.second.pTexture->Release();
		if (p.second.pSRV)
			p.second.pSRV->Release();
	}
	for (auto& p : loadedTexture)
	{
		if (p.second.pSRV &&
			p.second.pSRV != tas_nullpxa.pSRV)
		{
			p.second.pSRV->Release();
			p.second.pSRV = nullptr;
		}
		if (p.second.pTexture &&
			p.second.pTexture != tas_nullpxa.pTexture)
		{
			p.second.pTexture->Release();
			p.second.pTexture = nullptr;
		}
	}
	loadedTexture.clear();
	if (tas_pxatype.pSRV)
		tas_pxatype.pSRV->Release();
	if (tas_pxatype.pTexture)
		tas_pxatype.pTexture->Release();
	if (tas_nullpxa.pSRV)
		tas_nullpxa.pSRV->Release();
	if (tas_nullpxa.pTexture)
		tas_nullpxa.pTexture->Release();
	pRenderer.ClearBuffer(&stageBuffer);
	pRenderer.ClearBuffer(&entityLight);
}

MyView* CMapEditorDraw::GetMyView()
{
	return &view;
}

extern bool g_DisableSound;
void CMapEditorDraw::Draw(bool timeCounterDraw)
{
	//ڲţֻtimeCounterDrawĻ
	if (*pPlaying && !timeCounterDraw)
		return;
	auto parentEditor = (CMapEditor*)pParentEditor;
	pRenderer.RenderClear();
	if (parentEditor->IsLoaded())
	{
		auto selectLayer = parentEditor->GetSelectLayer();
		view.count_w = *pMapW;
		view.count_max = *pMapH * view.count_w;
		//͸
		if (parentEditor->Bk())
			view.DrawTransparentBk();
		//ÿһͼ
		pMtx->lock();
		//֡ʵ
		for (auto& layer : *pDrawLayer)
		{
			if (!layer->visible)
				continue;
			entityRes.SetCollisionEntityLayer(layer, GetPxa(layer->pxaName.c_str()));
			while (layer->jumpFrame_counter > 0)
			{
				g_DisableSound = true;
				entityRes.StepEntityLayerPe(layer);
				g_DisableSound = false;
				layer->jumpFrame_counter--;
			}
		}
		//̨
		DrawStage(timeCounterDraw, selectLayer);
		for (auto& layer : *pDrawLayer)
		{
			if (!layer->visible)
				continue;
			if (parentEditor->EntityShow())
				entityRes.DrawEntityLayer(layer, *pPlaying, true);
		}
		pMtx->unlock();
		//Ƶ
		if (selectLayer &&
			selectLayer->visible && 
			selectLayer->layerType != 2 &&
			parentEditor->Pxa())
			DrawPxa(selectLayer);
		//
		if (parentEditor->Grid())
			view.DrawGrid();
		//ʵ
		if (selectLayer &&
			parentEditor->Entity())
		{
			if (*pPlaying)
				entityRes.DrawEntityCbRectLayer(selectLayer);
			else
				DrawEntityGrid(selectLayer);
			DrawRecordGoal();
		}
		//ʵǩ
		if (selectLayer && 
			parentEditor ->EntityLabel())
			DrawEntityLabel(selectLayer);
		//ѡвԼ
		if (selectLayer)
		{
			MyView srcView = view;
			view.offX += selectLayer->offx;
			view.offY += selectLayer->offy;
			view.DrawBorderLine();
			if (selectLayer->enableClipZone)
				DrawClipRect(selectLayer);
			view.DrawCursor();
			view = srcView;
		}
	}
	pRenderer.RenderPresent();
}

void CMapEditorDraw::ResetContext()
{
	RefreshImage();
	view.Reset();
	ResetEntityPlay();
}

void CMapEditorDraw::RefreshImage()
{
	for (auto& p : loadedTexture)
	{
		if (p.second.pSRV &&
			p.second.pSRV != tas_nullpxa.pSRV)
		{
			p.second.pSRV->Release();
			p.second.pSRV = nullptr;
		}
		if (p.second.pTexture &&
			p.second.pTexture != tas_nullpxa.pTexture)
		{
			p.second.pTexture->Release();
			p.second.pTexture = nullptr;
		}
	}
	loadedTexture.clear();
	loadedPxa.clear();
	entityRes.RefreshImage();
}

void CMapEditorDraw::ResetEntityPlay()
{
	entityRes.Reset();
	pMtx->lock();
	//̨
	for (auto& layer : *pDrawLayer)
		layer->jumpFrame_counter = layer->jumpFrame;
	pMtx->unlock();
}

void CMapEditorDraw::SetCursorToCopyBuffSize()
{
	view.cursorW = copyBuff_w;
	view.cursorH = copyBuff_h;
}

EntityRes* CMapEditorDraw::GetEntityRes()
{
	return &entityRes;
}

void CMapEditorDraw::GetCopyBoard(CMAPEDITOR_DATATYPE_PXM** outCopyBuff, int** outCopyBuff_w, int** outCopyBuff_h)
{
	*outCopyBuff = &copyBuff;
	*outCopyBuff_w = &copyBuff_w;
	*outCopyBuff_h = &copyBuff_h;
}

void CMapEditorDraw::UpdateMapCache()
{
	if (*pPlaying)
	{
		entityRes.UpdatePathFinder();
		auto parentEditor = (CMapEditor*)pParentEditor;
		parentEditor->UpdateMapCache();
	}
}

PxaData* CMapEditorDraw::GetPxa(CString pxaName)
{
	if (loadedPxa.find(pxaName.GetString()) == loadedPxa.end())
	{
		PxaData pxaData;
		CPxaEditor::StaticLoad(pxaName, &pxaData.pxa, &pxaData.tileW, &pxaData.tileH);
		pxaData.UpdatePxaArr();
		loadedPxa.insert(std::make_pair(pxaName.GetString(), pxaData));
	}
	return &loadedPxa.at(pxaName.GetString());
}

void CMapEditorDraw::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BOOL CMapEditorDraw::OnInitDialog()
{
	CDialog::OnInitDialog();
	//ʼȾ
	pRenderer.Init(m_hWnd);
	//ʼ
	pFont_simsun28 = pRenderer.MyLoadFont("simsun", 28);
	view.Init(this, &pRenderer);
	view.count_w = 40;
	view.count_max = 23 * view.count_w;
	view.drawSelectedCursor = false;
	//ʵ岥
    entityRes.Init(&pRenderer, &view, pMapW, pMapH);
	//Դ
	LoadResourceTexture(&pRenderer, IDB_PXATYPE, &tas_pxatype.pTexture, &tas_pxatype.pSRV);
	LoadResourceTexture(&pRenderer, IDB_NULLPXA, &tas_nullpxa.pTexture, &tas_nullpxa.pSRV);
	return 0;
}

void CMapEditorDraw::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	if (!view.pRenderer)
		return;
	view.window_w = (float)cx;
	view.window_h = (float)cy;
	pRenderer.OnSize(cx, cy, nType == SIZE_MINIMIZED);
	pRenderer.SetBufferSize(cx, cy, &stageBuffer, "stageBuffer");
	pRenderer.SetBufferSize(cx, cy, &entityLight, "entityLight");
}

void CMapEditorDraw::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	// ΪͼϢ CDialog::OnPaint()
	Draw();
}

void CMapEditorDraw::OnLButtonDown(UINT nFlags, CPoint point)
{
	//༭ͼ
	auto parentEditor = (CMapEditor*)pParentEditor;
	bool bUpdateShadowTable = false;
	if (parentEditor->IsEditMapMode())
	{
		MyMapLayer* layer = parentEditor->GetSelectLayer();
		if (layer && layer->visible)
		{
			MyView& brushView = *pBrushView;
			auto& step = *layer->GetPxmStep();
			switch (parentEditor->GetPaintMode())
			{
			case 5://ճ
				if (copyBuff.empty())
					break;
			case 0://Ϳ
				painting = true;
				paintStartCursorPosX = view.cursorX;
				paintStartCursorPosY = view.cursorY;
				layer->undoRedo.BeginStep(CMAPEDITOR_DATATYPE_PXM_STR);
				DrawTile();
				break;
			case 1://滻
				{
					layer->undoRedo.BeginStep(CMAPEDITOR_DATATYPE_PXM_STR);
					LONG srcPxa = step[MAKELONG(view.cursorX, view.cursorY)];
					for (auto& p : step)
						if (p.second == srcPxa)
							p.second = MAKELONG(brushView.cursorX_selected, brushView.cursorY_selected);
					layer->undoRedo.EndStep();
					bUpdateShadowTable = true;
				}
				break;
			case 2://
				{
					layer->undoRedo.BeginStep(CMAPEDITOR_DATATYPE_PXM_STR);
					int count_h = view.count_max % view.count_w ? view.count_max / view.count_w + 1 : view.count_max / view.count_w;
					LONG srcPxa = step[MAKELONG(view.cursorX, view.cursorY)];
					std::list<int> sp;
					sp.push_back(MAKELONG(view.cursorX, view.cursorY));
					int dx = brushView.cursorW_selected - view.cursorX % brushView.cursorW_selected;
					int dy = brushView.cursorH_selected - view.cursorY % brushView.cursorH_selected;
					while (!sp.empty())
					{
						int x = LOWORD(sp.back());
						int y = HIWORD(sp.back());
						sp.pop_back();
						LONG dstPxa = MAKELONG(brushView.cursorX_selected + (x + dx) % brushView.cursorW_selected,
							brushView.cursorY_selected + (y + dy) % brushView.cursorH_selected);
						step[MAKELONG(x, y)] = dstPxa;
						//ܷҪ
						if (y - 1 >= 0 && step[MAKELONG(x, y - 1)] == srcPxa && srcPxa != dstPxa)//Ϸ
							sp.push_back(MAKELONG(x, y - 1));
						if (y + 1 < count_h && step[MAKELONG(x, y + 1)] == srcPxa && srcPxa != dstPxa)//·
							sp.push_back(MAKELONG(x, y + 1));
						if (x - 1 >= 0 && step[MAKELONG(x - 1, y)] == srcPxa && srcPxa != dstPxa)//
							sp.push_back(MAKELONG(x - 1, y));
						if (x + 1 < view.count_w && step[MAKELONG(x + 1, y)] == srcPxa && srcPxa != dstPxa)//ҷ
							sp.push_back(MAKELONG(x + 1, y));
					}
					layer->undoRedo.EndStep();
					bUpdateShadowTable = true;
				}
				break;
			case 3://
			case 4://
				view.drawSelectedCursor = true;
				view.allowSelectOut = true;
				view.BeginSelect(point);
				break;
			}
		}
	}
	//༭ʵ
	else if (parentEditor->IsEditEntityMode())
	{
		OnMouseMove(nFlags, point);
		MyMapLayer* layer = parentEditor->GetSelectLayer();
		if (layer)
		{
			auto& step_pxe = *layer->GetPxeStep();
			std::list<int> l;
			for (auto& el : step_pxe)
				if (view.cursorX == el.second.x && view.cursorY == el.second.y)
					l.push_back(el.first);
			if (l.empty())
				parentEditor->SelectOutEntity();
			else
			{
				if (l.size() == 1)//ֻͬһʵ
				{
					layer->selected_entity = l.front();
					parentEditor->SelectToEntity();
					*pDragEntity = true;
				}
				else if (layer->selected_entity >= 0)
				{
					parentEditor->SelectToEntity();
					*pDragEntity = true;
				}
				else if (layer->selected_entity < 0)//жʵ
				{
					CString str;
					CMenu m;
					CPoint pt = point;
					m.CreatePopupMenu();
					for (auto& id : l)
					{
						auto iter = step_pxe.find(id);
						if (iter == step_pxe.end())
							continue;
						auto& el = iter->second;
						int entityID = iter->first;
						str.Format(L"ʵ %d - %s", entityID, el.name.c_str());
						m.AppendMenu(MF_ENABLED, 2000 + entityID, str);
					}
					ClientToScreen(&pt);
					m.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
						pt.x, pt.y, parentEditor);
				}
			}
		}
	}
	//Ӱ
	if (bUpdateShadowTable)
		UpdateMapCache();
	Draw();
	parentEditor->UpdateWindowTitle();
	parentEditor->UpdateMenuState();
	CDialog::OnLButtonDown(nFlags, point);
}

void CMapEditorDraw::OnLButtonUp(UINT nFlags, CPoint point)
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	bool bUpdateShadowTable = false;
	bool bDraw = false;
	if (parentEditor->IsEditMapMode())
	{
		MyMapLayer* layer = parentEditor->GetSelectLayer();
		if (layer && layer->visible)
		{
			MyView& brushView = *pBrushView;
			auto& step = *layer->GetPxmStep();
			switch (parentEditor->GetPaintMode())
			{
			case 5://ճ
				if (copyBuff.empty())
					break;
			case 0://Ϳ
				painting = false;
				layer->undoRedo.EndStep();
				bUpdateShadowTable = true;
				break;
			case 3://
				view.drawSelectedCursor = false;
				view.allowSelectOut = false;
				view.EndSelect();
				layer->undoRedo.BeginStep(CMAPEDITOR_DATATYPE_PXM_STR);
				for (int y = 0; y < view.cursorH_selected; y++)
				{
					for (int x = 0; x < view.cursorW_selected; x++)
					{
						if (brushView.cursorW_selected == 0 || brushView.cursorH_selected == 0)
						{
							step.erase(MAKELONG(view.cursorX_selected + x, view.cursorY_selected + y));
						}
						else
						{
							//
							int pxa = MAKELONG(brushView.cursorX_selected + x % brushView.cursorW_selected,
								(brushView.cursorY_selected + y % brushView.cursorH_selected));
							//ʹ0ŵ
							if (pxa || layer->layerType == 2)
								step[MAKELONG(view.cursorX_selected + x, view.cursorY_selected + y)] = pxa;
							else
								step.erase(MAKELONG(view.cursorX_selected + x, view.cursorY_selected + y));
						}
					}
				}
				layer->undoRedo.EndStep();
				bUpdateShadowTable = true;
				bDraw = true;
				break;
			case 4://
				view.drawSelectedCursor = false;
				view.allowSelectOut = false;
				view.EndSelect();
				copyBuff.clear();
				if (layer->layerType == 2)
					layer->undoRedo.BeginStep(CMAPEDITOR_DATATYPE_PXM_STR);
				for (int y = 0; y < view.cursorH_selected; y++)
				{
					for (int x = 0; x < view.cursorW_selected; x++)
					{
						if (layer->layerType == 2)//ѭ
						{
							//ǲ
							step.erase(MAKELONG(view.cursorX_selected + x, view.cursorY_selected + y));
						}
						else
						{
							LONG pxa = step[MAKELONG(view.cursorX_selected + x, view.cursorY_selected + y)];
							if (layer->layerType == 2)//ѭ
							{
								//0ŵ
								copyBuff[MAKELONG(x, y)] = pxa;
							}
							else
							{
								//0ŵ
								if (pxa)
									copyBuff[MAKELONG(x, y)] = pxa;
							}
						}
					}	
				}	
				if (layer->layerType == 2)
				{
					layer->undoRedo.EndStep();
					bUpdateShadowTable = true;
					bDraw = true;
				}
				copyBuff_w = view.cursorW_selected;
				copyBuff_h = view.cursorH_selected;
				break;
			}
		}
	}
	//༭ʵ
	if (*pDragEntity)
	{
		*pDragEntity = false;
		MyMapLayer* layer = parentEditor->GetSelectLayer();
		if (layer)
			layer->undoRedo.EndStep();
	}
	//Ӱ
	if (bUpdateShadowTable)
		 UpdateMapCache();
	if (bDraw)
	{
		Draw();
		parentEditor->UpdateWindowTitle();
		parentEditor->UpdateMenuState();
	}
	CDialog::OnLButtonUp(nFlags, point);
}

void CMapEditorDraw::OnRButtonDown(UINT nFlags, CPoint point)
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	auto layer = parentEditor->GetSelectLayer();
	if (layer)
	{
		view.offX += layer->offx;
		view.offY += layer->offy;
		view.WindowBind_OnRButtonDown(point);
		view.offX -= layer->offx;
		view.offY -= layer->offy;
	}
	else
	{
		view.WindowBind_OnRButtonDown(point);
	}
	//ʵ༭
	rclick_last_pt = point;//Ҽ
	CDialog::OnRButtonDown(nFlags, point);
}


void CMapEditorDraw::OnRButtonUp(UINT nFlags, CPoint point)
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	auto layer = parentEditor->GetSelectLayer();
	if (layer)
	{
		view.offX += layer->offx;
		view.offY += layer->offy;
		view.WindowBind_OnRButtonUp();
		view.offX -= layer->offx;
		view.offY -= layer->offy;
	}
	else
	{
		view.WindowBind_OnRButtonUp();
	}
	//ʵ༭
	if (layer &&
		parentEditor->IsEditEntityMode() &&
		(abs(point.x - rclick_last_pt.x) <= 5 && abs(point.y - rclick_last_pt.y) <= 5))
	{
		// ص˵
		*pDragEntity = false;
		if (layer->selected_entity < 0)
		{
			OnLButtonDown(nFlags, point);
			CMenu m, * pm;
			CPoint pt = point;
			m.LoadMenu(IDR_CMAPEDITOR_ENTITYEDIT_RMENU_NOSEL);
			pm = m.GetSubMenu(0);
			ClientToScreen(&pt);
			pm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
				pt.x, pt.y, this);
		}
		else
		{
			//λõúѡʵһ
			auto& step_pxe = *layer->GetPxeStep();
			auto& el = step_pxe.at(layer->selected_entity);
			if (el.x == view.cursorX && el.y == view.cursorY)
			{
				CMenu m, * pm;
				CPoint pt = point;
				m.LoadMenu(IDR_CMAPEDITOR_ENTITYEDIT_RMENU);
				pm = m.GetSubMenu(0);

				ClientToScreen(&pt);
				pm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
					pt.x, pt.y, this);
			}
			else
			{
				OnLButtonDown(nFlags, point);
				*pDragEntity = false;
			}
		}
	}
	CDialog::OnRButtonUp(nFlags, point);
}

BOOL CMapEditorDraw::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	auto layer = parentEditor->GetSelectLayer();
	if (layer)
	{
		view.offX += layer->offx;
		view.offY += layer->offy;
		bool bDraw = view.WindowBind_OnMouseWheel(zDelta, pt);
		view.offX -= layer->offx;
		view.offY -= layer->offy;
		if (bDraw)
		{
			Draw();
		}
	}
	else
	{
		if (view.WindowBind_OnMouseWheel(zDelta, pt))
		{
			Draw();
		}
	}
	return CDialog::OnMouseWheel(nFlags, zDelta, pt);
}

void CMapEditorDraw::OnMouseMove(UINT nFlags, CPoint point)
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	auto layer = parentEditor->GetSelectLayer();
	MyView& brushView = *pBrushView;
	bool bDraw = false;
	if (layer)
	{
		//תС
		if (parentEditor->IsEditMapMode() && layer->visible)
		{
			switch (parentEditor->GetPaintMode())
			{
			case 5://ճ
				if (view.cursorW != copyBuff_w || 
					view.cursorH != copyBuff_h)
				{
					view.cursorW = copyBuff_w;
					view.cursorH = copyBuff_h;
					bDraw = true;
				}
				break;
			case 0://Ϳ
				if (view.cursorW != brushView.cursorW_selected ||
					view.cursorH != brushView.cursorH_selected)
				{
					view.cursorW = brushView.cursorW_selected;
					view.cursorH = brushView.cursorH_selected;
					bDraw = true;
				}
				break;
			}
		}
		else if (parentEditor->IsEditEntityMode())
		{
			if (view.cursorW != 1 || 
				view.cursorH != 1)
			{
				view.cursorW = view.cursorH = 1;
				bDraw = true;
			}
		}
		//༭ͼ
		switch (parentEditor->GetPaintMode())
		{
		case 5://ճ
			if (copyBuff.empty())
				break;
		case 0://Ϳ
			if (painting)
			{
				DrawTile();
				bDraw = true;
			}	
			break;
		case 3://
		case 4://
			view.Select(point);
			break;
		}
		view.offX += layer->offx;
		view.offY += layer->offy;
		bDraw |= view.WindowBind_OnMouseMove(point);
		view.offX -= layer->offx;
		view.offY -= layer->offy;
		//༭ʵ
		if (*pDragEntity && layer->selected_entity >= 0)
		{
			auto& step_pxe = *layer->GetPxeStep();
			auto& el = step_pxe.at(layer->selected_entity);
			if (el.x != view.cursorX || el.y != view.cursorY)
			{
				layer->undoRedo.BeginStep(CMAPEDITOR_DATATYPE_PXE_STR);
				el.x = view.cursorX;
				el.y = view.cursorY;
				ResetEntityPlay();
				bDraw = true;
			}
		}
	}
	else
	{
		if (view.WindowBind_OnMouseMove(point))
		{
			bDraw = true;
		}
	}
	if (bDraw)
	{
		parentEditor->UpdateWindowTitle();
		Draw();
	}
	CDialog::OnMouseMove(nFlags, point);
}

void CMapEditorDraw::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	auto layer = parentEditor->GetSelectLayer();
	if (layer)
	{
		view.offX += layer->offx;
		view.offY += layer->offy;
		bool bDraw = view.WindowBind_OnVScroll(nSBCode, nPos);
		view.offX -= layer->offx;
		view.offY -= layer->offy;
		if (bDraw)
			Draw();
	}
	else
	{
		if (view.WindowBind_OnVScroll(nSBCode, nPos))
			Draw();
	}
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CMapEditorDraw::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	auto layer = parentEditor->GetSelectLayer();
	if (layer)
	{
		view.offX += layer->offx;
		view.offY += layer->offy;
		bool bDraw = view.WindowBind_OnHScroll(nSBCode, nPos);
		view.offX -= layer->offx;
		view.offY -= layer->offy;
		if (bDraw)
			Draw();
	}
	else
	{
		if (view.WindowBind_OnHScroll(nSBCode, nPos))
			Draw();
	}
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

ID3D11ShaderResourceView* CMapEditorDraw::GetTexture(CString pngName)
{
	if (loadedTexture.find(pngName.GetString()) == loadedTexture.end())
	{
		//ļ
		std::vector<char> gbk;
		CString wstr;
		wstr.Format(L"./data/pxa/%s.png", pngName.GetString());
		UTF16ToGBK(wstr.GetString(), &gbk);

		//ȷļǷ
		FILE* fp;
		fopen_s(&fp, gbk.data(), "rb");
		if (fp)
		{
			fclose(fp);
			MyTextureAndSRV tas;
			pRenderer.MyLoadTexture(&tas.pTexture, gbk.data());
			pRenderer.MyCreateShaderResourceView(&tas.pSRV, tas.pTexture);
			loadedTexture.insert(std::make_pair(pngName.GetString(), tas));
			return tas.pSRV;
		}
		else
		{
			//ʹpxaNull
			loadedTexture.insert(std::make_pair(pngName.GetString(), tas_nullpxa));
			return tas_nullpxa.pSRV;
		}
	}
	return loadedTexture.at(pngName.GetString()).pSRV;
}

void CMapEditorDraw::DrawTile()
{
	auto parentEditor = (CMapEditor*)pParentEditor;
	MyView& brushView = *pBrushView;
	MyMapLayer* layer = parentEditor->GetSelectLayer();
	if (layer == nullptr)
		return;
	auto& step = *layer->GetPxmStep();
	view.cursorX = (view.cursorX - paintStartCursorPosX % view.cursorW) / view.cursorW * view.cursorW + paintStartCursorPosX % view.cursorW;
	view.cursorY = (view.cursorY - paintStartCursorPosY % view.cursorH) / view.cursorH * view.cursorH + paintStartCursorPosY % view.cursorH;
	switch (parentEditor->GetPaintMode())
	{
	case 0://Ϳ
		for (int y = 0; y < brushView.cursorH_selected; y++)
		{
			for (int x = 0; x < brushView.cursorW_selected; x++)
			{
				LONG pxa = MAKELONG(brushView.cursorX_selected + x, brushView.cursorY_selected + y);
				if (layer->layerType == 2)//ѭ
				{
					//ʹ0ŵ
					step[MAKELONG(view.cursorX + x, view.cursorY + y)] = pxa;
				}
				else
				{
					//ʹ0ŵ
					if (pxa)
						step[MAKELONG(view.cursorX + x, view.cursorY + y)] = pxa;
					else
						step.erase(MAKELONG(view.cursorX + x, view.cursorY + y));
				}
			}
		}
		break;
	case 5://ճ
		for (int y = 0; y < copyBuff_h; y++)
		{
			for (int x = 0; x < copyBuff_w; x++)
			{
				LONG pos = MAKELONG(x, y);
				auto iter = copyBuff.find(pos);
				if (iter == copyBuff.end())
					continue;
				LONG pxa = iter->second;
				if (layer->layerType == 2)//ѭ
				{
					//ʹ0ŵ
					step[MAKELONG(view.cursorX + x, view.cursorY + y)] = pxa;
				}
				else
				{
					//ʹ0ŵ
					if (pxa)
						step[MAKELONG(view.cursorX + x, view.cursorY + y)] = pxa;
					else
						step.erase(MAKELONG(view.cursorX + x, view.cursorY + y));
				}
			}
		}
		break;
	}
	
}

void CMapEditorDraw::DrawLayerBack(MyMapLayer* pLayer)
{
	//
	const int limit = 40000;
	int drawCount = 0;
	MyRect rcScreen;
	rcScreen.Set1(0, 0, view.window_w, view.window_h);
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		if (*pPlaying)
		{
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			view.offX -= (1 - farValue) * view.offX;
			view.offY -= (1 - farValue) * view.offY;
		}
	}
	//ûƼ
	if (pLayer->enableClipZone && *pPlaying)
	{
		MyRect clip;
		MyRect& clipRc = pLayer->clipZone;
		clip.left = (clipRc.left) * view.scale - floorf(view.offX * view.scale);
		clip.right = (clipRc.right) * view.scale - floorf(view.offY * view.scale);
		clip.top = (clipRc.top) * view.scale - floorf(view.offY * view.scale);
		clip.bottom = (clipRc.bottom) * view.scale - floorf(view.offY * view.scale);
		pRenderer.SetScissorRect(&clip);
	}
	pRenderer.SetTPenDraw(GetTexture(pLayer->pxaName.c_str()));
	auto& step = *pLayer->GetPxmStep();
	auto& pxaData = *GetPxa(pLayer->pxaName.c_str());
	for (auto& t : step)
	{
		//0ŵ
		if (t.second == 0)
			continue;
		auto iter = pxaData.pxa.find(t.second);
		auto pxaID = 0;
		if (iter != pxaData.pxa.end())
			pxaID = iter->second;
		//Ǳ
		if (!IsBackPxa(pxaID))
			continue;
		float srcX = (float)LOWORD(t.second);
		float srcY = (float)HIWORD(t.second);
		float dstX = (float)LOWORD(t.first);
		float dstY = (float)HIWORD(t.first);
		MyRect src, dst;
		if (*pPlaying && IsWindPxa(pxaID))
		{
			//Ʒ糡
			switch (pxaID)
			{
			case 0x60://
			case 0x70:
				//һ
				src.Set1((srcX + *pWindAniIndex) * pxaData.tileW,
					(srcY + 1) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			case 0x61://
			case 0x71:
				src.Set1((srcX + *pWindAniIndex2) * pxaData.tileW,
					(srcY + 1 + *pWindAniIndex2) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			case 0x62://
			case 0x72:
				src.Set1(srcX * pxaData.tileW,
					(srcY + 1 + *pWindAniIndex) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			case 0x63://
			case 0x73:
				src.Set1((srcX + 1 - *pWindAniIndex2) * pxaData.tileW,
					(srcY + 1 + *pWindAniIndex2) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			case 0x64://
			case 0x74:
				src.Set1((srcX + 1 - *pWindAniIndex) * pxaData.tileW,
					(srcY + 1) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			case 0x65://
			case 0x75:
				src.Set1((srcX + *pWindAniIndex2) * pxaData.tileW,
					(srcY + 2 - *pWindAniIndex2) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			case 0x66://
			case 0x76:
				src.Set1(srcX * pxaData.tileW,
					(srcY + 2 - *pWindAniIndex) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			case 0x67://
			case 0x77:
				src.Set1((srcX + 1 - *pWindAniIndex2) * pxaData.tileW,
					(srcY + 2 - *pWindAniIndex2) * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				break;
			}
		}
		else
		{
			//һ
			src.Set1(srcX * pxaData.tileW,
				srcY * pxaData.tileH,
				(float)pxaData.tileW,
				(float)pxaData.tileH);
		}
		dst.Set1(((dstX * view.grid_w) * view.scale - floorf(view.offX * view.scale)),
			((dstY * view.grid_h) * view.scale - floorf(view.offY * view.scale)),
			view.grid_w * view.scale,
			view.grid_h * view.scale);
		//ԻǷĻ
		if (!rcScreen.IntersectRect(&dst))
			continue;
		pRenderer.AddRenderCopy(&src, &dst, pLayer->color);
		drawCount++;
		if (drawCount >= limit)
			break;
	}
	pRenderer.DrawRenderCopy();
	if (pLayer->layerType == 1)
		view = srcView;
	if (pLayer->enableClipZone && *pPlaying)
		pRenderer.SetScissorRect();
}

void CMapEditorDraw::DrawLayerFront(MyMapLayer* pLayer)
{
	//
	const int limit = 40000;
	int drawCount = 0;
	MyRect rcScreen;
	rcScreen.Set1(0, 0, view.window_w, view.window_h);
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		if (*pPlaying)
		{
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			view.offX -= (1 - farValue) * view.offX;
			view.offY -= (1 - farValue) * view.offY;
		}
	}
	//ûƼ
	if (pLayer->enableClipZone && *pPlaying)
	{
		MyRect clip;
		MyRect& clipRc = pLayer->clipZone;
		clip.left = (clipRc.left) * view.scale - floorf(view.offX * view.scale);
		clip.right = (clipRc.right) * view.scale - floorf(view.offX * view.scale);
		clip.top = (clipRc.top) * view.scale - floorf(view.offY * view.scale);
		clip.bottom = (clipRc.bottom) * view.scale - floorf(view.offY * view.scale);
		pRenderer.SetScissorRect(&clip);
	}
	pRenderer.SetTPenDraw(GetTexture(pLayer->pxaName.c_str()));
	auto& step = *pLayer->GetPxmStep();
	auto& pxaData = *GetPxa(pLayer->pxaName.c_str());
	for (auto& t : step)
	{
		//0ŵ
		if (t.second == 0)
			continue;
		auto iter = pxaData.pxa.find(t.second);
		auto pxaID = 0;
		if (iter != pxaData.pxa.end())
			pxaID = iter->second;
		//Ǳ
		if (IsBackPxa(pxaID))
			continue;
		float srcX = (float)LOWORD(t.second);
		float srcY = (float)HIWORD(t.second);
		float dstX = (float)LOWORD(t.first);
		float dstY = (float)HIWORD(t.first);
		MyRect src, dst;
		src.Set1(srcX * pxaData.tileW,
			srcY * pxaData.tileH,
			(float)pxaData.tileW,
			(float)pxaData.tileH);
		dst.Set1(((dstX * view.grid_w) * view.scale - floorf(view.offX * view.scale)),
			((dstY * view.grid_h) * view.scale - floorf(view.offY * view.scale)),
			view.grid_w * view.scale,
			view.grid_h * view.scale);
		//ԻǷĻ
		if (!rcScreen.IntersectRect(&dst))
			continue;
		pRenderer.AddRenderCopy(&src, &dst, pLayer->color);
		drawCount++;
		if (drawCount >= limit)
			break;
	}
	pRenderer.DrawRenderCopy();
	if (pLayer->layerType == 1)
		view = srcView;
	if (pLayer->enableClipZone && *pPlaying)
		pRenderer.SetScissorRect();
}

void CMapEditorDraw::DrawLoopLayer(MyMapLayer* pLayer, MyMapLayer* selectLayer)
{
	auto& step = *pLayer->GetPxmStep();
	auto& pxaData = *GetPxa(pLayer->pxaName.c_str());
	//ûƼ
	MyRect clip;
	if (pLayer->enableClipZone && *pPlaying)
	{
		MyView srcView = view;
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		view.offX -= (1 - farValue) * view.offX;
		view.offY -= (1 - farValue) * view.offY;
		MyRect& clipRc = pLayer->clipZone;
		clip.left = (clipRc.left) * view.scale - floorf(view.offX * view.scale);
		clip.right = (clipRc.right) * view.scale - floorf(view.offX * view.scale);
		clip.top = (clipRc.top) * view.scale - floorf(view.offY * view.scale);
		clip.bottom = (clipRc.bottom) * view.scale - floorf(view.offY * view.scale);
		view = srcView;
	}
	else
	{
		clip.Set1(-view.offX * view.scale,
			-view.offY * view.scale,
			view.grid_w * view.count_w * view.scale + 1,
			view.grid_h * (view.count_max / view.count_w) * view.scale + 1);
	}
	//üо
	if (*pPlaying || pLayer != selectLayer)
	{
		//ѭ
		int minXIndex = INT_MAX;
		int minYIndex = INT_MAX;
		int maxXIndex = INT_MIN;
		int maxYIndex = INT_MIN;
		//ȡƬΧ
		for (auto& t : step)
		{
			int srcX = (int)LOWORD(t.first);
			int srcY = (int)HIWORD(t.first);
			if (srcX < minXIndex)
				minXIndex = srcX;
			if (srcY < minYIndex)
				minYIndex = srcY;
			if (srcX > maxXIndex)
				maxXIndex = srcX;
			if (srcY > maxYIndex)
				maxYIndex = srcY;
		}
		if (minXIndex == INT_MAX ||
			minYIndex == INT_MAX ||
			maxXIndex == INT_MIN ||
			maxYIndex == INT_MIN)
			return;//һ
		//ڲŵ
		pRenderer.SetScissorRect(&clip);
		if (pLayer->loopH && pLayer->loopV)
		{
			//ѭƬ
			int tw = maxXIndex + 1 - minXIndex;
			int th = maxYIndex + 1 - minYIndex;
			float bk_w = tw * view.grid_w;
			float bk_h = th * view.grid_h;
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			MyView srcView = view;
			float srcLoopOffx = pLayer->speedH * (float)(*pTimeCounter) * farValue;
			float srcLoopOffy = pLayer->speedV * (float)(*pTimeCounter) * farValue;
			view.offX -= srcLoopOffx - floorf(srcLoopOffx / bk_w) * bk_w;
			view.offY -= srcLoopOffy - floorf(srcLoopOffy / bk_h) * bk_h;
			if (*pPlaying)
			{
				//ϾͷԶƶ
				view.offX -= (1 - farValue) * srcView.offX;
				view.offY -= (1 - farValue) * srcView.offY;
			}
			pRenderer.SetTPenDraw(GetTexture(pLayer->pxaName.c_str()));

			MyRect rc;
			MyViewDrawFor vFor;
			vFor.Init(&view);
			vFor.DrawForYBegin();
			vFor._y -= th;
			vFor.rc_draw_y -= vFor.rc_draw_h * th;
			for (; vFor.DrawForY(); vFor.DrawForYInc())
			{
				vFor.DrawForXBegin();
				vFor._x -= tw;
				vFor.rc_draw_x -= vFor.rc_draw_w * tw;
				for (; vFor.DrawForX(&rc); vFor.DrawForXInc())
				{
					int& x = vFor._x;
					int& y = vFor._y;
					if (y * view.count_w + x >= view.count_max)
						goto CMapEditorDraw_DrawLoopLayer_DrawHV_End;
					int dxSrc = (x - minXIndex) % tw;
					int dySrc = (y - minYIndex) % th;
					if (dxSrc < 0)
						dxSrc = tw - abs(dxSrc) % tw;
					if (dySrc < 0)
						dySrc = th - abs(dySrc) % th;
					int XIndexSrc = dxSrc + minXIndex;
					int YIndexSrc = dySrc + minYIndex;
					auto iter = step.find(MAKELONG(XIndexSrc, YIndexSrc));
					if (iter == step.end())
						continue;
					float srcX = (float)LOWORD(iter->second);
					float srcY = (float)HIWORD(iter->second);
					MyRect src;
					src.Set1(srcX * pxaData.tileW,
						srcY * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					if (step.find(MAKELONG(x, y)) == step.end() && pLayer == selectLayer)
					{
						MyRGBA myRGBA;
						myRGBA.Set(pLayer->color);
						myRGBA.a = 0x80;
						DWORD c = myRGBA.Get();
						pRenderer.AddRenderCopy(&src, &rc, c);
					}
					else
						pRenderer.AddRenderCopy(&src, &rc, pLayer->color);
				}
			}
		CMapEditorDraw_DrawLoopLayer_DrawHV_End:
			pRenderer.DrawRenderCopy();
			view = srcView;
		}
		else if (pLayer->loopH)//ֻˮƽѭ
		{
			//ѭƬ
			int tw = maxXIndex + 1 - minXIndex;
			int th = maxYIndex + 1 - minYIndex;
			float bk_w = tw * view.grid_w;
			float bk_h = th * view.grid_h;
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			MyView srcView = view;
			float srcLoopOffx = pLayer->speedH * (float)(*pTimeCounter) * farValue;
			float srcLoopOffy = pLayer->speedV * (float)(*pTimeCounter) * farValue;
			view.offX -= srcLoopOffx - floorf(srcLoopOffx / bk_w) * bk_w;
			view.offY -= srcLoopOffy - floorf(srcLoopOffy / bk_h) * bk_h;
			if (*pPlaying)
			{
				//ϾͷԶƶ
				view.offX -= (1 - farValue) * srcView.offX;
				view.offY -= (1 - farValue) * srcView.offY;
			}
			pRenderer.SetTPenDraw(GetTexture(pLayer->pxaName.c_str()));

			MyRect rc;
			MyViewDrawFor vFor;
			vFor.Init(&view);
			vFor.DrawForYBegin();
			vFor._y = minYIndex;
			vFor.rc_draw_y = (vFor._y * view.grid_h) * view.scale - floorf(view.offY * view.scale);
			for (; vFor._y <= maxYIndex; vFor.DrawForYInc())
			{
				vFor.DrawForXBegin();
				vFor._x -= tw;
				vFor.rc_draw_x -= vFor.rc_draw_w * tw;
				for (; vFor.DrawForX(&rc); vFor.DrawForXInc())
				{
					int& x = vFor._x;
					int& y = vFor._y;
					if (y * view.count_w + x >= view.count_max)
						goto CMapEditorDraw_DrawLoopLayer_DrawH_End;
					int dxSrc = (x - minXIndex) % tw;
					int dySrc = (y - minYIndex) % th;
					if (dxSrc < 0)
						dxSrc = tw - abs(dxSrc) % tw;
					if (dySrc < 0)
						dySrc = th - abs(dySrc) % th;
					int XIndexSrc = dxSrc + minXIndex;
					int YIndexSrc = dySrc + minYIndex;
					auto iter = step.find(MAKELONG(XIndexSrc, YIndexSrc));
					if (iter == step.end())
						continue;
					float srcX = (float)LOWORD(iter->second);
					float srcY = (float)HIWORD(iter->second);
					MyRect src;
					src.Set1(srcX * pxaData.tileW,
						srcY * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					if (step.find(MAKELONG(x, y)) == step.end() && pLayer == selectLayer)
					{
						MyRGBA myRGBA;
						myRGBA.Set(pLayer->color);
						myRGBA.a = 0x80;
						DWORD c = myRGBA.Get();
						pRenderer.AddRenderCopy(&src, &rc, c);
					}
					else
						pRenderer.AddRenderCopy(&src, &rc, pLayer->color);
				}
			}
		CMapEditorDraw_DrawLoopLayer_DrawH_End:
			pRenderer.DrawRenderCopy();
			view = srcView;
		}
		else if (pLayer->loopV)//ֱֻѭ
		{
			//ѭƬ
			int tw = maxXIndex + 1 - minXIndex;
			int th = maxYIndex + 1 - minYIndex;
			float bk_w = tw * view.grid_w;
			float bk_h = th * view.grid_h;
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			MyView srcView = view;
			float srcLoopOffx = pLayer->speedH * (float)(*pTimeCounter) * farValue;
			float srcLoopOffy = pLayer->speedV * (float)(*pTimeCounter) * farValue;
			view.offX -= srcLoopOffx - floorf(srcLoopOffx / bk_w) * bk_w;
			view.offY -= srcLoopOffy - floorf(srcLoopOffy / bk_h) * bk_h;
			if (*pPlaying)
			{
				//ϾͷԶƶ
				view.offX -= (1 - farValue) * srcView.offX;
				view.offY -= (1 - farValue) * srcView.offY;
			}
			pRenderer.SetTPenDraw(GetTexture(pLayer->pxaName.c_str()));

			MyRect rc;
			MyViewDrawFor vFor;
			vFor.Init(&view);
			vFor.DrawForYBegin();
			vFor._y -= th;
			vFor.rc_draw_y -= vFor.rc_draw_h * th;
			for (; vFor.DrawForY(); vFor.DrawForYInc())
			{
				vFor.DrawForXBegin();
				vFor._x = minXIndex;
				vFor.rc_draw_x = (vFor._x * view.grid_w) * view.scale - floorf(view.offX * view.scale);
				for (; vFor._x <= maxXIndex; vFor.DrawForXInc())
				{
					rc.Set1(vFor.rc_draw_x, vFor.rc_draw_y, vFor.rc_draw_w, vFor.rc_draw_h);
					int& x = vFor._x;
					int& y = vFor._y;
					if (y * view.count_w + x >= view.count_max)
						goto CMapEditorDraw_DrawLoopLayer_DrawV_End;
					int dxSrc = (x - minXIndex) % tw;
					int dySrc = (y - minYIndex) % th;
					if (dxSrc < 0)
						dxSrc = tw - abs(dxSrc) % tw;
					if (dySrc < 0)
						dySrc = th - abs(dySrc) % th;
					int XIndexSrc = dxSrc + minXIndex;
					int YIndexSrc = dySrc + minYIndex;
					auto iter = step.find(MAKELONG(XIndexSrc, YIndexSrc));
					if (iter == step.end())
						continue;
					float srcX = (float)LOWORD(iter->second);
					float srcY = (float)HIWORD(iter->second);
					MyRect src;
					src.Set1(srcX * pxaData.tileW,
						srcY * pxaData.tileH,
						(float)pxaData.tileW,
						(float)pxaData.tileH);
					if (step.find(MAKELONG(x, y)) == step.end() && pLayer == selectLayer)
					{
						MyRGBA myRGBA;
						myRGBA.Set(pLayer->color);
						myRGBA.a = 0x80;
						DWORD c = myRGBA.Get();
						pRenderer.AddRenderCopy(&src, &rc, c);
					}
					else
						pRenderer.AddRenderCopy(&src, &rc, pLayer->color);
				}
			}
		CMapEditorDraw_DrawLoopLayer_DrawV_End:
			pRenderer.DrawRenderCopy();
			view = srcView;
		}
		else
		{
			//ѭ
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			MyView srcView = view;
			if (*pPlaying)
			{
				//ϾͷԶƶ
				view.offX -= (1 - farValue) * srcView.offX;
				view.offY -= (1 - farValue) * srcView.offY;
			}
			pRenderer.SetTPenDraw(GetTexture(pLayer->pxaName.c_str()));
			auto& step = *pLayer->GetPxmStep();
			auto& pxaData = *GetPxa(pLayer->pxaName.c_str());
			for (auto& t : step)
			{
				float srcX = (float)LOWORD(t.second);
				float srcY = (float)HIWORD(t.second);
				float dstX = (float)LOWORD(t.first);
				float dstY = (float)HIWORD(t.first);
				MyRect src, dst;
				src.Set1(srcX * pxaData.tileW,
					srcY * pxaData.tileH,
					(float)pxaData.tileW,
					(float)pxaData.tileH);
				dst.Set1(((dstX * view.grid_w) * view.scale - floorf(view.offX * view.scale)),
					((dstY * view.grid_h) * view.scale - floorf(view.offY * view.scale)),
					view.grid_w * view.scale,
					view.grid_h * view.scale);
				//ԻǷĻ
				pRenderer.AddRenderCopy(&src, &dst, pLayer->color);
			}
			pRenderer.DrawRenderCopy();
			view = srcView;
		}
		pRenderer.SetScissorRect();
	}
	else
	{
		//ڱ༭ʱĻ
		pRenderer.SetTPenDraw(GetTexture(pLayer->pxaName.c_str()));
		auto& step = *pLayer->GetPxmStep();
		auto& pxaData = *GetPxa(pLayer->pxaName.c_str());
		for (auto& t : step)
		{
			float srcX = (float)LOWORD(t.second);
			float srcY = (float)HIWORD(t.second);
			float dstX = (float)LOWORD(t.first);
			float dstY = (float)HIWORD(t.first);
			MyRect src, dst;
			src.Set1(srcX * pxaData.tileW,
				srcY * pxaData.tileH,
				(float)pxaData.tileW,
				(float)pxaData.tileH);
			dst.Set1(((dstX * view.grid_w) * view.scale - floorf(view.offX * view.scale)),
				((dstY * view.grid_h) * view.scale - floorf(view.offY * view.scale)),
				view.grid_w * view.scale,
				view.grid_h * view.scale);
			//ԻǷĻ
			pRenderer.AddRenderCopy(&src, &dst, pLayer->color);
		}
		pRenderer.DrawRenderCopy();
	}
}

void CMapEditorDraw::DrawPxa(MyMapLayer* pLayer)
{
	//
	const int limit = 40000;
	int drawCount = 0;
	MyRect rcScreen;
	rcScreen.Set1(0, 0, view.window_w, view.window_h);
	pRenderer.SetTPenDraw(tas_pxatype.pSRV);
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		if (*pPlaying)
		{
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			view.offX -= (1 - farValue) * view.offX;
			view.offY -= (1 - farValue) * view.offY;
		}
	}
	auto& step = *pLayer->GetPxmStep();
	auto& pxaData = *GetPxa(pLayer->pxaName.c_str());
	for (auto& t : step)
	{
		auto iter = pxaData.pxa.find(t.second);
		if (iter == pxaData.pxa.end())
			continue;
		auto pxaID = iter->second;
		float srcX = (float)(pxaID % 16);
		float srcY = (float)(pxaID / 16);
		float dstX = (float)LOWORD(t.first);
		float dstY = (float)HIWORD(t.first);
		MyRect src, dst;
		src.Set1(srcX * pxaData.tileW,
			srcY * pxaData.tileH,
			(float)pxaData.tileW,
			(float)pxaData.tileH);
		dst.Set1(((dstX * view.grid_w) * view.scale - floorf(view.offX * view.scale)),
			((dstY * view.grid_h) * view.scale - floorf(view.offY * view.scale)),
			view.grid_w * view.scale,
			view.grid_h * view.scale);
		//ԻǷĻ
		if (!rcScreen.IntersectRect(&dst))
			continue;
		pRenderer.AddRenderCopy(&src, &dst, RGBA(0xff, 0xff, 0xff, 0x80));
		drawCount++;
		if (drawCount >= limit)
			break;
	}
	pRenderer.DrawRenderCopy();
	if (pLayer->layerType == 1)
		view = srcView;
}

bool CMapEditorDraw::IsBackPxa(int pxaID)
{
	return pxaID == 0 || pxaID == 0x40 || IsWindPxa(pxaID);
}

bool CMapEditorDraw::IsWindPxa(int pxaID)
{
	return (pxaID >= 0x60 && pxaID <= 0x67) || (pxaID >= 0x70 && pxaID <= 0x77);
}

void CMapEditorDraw::DrawEntityGrid(MyMapLayer* pLayer)
{
	auto& step_pxe = *pLayer->GetPxeStep();
	pRenderer.SetPenDraw();
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		if (*pPlaying)
		{
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			view.offX -= (1 - farValue) * view.offX;
			view.offY -= (1 - farValue) * view.offY;
		}
	}
	MyRect rc;
	for (auto& p : step_pxe)
	{
		auto& el = p.second;
		rc.Set1((el.x * view.grid_w) * view.scale - floorf(view.offX * view.scale),
			(el.y * view.grid_h) * view.scale - floorf(view.offY * view.scale),
			view.grid_w * view.scale,
			view.grid_h * view.scale);
		if (p.first == pLayer->selected_entity)
			pRenderer.AddRect(&rc, RGBA(0xff, 0, 0xff, 0xff));//ѡеʵɫ
		else
			pRenderer.AddRect(&rc, RGBA(0, 0xff, 0, 0xff));//δѡɫ
	}
	pRenderer.DrawLine();
	if (pLayer->layerType == 1)
		view = srcView;
}

void CMapEditorDraw::DrawEntityLabel(MyMapLayer* pLayer)
{
	auto& step_pxe = *pLayer->GetPxeStep();
	MyView srcView = view;
	if (pLayer->layerType == 1)
	{
		view.offX += pLayer->offx;
		view.offY += pLayer->offy;
		if (*pPlaying)
		{
			float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
			view.offX -= (1 - farValue) * view.offX;
			view.offY -= (1 - farValue) * view.offY;
		}
	}
	float offx, nextX, nextY;
	MyRect rc;
	for (auto& p : step_pxe)
	{
		auto& el = p.second;
		nextX = (el.x * view.grid_w + 1) * view.scale - floorf(view.offX * view.scale);
		nextY = (el.y * view.grid_h) * view.scale - floorf(view.offY * view.scale);
		offx = nextX;
		pRenderer.DrawText_Unicode(&pFontMap28, pFont_simsun28, el.name.c_str(), offx, &nextX, &nextY, RGBA(0xff, 0xff, 0xff, 0xff), view.scale/4);
	}
	if (pLayer->layerType == 1)
		view = srcView;
}

void CMapEditorDraw::DrawClipRect(MyMapLayer* pLayer)
{
	MyRect& clipRc = pLayer->clipZone;
	MyView srcView = view;
	if (*pPlaying)
	{
		float farValue = MyFar(pLayer->myFar);//ӣ۾ƶ
		view.offX -= (1 - farValue) * view.offX;
		view.offY -= (1 - farValue) * view.offY;
	}
	MyRect rc;
	rc.left = (clipRc.left) * view.scale - floorf(view.offX * view.scale);
	rc.right = (clipRc.right) * view.scale - floorf(view.offX * view.scale);
	rc.top = (clipRc.top) * view.scale - floorf(view.offY * view.scale);
	rc.bottom = (clipRc.bottom) * view.scale - floorf(view.offY * view.scale);
	pRenderer.SetPenDraw();
	pRenderer.AddRect(&rc, RGBA(0xff, 0, 0, 0xff));
	pRenderer.DrawLine();
	view = srcView;
}

void CMapEditorDraw::DrawStage(bool timeCounterDraw, MyMapLayer* selectLayer)
{
	pRenderer.GameSetScale(view.scale);
	pRenderer.GameSetOffset(view.offX, view.offY);
	auto parentEditor = (CMapEditor*)pParentEditor;
	if (parentEditor->Light())
	{
		//ģʽйӰ
		auto lastRTV = pRenderer.GetPenRTV();
		/*----------------------------еĵƹʵ--------------------------*/
		entityRes.ClearLightList();
		for (auto& pLayer : *pDrawLayer)
		{
			auto& layer = *pLayer;
			if (!layer.visible)
				continue;
			entityRes.MarkLightEntity(&layer);
		}
		/*----------------------------ֲ--------------------------*/
		for (auto& pLayer : *pDrawLayer)
		{
			auto& layer = *pLayer;
			if (!layer.visible)
				continue;
			if (layer.dayLight == 1)//ŻΪ1ʱҪȾӰ
			{
				if (timeCounterDraw)
				{
					entityRes.SetCollisionEntityLayer(&layer, GetPxa(layer.pxaName.c_str()));
					entityRes.StepEntityLayer(&layer);
					entityRes.DeltaTimeEntityLayer(&layer, 1);
				}
				switch (layer.layerType)
				{
				case 0://
				case 1://
					if (parentEditor->BGround())
						DrawLayerBack(&layer);
					if (parentEditor->EntityShow())
						entityRes.DrawEntityLayer(&layer, *pPlaying);
					if (parentEditor->FGround())
						DrawLayerFront(&layer);
					break;
				case 2://ѭ
					DrawLoopLayer(&layer, selectLayer);
					if (parentEditor->EntityShow())
						entityRes.DrawEntityLayer(&layer, *pPlaying);
					break;
				}
				continue;
			}
			/*-------------------------̨stageBuffer--------------------------*/
			pRenderer.SetPenRTV(stageBuffer.pRTV);
			pRenderer.RenderClearRTV(stageBuffer.pRTV);
			if (timeCounterDraw)
			{
				entityRes.SetCollisionEntityLayer(&layer, GetPxa(layer.pxaName.c_str()));
				entityRes.StepEntityLayer(&layer);
				entityRes.DeltaTimeEntityLayer(&layer, 1);
			}
			switch (layer.layerType)
			{
			case 0://
			case 1://
				if (parentEditor->BGround())
					DrawLayerBack(&layer);
				if (parentEditor->EntityShow())
					entityRes.DrawEntityLayer(&layer, *pPlaying);
				if (parentEditor->FGround())
					DrawLayerFront(&layer);
				break;
			case 2://ѭ
				DrawLoopLayer(&layer, selectLayer);
				if (parentEditor->EntityShow())
					entityRes.DrawEntityLayer(&layer, *pPlaying);
				break;
			}
			/*---------------------------------------------------*/
			pRenderer.GameSetDayLight(layer.dayLight);
			pRenderer.GameSetHSV(layer.tinyHSV[0], layer.tinyHSV[1], layer.tinyHSV[2]);
			/*-------------------------Ʒʵ--------------------------*/
			//Ʒʵ嵽entityLight
			//pRenderer.SetBlendMode_Add();
			pRenderer.SetPenRTV(entityLight.pRTV);
			pRenderer.RenderClearRTV(entityLight.pRTV, 1.0f, 1.0f, 1.0f, 0.0f);
			entityRes.DrawLightEntity(&layer, *pPlaying);
			//pRenderer.SetBlendMode_Default();
			/*---------------------------------------------------*/
			//entityLightstageBuffer
			pRenderer.SetPenRTV(lastRTV);
			auto vs = entityRes.GetVertexShader(L"sys_finalLight");
			auto ps = entityRes.GetPixelShader(L"sys_finalLight");
			pRenderer.SetTPenVertexShader(vs);
			pRenderer.SetTPenPixelShader(ps);
			pRenderer.SetTPenDraw(entityLight.pSRV, stageBuffer.pSRV);
			pRenderer.AddRenderCopy();
			pRenderer.DrawRenderCopy();
			//ԭɫ
			pRenderer.SetTPenVertexShader();
			pRenderer.SetTPenPixelShader();
		}
	}
	else
	{
		//ͨģʽƹӰ
		for (auto& pLayer : *pDrawLayer)
		{
			auto& layer = *pLayer;
			if (!layer.visible)
				continue;
			if (timeCounterDraw)
			{
				entityRes.SetCollisionEntityLayer(&layer, GetPxa(layer.pxaName.c_str()));
				entityRes.StepEntityLayer(&layer);
				entityRes.DeltaTimeEntityLayer(&layer, 1);
			}
			switch (layer.layerType)
			{
			case 0://
			case 1://
				if (parentEditor->BGround())
					DrawLayerBack(&layer);
				if (parentEditor->EntityShow())
					entityRes.DrawEntityLayer(&layer, *pPlaying);
				if (parentEditor->FGround())
					DrawLayerFront(&layer);
				break;
			case 2://ѭ
				DrawLoopLayer(&layer, selectLayer);
				if (parentEditor->EntityShow())
					entityRes.DrawEntityLayer(&layer, *pPlaying);
				break;
			}
		}
	}
}

void CMapEditorDraw::DrawRecordGoal()
{
	auto parentEditor = (CMapEditor*)pParentEditor;

	DWORD c = RGBA(0xff, 0xff, 0, 0xff);
	pRenderer.SetPenDraw();
	float arrow_x = (*pRecordEndPos_x * view.grid_w) * view.scale - floorf(view.offX * view.scale);
	float arrow_y = (*pRecordEndPos_y * view.grid_h) * view.scale - floorf(view.offY * view.scale);

	MyDX11PenVertex v0, v1;
	v0.Set(arrow_x + (view.grid_w / 2 - 1.5f) * view.scale,
		arrow_y + 3 * view.scale,
		0, c);
	v1.Set(arrow_x +(view.grid_w / 2 + 1.5f) * view.scale,
		arrow_y + 3 * view.scale,
		0, c);
	pRenderer.AddLine(v0, v1);
	MyDX11PenVertex v2;
	v2.Set(arrow_x + (view.grid_w / 2 + 1.5f) * view.scale,
		arrow_y + 9 * view.scale,
		0, c);
	pRenderer.AddLine(v1, v2);
	MyDX11PenVertex v3;
	v3.Set(arrow_x + (view.grid_w / 2 + 4) * view.scale,
		arrow_y + 9 * view.scale,
		0, c);
	pRenderer.AddLine(v2, v3);
	MyDX11PenVertex v4;
	v4.Set(arrow_x + (view.grid_w / 2) * view.scale,
		arrow_y + 14 * view.scale,
		0, c);
	pRenderer.AddLine(v3, v4);
	MyDX11PenVertex v5;
	v5.Set(arrow_x + (view.grid_w / 2 - 4) * view.scale,
		arrow_y + 9 * view.scale,
		0, c);
	pRenderer.AddLine(v4, v5);
	MyDX11PenVertex v6;
	v6.Set(arrow_x + (view.grid_w / 2 - 1.5f) * view.scale,
		arrow_y + 9 * view.scale,
		0, c);
	pRenderer.AddLine(v5, v6);
	MyDX11PenVertex v7;
	v7.Set(arrow_x + (view.grid_w / 2 - 1.5f) * view.scale,
		arrow_y + 3 * view.scale,
		0, c);
	pRenderer.AddLine(v6, v7);
	pRenderer.DrawLine();
}
