#pragma once
#include "global.h"
#include "MyStructDef.h"
#include "CMCEditor.h"
#include "CWorldEditor.h"
#include "CPidEditor.h"
#include "CPxaEditor.h"
#include "CMapEditor.h"
#define CMAINEDITOR_MENUINDEX_FILE 0
#define CMAINEDITOR_MENUINDEX_OPTION 1
#define CMAINEDITOR_MENUINDEX_STORYEDITOR 2
#define CMAINEDITOR_MENUINDEX_GAMEEDITOR 3
#define MAINEDITOR_WIDTH 1251
#define MAINEDITOR_HEIGHT 942
//ݿⶨϵͳ
#define DBTABLENAME_INFO L"ocsys_info"
#define DBTABLENAME_OPTION L"ocsys_option"
#define DBTABLENAME_CALENDAR L"ocsys_calendar"
#define DBTABLENAME_MYCHAR_POSITION L"ocsys_mcpos"
#define DBTABLENAME_MYCHAR_CHARACTER L"ocsys_mcchar"
#define DBTABLENAME_MYCHARACTER L"ocsys_mycharacter"
#define DBTABLENAME_WORLDSET L"ocsys_worldset"
#define DBTABLENAME_SPORTBODY L"ocsys_sportbody"
//ļ
#define NULLFACE L"null_face.png"
class CMainEditor : public CDialog
{
	DECLARE_DYNAMIC(CMainEditor)
	DECLARE_MESSAGE_MAP()
public:
	CMainEditor(CWnd* pParent = nullptr);   // ׼캯
	virtual ~CMainEditor();
	// Ի
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_CMAINEDITOR };
#endif
	static void CloseDB(sqlite3* db);//رݿ
	sqlite3* OpenDB();//ݿ
	CString GetDBFieldValue(CString table, CString field, CString field_val, CString value);//ȡĳĳֶεֵ
	void SetDBFieldValue(CString table, CString field, CString field_val, CString value, CString value_val);//ĳĳֶεֵ
	void DelDBField(CString table, CString field, CString field_val);//ɾĳĳֶεֵ
	void SetDBField(CString table, CString field, CString field_val, CString field_val_new);//ĳĳֶεֵ
	void GetDBField_List(std::vector<CString>* outList, CString table, CString field);//ȡĳĳֶе
	int GetDBTabelCount(CString table);//ȡĳ
	void GetDBMyCharacter_List(std::vector<MyCharacterInfo>* outList);//ȡDBTABLENAME_MYCHARACTER
	bool GetDBTableExist(CString table);//ĳǷ
	CString GetDBWorldSet();//ȡworldsetxml
	void SetDBWorldSet(CString xml);//worldxml
	static void GetXMLLabel_Map(std::unordered_map<std::wstring, MyLabelXML>* outMap, CString xml);//ȡ趨ʵֱxml趨
	static CString GetXMLString(std::unordered_map<std::wstring, MyLabelXML>& xmlMap);//趨xmlַ
	void UpdateWindowTitle();//´ڱ
	void UpdateDisplayDiary();
	void Draw();//
	CString GetBasePath();
	void UpdateContext();//
	CString ImportPNG(CString filepath);//ͼļ뵽Ŀ¼ļ
	MyDX11Renderer pRenderer;//Ⱦ
	ID3D11Texture2D* pTextureBk = nullptr;//ʹõıͼ
	ID3D11ShaderResourceView* pSRV = nullptr;
	BYTE alpha = 0xff;//ͼalpha
	ID3D11Texture2D* pTextureBk_bkup = nullptr;//Ԥıͼ
	ID3D11ShaderResourceView* pSRV_bkup = nullptr;
	BYTE alpha_bkup = 0xff;
	CString osName;//ֿ
	CString osAuthor;//
	CString osFilePath;//ݿļĿ¼
protected:
	void DoDataExchange(CDataExchange* pDX) override;
	BOOL OnInitDialog() override;
	void Load(CString string);//
	void DrawCalendar(float x, float y,int year,int month);//
	void UpdateDisplayYear(int year);
public:
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnNewOS();
	afx_msg void OnOpenOs();
	afx_msg void OnCloseOs();
	afx_msg void OnCalentarBk();
	afx_msg void OnOsinfo();
	afx_msg void OnMcEditor();
	afx_msg void OnWorldEditor();
	afx_msg void OnPidEditor();
	afx_msg void OnPxaEditor();
	afx_msg void OnMapEditor();
	afx_msg void OnGameSetting();
	afx_msg void OnBootGame();
	afx_msg void OnYearDown();
	afx_msg void OnYearUp();
private:
	TTF_Font* pFont_simsun28 = nullptr;//
	std::unordered_map<wchar_t, MyFontData> pFontMap28;
	int yearDisplay;//Ŀǰʾ
	bool setClickRectArr = false;
	std::vector<MyCalendarClickZone> clickRectArr;
	int dayCount = 0;//
	UINT_PTR timeId = 0;
	bool sportRemind = false;
	time_t workMinute = 0;
	/*---------------Ӵ-----------------*/
	CMCEditor pMCEditor;
	CWorldEditor pWorldEditor;
	CPidEditor pPidEditor;
	CPxaEditor pPxaEditor;
	CMapEditor pMapEditor;
	void LockMenu();//˵
	void UnlockMenu();//˵
	void SaveLastFile();//һεļ
	void OpenLastFile(CString& str);//һεļ
	void InitDBTable();//ʼ
	void SportBody();//˶
	////////////////////ȼ//////////////////
	HACCEL hAccel = nullptr;//ȼ
	BOOL PreTranslateMessage(MSG* pMsg) override;
};
