#include "CMCEditor.h"
#include "resource.h"
#include "CMainEditor.h"
#include "CMCPosTable.h"
#include "CNewMC.h"

IMPLEMENT_DYNAMIC(CMCEditor, CDialog)

BEGIN_MESSAGE_MAP(CMCEditor, CDialog)
	ON_COMMAND(IDOK, &CMCEditor::OnEnterKey)
	ON_WM_SHOWWINDOW()
	ON_COMMAND(ID_MCPOS_TABLE, &CMCEditor::OnMcposTable)
	ON_COMMAND(ID_MCCHAR_TABLE, &CMCEditor::OnMccharTable)
	ON_COMMAND(ID_ADD_MC, &CMCEditor::OnAddMc)
	ON_COMMAND(ID_EDIT_MC, &CMCEditor::OnEditMc)
	ON_COMMAND(ID_DELETE_MC, &CMCEditor::OnDeleteMc)
	ON_COMMAND(ID_COPY_MC, &CMCEditor::OnCopyMc)
	ON_MESSAGE(MYDXLIST_SELCHANGED,&CMCEditor::OnDXListSelChange)
END_MESSAGE_MAP()

CMCEditor::CMCEditor(CWnd* pParent)
	: CDialog(IDD_CMCEDITOR, pParent)
{
}

CMCEditor::~CMCEditor()
{
}

void CMCEditor::UpdateContext()
{
	//Ӵڵ
	pMCPosTable.UpdateContext();
	pMCCharTable.UpdateContext();

	//ڵ
	auto mainEditor = (CMainEditor*)pMainEditor;
	//½ɫб
	auto index = pMCList.GetCurSel();
	pMCList.Clear();
	mainEditor->GetDBMyCharacter_List(&mcList);
	for (auto& p : mcList)
		pMCList.AddItem(p.name, p.facePng);
	pMCList.SetCurSel(index);
}

void CMCEditor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	static_id = (CStatic*)GetDlgItem(IDC_STATIC_ID);
	static_mclist = (CStatic*)GetDlgItem(IDC_STATIC_MCDXLIST);
	DDX_Control(pDX, IDC_BUTTON_DIR, button_dir);
	static_face = (CStatic*)GetDlgItem(IDC_STATIC_FACE);
	DDX_Control(pDX, IDC_RADIO_CREATURE, radio_creature);
	DDX_Control(pDX, IDC_RADIO_SPRITE, radio_sprite);
	DDX_Control(pDX, IDC_EDIT_IMAGE, edit_image);
	DDX_Control(pDX, IDC_EDIT_NAME, edit_label);
	DDX_Control(pDX, IDC_COMBO_POS, combobox_pos);
	DDX_Control(pDX, IDC_COMBO_CHAR, combobox_char);
	DDX_Control(pDX, IDC_RADIO_FEMALE, radio_female);
	DDX_Control(pDX, IDC_RADIO_MALE, radio_male);
	DDX_Control(pDX, IDC_RADIO_NONE, radio_none);
	DDX_Control(pDX, IDC_EDIT_IDEAL, edit_ideal);
	DDX_Control(pDX, IDC_LIST_SET, listbox_set);
	DDX_Control(pDX, IDC_LIST_EVENT, listbox_event);
	DDX_Control(pDX, IDC_LIST_MAP, listbox_map);
}

BOOL CMCEditor::OnInitDialog()
{
	CDialog::OnInitDialog();
	//Ӧóͼ
	auto hIcon = AfxGetApp()->LoadIcon(IDI_APPICON_TABLE);
	SetIcon(hIcon, true);
	//ʼؼ
	DisableCtrl();//ÿؼ
	SetWindowTextW(L"ɫ༭");
	//ʼӴ
	pMCList.Create(IDD_CMYDXLIST, this);
	pMCList.Init(48, 48, 48);
	pMCList.SetMenu(IDR_CMCEDITOR_MCLIST_RMENU, IDR_CMCEDITOR_MCLIST_RMENU_NOSEL);
	pMCPosTable.pMainEditor = pMainEditor;
	pMCPosTable.pParentWindow = this;
	pMCPosTable.Create(IDD_CMCPOS_TABLE, this);
	pMCCharTable.pMainEditor = pMainEditor;
	pMCCharTable.pParentWindow = this;
	pMCCharTable.Create(IDD_CMCCHAR_TABLE, this);
	picbox.Create(IDD_CMYPICBOX, this);
	//ÿؼpMCList
	CRect rc;
	static_mclist->GetWindowRect(&rc);
	ScreenToClient(&rc);
	static_mclist->EnableWindow(false);
	static_mclist->ShowWindow(SW_HIDE);
	pMCList.MoveWindow(&rc);
	pMCList.ShowWindow(SW_SHOW);
	//picbox
	static_face->GetWindowRect(&rc);
	ScreenToClient(&rc);
	static_face->EnableWindow(false);
	static_face->ShowWindow(SW_HIDE);
	picbox.MoveWindow(&rc);
	picbox.ShowWindow(SW_SHOW);
	return 0;
}

void CMCEditor::OnCancel()
{
	ShowWindow(SW_HIDE);
}

void CMCEditor::OnEnterKey()
{
}


void CMCEditor::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);
	auto mainEditor = (CMainEditor*)pMainEditor;
	
	if (bShow)
		mainEditor->GetMenu()->GetSubMenu(CMAINEDITOR_MENUINDEX_STORYEDITOR)->CheckMenuItem(ID_MC_EDITOR, MF_BYCOMMAND | MF_CHECKED);
	else
	{
		mainEditor->GetMenu()->GetSubMenu(CMAINEDITOR_MENUINDEX_STORYEDITOR)->CheckMenuItem(ID_MC_EDITOR, MF_BYCOMMAND | MF_UNCHECKED);
		pMCPosTable.ShowWindow(SW_HIDE);
		pMCCharTable.ShowWindow(SW_HIDE);
	}
}

void CMCEditor::OnMcposTable()
{
	
	pMCPosTable.ShowWindow(pMCPosTable.IsWindowVisible() ? SW_HIDE : SW_SHOW);
}

void CMCEditor::OnMccharTable()
{
	
	pMCCharTable.ShowWindow(pMCCharTable.IsWindowVisible() ? SW_HIDE : SW_SHOW);
}

void CMCEditor::OnAddMc()
{
	
	//顾ɫλ͡ɫԸǷһĿ
	auto mainEditor = (CMainEditor*)pMainEditor;
	if (mainEditor->GetDBTabelCount(DBTABLENAME_MYCHAR_POSITION) == 0)
	{
		MessageBoxW(L"ʹáӽɫǰڡɫλһЩλ", L"ҪһЩǰùܵд", MB_ICONINFORMATION);
		return;
	}
	if (mainEditor->GetDBTabelCount(DBTABLENAME_MYCHAR_CHARACTER) == 0)
	{
		MessageBoxW(L"ʹáӽɫǰڡɫԸһЩԸ", L"ҪһЩǰùܵд", MB_ICONINFORMATION);
		return;
	}
	//ӽɫ
	CNewMC dlg;
	dlg.pMainEditor = pMainEditor;
	if (dlg.DoModal() != IDOK)
		return;
	//ͼ
	CString facepng = mainEditor->ImportPNG(dlg.outMC.facePng);
	//ӽɫɫǩ
	auto db = mainEditor->OpenDB();
	CString sql;
	std::vector<char> cmdbuff_utf8;
	std::vector<char> pBuff_utf8_image;
	std::vector<char> pBuff_utf8_ideal;
	std::vector<char> pBuff_utf8_labelXML;
	sql.Format(L"INSERT INTO %s(facepng,lifetype,image,name,mcpos,mcchar,gender,ideal,label) VALUES ('%s',%d,?,'%s','%s','%s',%d,?,?);",
		DBTABLENAME_MYCHARACTER, facepng.GetString(), dlg.outMC.lifeType, dlg.outMC.name.GetString(), dlg.outMC.mcpos.GetString(), dlg.outMC.mcChar.GetString(), dlg.outMC.gender);
	UTF16ToUTF8(sql.GetString(), &cmdbuff_utf8);
	sqlite3_stmt* stmt;
	sqlite3_prepare(db, cmdbuff_utf8.data(), -1, &stmt, nullptr);
	//׼
	int utf8_buffSize_image;
	UTF16ToUTF8(dlg.outMC.image.GetString(), &pBuff_utf8_image, &utf8_buffSize_image);
	int utf8_buffSize_ideal;
	UTF16ToUTF8(dlg.outMC.ideal.GetString(), &pBuff_utf8_ideal, &utf8_buffSize_ideal);
	int utf8_buffSize_labelXML;
	UTF16ToUTF8(dlg.outMC.labelXML.GetString(), &pBuff_utf8_labelXML, &utf8_buffSize_labelXML);
	//λ
	sqlite3_bind_text(stmt, 1, pBuff_utf8_image.data(), utf8_buffSize_image, nullptr);
	sqlite3_bind_text(stmt, 2, pBuff_utf8_ideal.data(), utf8_buffSize_ideal, nullptr);
	sqlite3_bind_text(stmt, 3, pBuff_utf8_labelXML.data(), utf8_buffSize_labelXML, nullptr);
	sqlite3_step(stmt);
	sqlite3_finalize(stmt);
	mainEditor->CloseDB(db);
	//б
	UpdateContext();
}

void CMCEditor::OnEditMc()
{
	
	if (pMCList.Empty() || mcList.empty())
		return;
	if (pMCList.GetCurSel() < 0)
		return;
	auto mainEditor = (CMainEditor*)pMainEditor;
	auto& mc = mcList.at(pMCList.GetCurSel());
	//༭ɫ
	CNewMC dlg;
	dlg.load = true;
	dlg.outMC = mc;
	dlg.pMainEditor = pMainEditor;
	if (dlg.DoModal() != IDOK)
		return;
	//ͼ
	CString facepng = mainEditor->ImportPNG(dlg.outMC.facePng);
	//ӽɫɫǩ
	auto db = mainEditor->OpenDB();
	CString sql;
	std::vector<char> cmdbuff_utf8;
	std::vector<char> pBuff_utf8_image;
	std::vector<char> pBuff_utf8_ideal;
	std::vector<char> pBuff_utf8_labelXML;
	sql.Format(L"UPDATE %s SET facepng = '%s',lifetype = %d,image = ?,name = '%s',mcpos = '%s',mcchar = '%s',gender = %d,ideal = ?,label = ? WHERE id = %d;",
		DBTABLENAME_MYCHARACTER, facepng.GetString(), dlg.outMC.lifeType, dlg.outMC.name.GetString(), dlg.outMC.mcpos.GetString(), dlg.outMC.mcChar.GetString(), dlg.outMC.gender, dlg.outMC.id);
	UTF16ToUTF8(sql.GetString(), &cmdbuff_utf8);
	sqlite3_stmt* stmt;
	sqlite3_prepare(db, cmdbuff_utf8.data(), -1, &stmt, nullptr);
	//׼
	int utf8_buffSize_image;
	UTF16ToUTF8(dlg.outMC.image.GetString(), &pBuff_utf8_image, &utf8_buffSize_image);
	int utf8_buffSize_ideal;
	UTF16ToUTF8(dlg.outMC.ideal.GetString(), &pBuff_utf8_ideal, &utf8_buffSize_ideal);
	int utf8_buffSize_labelXML;
	UTF16ToUTF8(dlg.outMC.labelXML.GetString(), &pBuff_utf8_labelXML, &utf8_buffSize_labelXML);
	//λ
	sqlite3_bind_text(stmt, 1, pBuff_utf8_image.data(), utf8_buffSize_image, nullptr);
	sqlite3_bind_text(stmt, 2, pBuff_utf8_ideal.data(), utf8_buffSize_ideal, nullptr);
	sqlite3_bind_text(stmt, 3, pBuff_utf8_labelXML.data(), utf8_buffSize_labelXML, nullptr);
	sqlite3_step(stmt);
	sqlite3_finalize(stmt);
	mainEditor->CloseDB(db);
	//б
	UpdateContext();
}

void CMCEditor::OnDeleteMc()
{
	
	auto mainEditor = (CMainEditor*)pMainEditor;
	auto& mc = mcList.at(pMCList.GetCurSel());
	CString id_str;
	id_str.Format(L"%d", mc.id);
	mainEditor->DelDBField(DBTABLENAME_MYCHARACTER, L"id", id_str);
	//б
	UpdateContext();
}


void CMCEditor::OnCopyMc()
{
	
	auto mainEditor = (CMainEditor*)pMainEditor;
	auto& mc = mcList.at(pMCList.GetCurSel());
	auto db = mainEditor->OpenDB();
	CString sql;
	std::vector<char> cmdbuff_utf8;
	std::vector<char> pBuff_utf8_image;
	std::vector<char> pBuff_utf8_ideal;
	std::vector<char> pBuff_utf8_labelXML;
	sql.Format(L"INSERT INTO %s(facepng,lifetype,image,name,mcpos,mcchar,gender,ideal,label) VALUES ('%s',%d,?,'%s','%s','%s',%d,?,?);",
		DBTABLENAME_MYCHARACTER, mc.facePng.GetString(), mc.lifeType, mc.name.GetString(), mc.mcpos.GetString(), mc.mcChar.GetString(), mc.gender);
	UTF16ToUTF8(sql.GetString(), &cmdbuff_utf8);
	sqlite3_stmt* stmt;
	sqlite3_prepare(db, cmdbuff_utf8.data(), -1, &stmt, nullptr);
	//׼
	int utf8_buffSize_image;
	UTF16ToUTF8(mc.image.GetString(), &pBuff_utf8_image, &utf8_buffSize_image);
	int utf8_buffSize_ideal;
	UTF16ToUTF8(mc.ideal.GetString(), &pBuff_utf8_ideal, &utf8_buffSize_ideal);
	int utf8_buffSize_labelXML;
	UTF16ToUTF8(mc.labelXML.GetString(), &pBuff_utf8_labelXML, &utf8_buffSize_labelXML);
	//λ
	sqlite3_bind_text(stmt, 1, pBuff_utf8_image.data(), utf8_buffSize_image, nullptr);
	sqlite3_bind_text(stmt, 2, pBuff_utf8_ideal.data(), utf8_buffSize_ideal, nullptr);
	sqlite3_bind_text(stmt, 3, pBuff_utf8_labelXML.data(), utf8_buffSize_labelXML, nullptr);
	sqlite3_step(stmt);
	sqlite3_finalize(stmt);
	mainEditor->CloseDB(db);
	//б
	UpdateContext();
}

LRESULT CMCEditor::OnDXListSelChange(WPARAM wParam, LPARAM lParam)
{
	if (!pMCList.Empty() && !mcList.empty())
	{
		if (pMCList.GetCurSel() >= 0)
		{
			auto mainEditor = (CMainEditor*)pMainEditor;
			//ʾѡе±ĽɫϢ
			auto& mc = mcList.at(pMCList.GetCurSel());
			CString id_str;
			id_str.Format(L"ID%d", mc.id);
			static_id->SetWindowTextW(id_str.GetString());
			picbox.SetPic(mc.facePng);//ͷ
			radio_creature.SetCheck(false);//
			radio_sprite.SetCheck(false);
			if (mc.lifeType == 0)
				radio_creature.SetCheck(true);
			else if (mc.lifeType == 1)
				radio_sprite.SetCheck(true);
			edit_image.SetWindowTextW(mc.image);//ӡ
			edit_label.SetWindowTextW(mc.name);//
			combobox_pos.Clear();//ɫλ
			combobox_pos.AddString(mc.mcpos);
			combobox_pos.SetCurSel(0);
			combobox_char.Clear();//ɫԸ
			combobox_char.AddString(mc.mcChar);
			combobox_char.SetCurSel(0);
			radio_female.SetCheck(false);//Ա
			radio_male.SetCheck(false);
			radio_none.SetCheck(false);
			if(mc.gender == 0)
				radio_none.SetCheck(true);
			else if(mc.gender == 1)
				radio_female.SetCheck(true);
			else if (mc.gender == 2)
				radio_male.SetCheck(true);
			edit_ideal.SetWindowTextW(mc.ideal); //
			listbox_set.ResetContent();//趨ʵֱ
			std::unordered_map<std::wstring, MyLabelXML> labelList;
			mainEditor->GetXMLLabel_Map(&labelList, mc.labelXML);
			for (auto& p : labelList)
				listbox_set.AddString(p.second.name);
			listbox_set.EnableWindow(true);
		}
		else
		{
			//սɫϢ
			static_id->SetWindowTextW(L"ID");
			picbox.SetPic(L"");
			radio_creature.SetCheck(false);
			radio_sprite.SetCheck(false);
			edit_image.SetWindowTextW(L"");
			edit_label.SetWindowTextW(L"");
			combobox_pos.ResetContent();
			combobox_char.ResetContent();
			radio_female.SetCheck(false);
			radio_male.SetCheck(false);
			radio_none.SetCheck(false);
			edit_ideal.SetWindowTextW(L"");
			listbox_set.ResetContent();
			listbox_set.EnableWindow(false);
		}
	}
	return 0;
}

void CMCEditor::DisableCtrl()
{
	button_dir.EnableWindow(false);
	static_face->EnableWindow(false);
	radio_creature.EnableWindow(false);
	radio_sprite.EnableWindow(false);
	edit_image.EnableWindow(false);
	edit_label.EnableWindow(false);
	combobox_pos.EnableWindow(false);
	combobox_char.EnableWindow(false);
	radio_female.EnableWindow(false);
	radio_male.EnableWindow(false);
	radio_none.EnableWindow(false);
	edit_ideal.EnableWindow(false);
	listbox_set.EnableWindow(false);
	listbox_event.EnableWindow(false);
	listbox_map.EnableWindow(false);
}
