#include "PeLifeRecover.h"
#include "PeLifeRecoverShape.h"
#include "PeLifeRecoverLine.h"
PeLifeRecover::PeLifeRecover(std::weak_ptr<Entity> target, bool(*LeaveFunc)(std::weak_ptr<Entity> e), float dx, float dy, int range_dx)
{
	type = 3;
	attackParent = target;
	this->LeaveFunc = LeaveFunc;
	this->dx = dx;
	this->dy = dy;
	this->range_dx = range_dx;
	topDraw = true;
	auto wattackParent = attackParent.lock();
	if (wattackParent)
		lastHp = wattackParent->hp;
}

void PeLifeRecover::Step()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		//Ŀ
		x = wattackParent->x + dx;
		y = wattackParent->y + dy;
		last_x = wattackParent->last_x + dx;
		last_y = wattackParent->last_y + dy;
		if (wattackParent->hp > lastHp)
		{
			lastHp = wattackParent->hp;
			//Ч
			auto pe = std::make_shared<PeLifeRecoverShape>();
			pe->x = x + Random(-range_dx, range_dx);
			pe->y = y;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
	}
	if (Random(0,24) == 0)
	{
		int rdx = range_dx + 4;
		auto pe = std::make_shared<PeLifeRecoverLine>(0, 0);
		pe->x = x + Random(-rdx, rdx);
		pe->y = y;
		gameFunc->SetEntity(shared_from_this(), pe);
	}
	if (!leave)
		leave = LeaveFunc(attackParent);
	if (leave)
		Destroy();
}
