#include "EntityStateInvincible.h"

EntityStateInvincible::EntityStateInvincible()
{
	hurt_time_counter_max = 360;
}

void EntityStateInvincible::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	if (hurt_time_counter > 0)
	{
		hurt_time_counter--;
		if (hurt_time_counter == 0)
		{
			//˺
			hurt_counter = 0;
		}
		else
		{
			//ʧѪ1/4޵
			if (hurt_counter >= we->hp_max / 4.0f)
			{
				invincible_counter = 180;
				hurt_counter = 0;
				hurt_time_counter = 0;
			}
		}
	}
	//̺֡
	BYTE c = 0xff;
	if (we->ignoreTrap_counter > 0)
		c = 0x80;//ɺɫ
	//޵֡
	if (invincible_counter > 0)
	{
		invincible_counter--;
		if (enableFlash)
		{
			if (invincible_counter / 2 % 2 == 0)
				we->color = RGBA(0xff, c, c, 0x40);
			else
				we->color = RGBA(0xff, c, c, 0xc0);
		}
	}
	else
	{
		if (enableFlash)
			we->color = RGBA(0xff, c, c, 0xff);
	}
}

bool EntityStateInvincible::Hurt(std::weak_ptr<Entity> src, int* pGetDamage, float* pAngle, bool* pTakedown, int* pElemType, float* pShockForce, float* pHeavy, int* outRealDamage, bool* outRetVal)
{
	auto we = e.lock();
	if (!we)
		return false;

	if (invincible_counter > 0)
	{
		*outRetVal = false;
		return true;
	}
	return false;
}

bool EntityStateInvincible::BeginCaught(std::weak_ptr<Entity> src, std::weak_ptr<Entity>& ret)
{
	if (invincible_counter > 0)
	{
		//
		ret = std::weak_ptr<Entity>();//ᱻ
		return true;
	}
	else
	{
		//
		return false;
	}
}

void EntityStateInvincible::SetDamage(int dmg)
{
	auto we = e.lock();
	if (!we)
		return;

	hurt_counter += dmg;
	if (hurt_time_counter == 0)
		hurt_time_counter = hurt_time_counter_max;
	//ʧѪ1/4޵
	if (hurt_counter >= we->hp_max / 4.0f)
	{
		invincible_counter = 180;
		hurt_counter = 0;
		hurt_time_counter = 0;
	}
}

void EntityStateInvincible::SetInvincible(int times)
{
	invincible_counter = times;
	hurt_counter = 0;
	hurt_time_counter = 0;
}

void EntityStateInvincible::EnableFlash(bool enable)
{
	enableFlash = enable;
}
