#include "EntityState.h"
int entityStateID = 0;
void EntityState::Init(std::weak_ptr<Entity> e)
{
    this->e = e;
    SubInit(e);
}

bool EntityState::GetEnable()
{
    return enable;
}

void EntityState::SetEnable(bool bEnable)
{
    this->enable = bEnable;
}

void EntityState::Step()
{
    SubStep();
    if (!enable)
        return;
    State();
}

PlayerUIData* EntityState::GetUI()
{
	PlayerUIData* ui = nullptr;
	auto we = e.lock();
	if (!we)
		return nullptr;

	auto& gameFunc = we->gameFunc;
	//UI
	if (gameFunc)
	{
		int playerIndex = gameFunc->GetPlayerIndex(gameFunc->game, e);
		if (playerIndex >= 0)
			ui = gameFunc->GetPlayerUIData(gameFunc->gameUI, playerIndex);
	}
	return ui;
}

void EntityState::Reset()
{
}

void EntityState::State()
{
}

void EntityState::SetPhysice(bool bInWater)
{
}

void EntityState::ChangeStateMsg(int stateID)
{
}

void EntityState::SubInit(std::weak_ptr<Entity> e)
{
}

void EntityState::SubStep()
{
}

int EntityState::GetStateID()
{
	return stateID;
}

bool EntityState::Hurt(std::weak_ptr<Entity> src, int* pGetDamage, float* pAngle, bool* pTakedown, int* pElemType, float* pShockForce, float* pHeavy, int* outRealDamage, bool* outRetVal)
{
	return false;
}

bool EntityState::BeginCaught(std::weak_ptr<Entity> src, std::weak_ptr<Entity>& ret)
{
	return false;
}

void EntitySkillState::SubStep()
{
	auto pUI = GetUI();
	if (pUI)
	{
		auto& ui = *pUI;
		if (ui_index >= 0 && ui_index < 6)
		{
			ui.SkillArr[ui_index] = iconIndex;
			ui.SkillCDArr[ui_index] = (float)(cd_counter_max - cd_counter) / cd_counter_max;
			ui.SkillDisable[ui_index] = bUIShowDisableSkill;
			ui.SkillName[ui_index] = GetFuncName();
			ui.SkillCheckName[ui_index] = GetCheckFuncName();
		}
	}
}

const wchar_t* EntitySkillState::GetSaveName()
{
	return L"";
}

const wchar_t* EntitySkillState::GetFuncName()
{
	return L"";
}

const wchar_t* EntitySkillState::GetCheckFuncName()
{
	return L"";
}
