#pragma once
#include <memory>
#include <vector>
#include <string>
#include <list>
#include <queue>
#include <set>
#include <map>
#include <unordered_map>
#include "GameInput.h"
#include <unordered_set>
/*--------------------Ĳ----------------------*/
class Entity;
template<typename T>
class Rect;
struct GetRectEntity
{
	Rect<float>& operator()(Entity*) const;
};
template<typename T, typename GetRect, typename Equal>
class Quadtree;
/*---------------------Entityͷ-----------------------*/
#define RGBA(r,g,b,a) ((DWORD)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)|(((DWORD)(BYTE)(a))<<24)))
//ʵ
struct EntityFlag
{
	//
	bool tCheck = false;//ʱ¼
	bool tTouch = false;//Ӵʵʱ¼
	bool tDeath = false;//ʱ¼
	bool tCrush = false;//ƶƽ̨ѹʱ¼
	bool tHurt = false;//ʵʱ¼
	bool tDamage = false;//ʵ˺ʱ¼
	//ͼ
	bool fShow = false;//idʱڵͼʱ
	bool fHide = false;//idʱڵͼʱʧ
	//
	bool skShow = false;//skʱڵͼʱ
	bool skHide = false;//skʱڵͼʱʧ
	//ѡ
	bool lr = false;//Է
	bool text = false;//ıڲ˵
	bool save = false;//ʵͨϷ¼ؽбȡ
	bool simpAni = false;//ʹ0Ŷ ʵIDΪpngļ
};

//ʵؽṹ
struct EntityLoad
{
	std::wstring name;//ʵ
	int x = 0, y = 0;//
	std::wstring eid;//ʵ
	std::wstring eventName;//¼
	std::wstring arg;//ò
	std::wstring arg2;//ò
	std::wstring arg3;//ò
	EntityFlag flag;//
};
constexpr float ts = 0x200;//һԵĴС
class Entity;
struct MapLayer;
//״̬
struct CbRect
{
	//ѡ
	bool enableCbRect = false;//ײ㣨ӴǽõӴǽͣ
	bool enableSoild = false;//ǽżӴǽ壬ǽѸſ
	bool enableSelfSoild = false;//ǽ壨ʵſ
	bool enableMovePlatform = false;//ƽ̨ԣʵſ
	bool ignoreMovePlatform = false;//ƶƽ̨
	bool breakStarBlock = false;//ƻש
	//ʵײΧ
	float left = 8;
	float top = 8;
	float right = 8;
	float bottom = 8;
	//Ƿǽ
	bool cbLeft = 0;
	bool cbTop = 0;
	bool cbRight = 0;
	bool cbBottom = 0;
	//ǽ
	int pxaLeft = 0;
	int pxaTop = 0;
	int pxaRight = 0;
	int pxaBottom = 0;
	//Ƿվб
	bool onSlopeL = false;//б
	bool onSlopeLSide = false;//б
	bool onSlopeR = false;//б
	bool onSlopeRSide = false;//б
	//ǷӴ
	bool onTrap = false;
	//Ӵƶƽ̨
	std::weak_ptr<Entity> movingPlatformLeft;
	std::weak_ptr<Entity> movingPlatformTop;
	std::weak_ptr<Entity> movingPlatformRight;
	std::weak_ptr<Entity> movingPlatformBottom;
	//ˮ
	bool inWater = false;
	bool waterBlock = false;//ܽˮ
	bool fullWaterBlock = false;//ˮײˮײ16x16
	//
	bool inWind = false;
	int windDir = 0;//ķ789456123
	//ҽ
	bool inLava = false;
	int lavaDmg = 127;//ҽ˺
	//
	DWORD roomColor = UINT_MAX;
	std::vector<LONG>* pxmArr = nullptr;
	std::vector<int>* pxaArr = nullptr;
	std::map<LONG, LONG>* updatedPxmArr = nullptr;
	int pxmArr_w = 0;
	int pxaArr_w = 0;
	void (*Collision)(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w) = nullptr;
	SDL_FRect qtRect;
};

//Ż
struct Animation
{
	std::wstring png;//ļ
	std::wstring sprite_index;//
	int image_index = 0;//֡±
	float image_counter = 0;
	float image_counter_speed = 1.0f;//ٶ
	std::set<int> hideLayerList;//صͼб
};

//ɫ
struct EntityShader
{
	bool usingShader = false;//Ƿɫ
	std::wstring ps;//ɫ
	std::wstring vs;//ɫ
	std::vector<float> args;//ɫĲб
};
//ʵ
struct EntityLight
{
	bool usingLight = false;//ǷǷʵ
	void* layer = nullptr;//ͼͼ
};

struct EntityLayer
{
	std::list<std::shared_ptr<Entity>> Ls;//ʵ
	std::list<std::shared_ptr<Entity>> Ls2;//ʾϷʵ
	std::list<std::shared_ptr<Entity>> Am;//ҵ
	std::list<std::shared_ptr<Entity>> Pe;//Ч
	std::vector<std::shared_ptr<Entity>> addList;//ʵ
	std::unordered_set<Entity*> treeCheck;
	Quadtree <Entity*, GetRectEntity, std::equal_to<Entity*>>* quadTree = nullptr;
	virtual ~EntityLayer();
};

//·
struct PathCell
{
	float vec1_x;//
	float vec1_y;
	float dis;
};

//ɵѰ·
struct PathGrid
{
	std::vector<PathCell> vecMap;//ͼ
	void* mapLayer = nullptr;
};

//ǰ
struct PlayerUIData;
//Ϸܺ
struct GameFunc
{
	void (*PlaySound)(const wchar_t* soundName) = nullptr;//wav
	int (*PlayLoopSound)(const wchar_t* soundName) = nullptr;//ѭ
	void (*StopLoopSound)(int channelID) = nullptr;//ֹͣѭ
	bool (*GetFullScreen)() = nullptr;//Ƿȫ
	void (*SetFullScreen)(bool bFullScreen) = nullptr;//ʾȫ
	bool (*GetShowDebug)() = nullptr;//ǷʾϢ
	void (*SetShowDebug)(bool bShowDebug) = nullptr;//ʾϢ
	void (*EnlargeWindow)() = nullptr;//Ŵ󴰿
	void (*ReduceWindow)() = nullptr;//С
	int (*GetMusicVolume)() = nullptr;//ȡ[0-10]
	void (*SetMusicVolume)(int vol) = nullptr;//
	int (*GetSoundVolume)() = nullptr;//ȡЧ[0-10]
	void (*SetSoundVolume)(int vol) = nullptr;//Ч
	void (*OpenGameController)() = nullptr;//´ӵֱ豸
	void (*GetScanCodeName)(std::vector<wchar_t>* outName, SDL_Scancode key) = nullptr;//ȡɨ
	void (*GetGameControllerKeyName)(std::vector<wchar_t>* outName, SDL_GameControllerButtonBind* keyBind) = nullptr;//ȡֱ
	void (*GetGameControllerName)(std::vector<wchar_t>* outName, SDL_GameController* pGameController) = nullptr;//ȡֱ豸
	void (*ResetKeyboard)() = nullptr;//ü״̬
	bool (*GetAnyKeyPress)(SDL_Scancode* outKey) = nullptr;//ȡⰴ
	bool (*GetAnyGameControllerKeyPress)(SDL_GameController* pGameController, SDL_GameControllerButtonBind* keyBind) = nullptr;//ȡֱⰴ
	bool (*GetKey)(SDL_Scancode key) = nullptr;//ȡɨǷ
	void (*ResetKeySetting_Player1Keyboard)() = nullptr;//1м̰
	void (*ResetKeySetting_Player1Joystick)() = nullptr;//1ֱ
	void (*ResetKeySetting_Player2Keyboard)() = nullptr;//2м̰
	void (*ResetKeySetting_Player2Joystick)() = nullptr;//2ֱ
	InputSetting_Keyboard* (*GetInputSetting_Player1Keyboard)() = nullptr;//ȡ1
	InputSetting_Joystick* (*GetInputSetting_Player1Joystick)() = nullptr;//ȡ1ֱ
	InputSetting_Keyboard* (*GetInputSetting_Player2Keyboard)() = nullptr;//ȡ2
	InputSetting_Joystick* (*GetInputSetting_Player2Joystick)() = nullptr;//ȡ2ֱ
	SDL_GameController* (*GetGameControllerFromIndex)(int index) = nullptr;//±ȡֱ豸
	int (*GetPlayer1ControllerType)() = nullptr;//ȡ1
	int (*GetPlayer2ControllerType)() = nullptr;//ȡ2
	void (*SetPlayer1ControllerType)(int type) = nullptr;//1
	void (*SetPlayer2ControllerType)(int type) = nullptr;//2
	void (*LoadConfig)() = nullptr;//Ϸѡ
	void (*SaveConfig)() = nullptr;//Ϸѡ
	void* entityRes = nullptr;//ʵԴָ
	std::weak_ptr<Entity> (*GetMyChar_Player1)(void* entityRes) = nullptr;//ȡ1ʵ
	std::weak_ptr<Entity> (*GetMyChar_Player1_menuKeyboard)(void* entityRes) = nullptr;//ȡ1Ĳ˵ʵ
	std::weak_ptr<Entity> (*GetMyChar_Player2)(void* entityRes) = nullptr;//ȡ2ʵ
	std::weak_ptr<Entity> (*GetMyChar_Player2_menuKeyboard)(void* entityRes) = nullptr;//ȡ2Ĳ˵ʵ
	std::unordered_map<MapLayer*, EntityLayer>* (*GetLoadedEntity)(void* entityRes) = nullptr;//ȡǰеʵ
	void (*GetDisplayInfo)(void* entityRes, float* outWindow_w, float* outWindow_h, float* outScale, float* outOffX, float* outOffY) = nullptr;//ȡʾϢ
	void (*GetMousePos)(void* entityRes, float* pX, float* pY) = nullptr;//ȡӦʵλ
	bool (*InScreen)(void* entityRes, float x, float y) = nullptr;//ǷĻʾΧ
	void (*GridTouch)(void* entityRes, std::weak_ptr<Entity> e, EntityLayer* targetLayer) = nullptr;//ȡʵӴʵ
	void* gameMap = nullptr;//Ϸͼָ
	MapLayer* (*GetMapLayer)(void* gameMap, const wchar_t* layerName);//ȡͼͼ
	void* mapSizeGetter = nullptr;
	void (*GetMapSize)(void* mapSizeGetter, int* outMapW, int* outMapH) = nullptr;//ȡߴ
	void (*SetNewNameOption)(const wchar_t* gameName, int playerNum, int difficulty) = nullptr;//Ϸ
	void (*SetSaveName)(const wchar_t* saveName) = nullptr;//õǰ浵ļ
	void (*DelSave)(const wchar_t* saveName) = nullptr;//ɾ浵
	void (*SaveNameGetRoomName)(std::wstring* outRoomName, const wchar_t* saveName) = nullptr;//浵ȡ
	void (*WriteData)(const wchar_t* eid, const wchar_t* field, const wchar_t* value) = nullptr;//д
	const wchar_t* (*ReadData)(const wchar_t* eid, const wchar_t* field, const wchar_t* defaultVal) = nullptr;//ȡ
	void (*SetPauseMenuBackGame)(bool bBack) = nullptr;//ͣ˵Ϸ
	void (*SetPauseMenuBackTitle)(bool bBack) = nullptr;//ͣ˵ر⻭
	void* dmgNum = nullptr;//˺ָ
	void (*SetDmgNum)(void* dmgNum, int val, float x, float y, int style, std::weak_ptr<Entity> e) = nullptr;//һ˺ֵʾ
	std::shared_ptr<Entity>(*GameCreateEntity)(const wchar_t* name) = nullptr;//һʵڴУdll
	void (*SetEntity)(std::shared_ptr<Entity> parent, std::shared_ptr<Entity> newE) = nullptr;//һʵ
	void* gameScript = nullptr;//Ϸűָ
	void (*StartEvent)(void* gameScript, const wchar_t* eventName, const wchar_t* triggerType) = nullptr;//¼
	bool (*IsLockKeyboard)(void* gameScript) = nullptr;//Ƿ
	bool (*ScriptIsRunning)(void* gameScript) = nullptr;//Ƿ¼
	void* gameUI = nullptr;
	PlayerUIData* (*GetPlayerUIData)(void* gameUI, int playerIndex) = nullptr;//ȡUIʾ
	void (*StopMusic)() = nullptr;//ֹͣ
	void (*ScreenShot)() = nullptr;//ȡͼ
	void (*QuitGame)() = nullptr;//˳Ϸ
	const wchar_t* (*GetLanguage)() = nullptr;//ȡϷ
	void (*SetLanguage)(const wchar_t* lang) = nullptr;//
	void (*GetAllLanguage)(std::vector<std::wstring>* languageList) = nullptr;//ȡе
	void (*ReloadLanguage)() = nullptr;//Ч
	void (*SetLastPlaySlot)(int slotPage, int index) = nullptr;//Ĵ浵λ
	void (*GetLastPlaySlot)(int* outSlotPage, int* outIndex) = nullptr;//ȡĴ浵λ
	std::set<std::wstring>* flagSet = nullptr;//Ϸ
	std::set<std::wstring>* skipSet = nullptr;//
	PathCell* (*GetPath)(std::weak_ptr<Entity> e, float dstX, float dstY, float srcX, float srcY) = nullptr;//ȡѰ·
	bool (*LineTest)(std::weak_ptr<Entity> e, float srcX, float srcY, float dstX, float dstY) = nullptr;//ֱ߲
	void* game = nullptr;
	void (*SetMyChar_Player1)(void* game, std::weak_ptr<Entity> e) = nullptr;//1Ŀʵ
	void (*SetMyChar_Player2)(void* game, std::weak_ptr<Entity> e) = nullptr;//2Ŀʵ
	void (*SetGlobalEntity)(void* game, std::shared_ptr<Entity> we, const wchar_t* globalEntityID) = nullptr;//ʵõȫ
	std::weak_ptr<Entity> (*GetGlobalEntity)(void* game, const wchar_t* globalEntityID) = nullptr;//ȡȫʵָ
	std::unordered_map<std::wstring, std::weak_ptr<Entity>>* (*GetGlobalEntityTable)(void* game) = nullptr;//ȡȫʵָ
	int (*GetPlayerIndex)(void* game, std::weak_ptr<Entity> e) = nullptr;//ȡǰʵ±
	std::weak_ptr<Entity> (*GetPlayerDistance)(void* game, float x, float y) = nullptr;//ȡõ
	std::weak_ptr<Entity>(*GetPlayerDistanceLR)(void* game, float x, float y, int lr) = nullptr;//ȡõһ
	std::weak_ptr<Entity>(*GetPlayerDistanceWithLineTest)(void* game, float x, float y) = nullptr;//ȡõĿֱ
	std::weak_ptr<Entity>(*GetPlayerDistanceLRWithLineTest)(void* game, float x, float y, int lr) = nullptr;//ȡõһĿֱ
	void (*SetQuake)(void* game, int times, int mode) = nullptr;//mode:0С1󶶶
	void (*SetLocalCamera)(void* game, std::weak_ptr<Entity> e, float focusTimes) = nullptr;//þֲ
	void (*UnsetLocalCamera)(void* game, std::weak_ptr<Entity> e) = nullptr;//ȡõλľ۽
	bool (*InBossFight)(void* game) = nullptr;//ǷBossս
	std::weak_ptr<Entity>(*GetCheckEventPlayer)(void* game) = nullptr;//ȡһڵ¼
	int (*PlayerHaveItem)(void* game, const wchar_t* regID) = nullptr;//ӵĳƷ
	int (*PlayerAddItem)(void* game, const wchar_t* regID, int num) = nullptr;//ƷظƷ
	int (*PlayerDeleteItem)(void* game, const wchar_t* regID, int num) = nullptr;//ƳƷ-1ΪƳȫ,ʣ
	int* pGameOption_playerNum = nullptr;
	int* pGameOption_difficulty = nullptr;
	void (*DecodeRecord)(const wchar_t* recordStr, const void** outInputArr, size_t* outDataSize) = nullptr;//¼
	void* slotDrawer = nullptr;
	void (*SlotPageEnableDraw)(void* slotDrawer, bool bEnable) = nullptr;//ô浵ҳ
	void (*SlotPageDrawClear)(void* slotDrawer) = nullptr;//浵ҳб
	void (*SlotPageAddDraw)(void* slotDrawer, const wchar_t* saveName, std::weak_ptr<Entity> player1Icon, std::weak_ptr<Entity> player2Icon) = nullptr;//ҪƵҴ浵Ϣб
	void (*SlotPageReset)(void* slotDrawer) = nullptr;//ô浵ҳ
	void* gameFlash = nullptr;
	void (*SetScreenFlash)(void* gameFlash, int times) = nullptr;//Ļ˸
};

struct PenVertex
{
	float x = 0, y = 0;//
	DWORD c = 0xffffffff;//ɫ
};

//Ϸ
class Entity
	: public std::enable_shared_from_this<Entity>
{
public:
	Entity();
	Entity(int type);
	virtual ~Entity() = default;
	//
	virtual void Init(std::weak_ptr<Entity> self);//ʼ
	virtual void Step();
	virtual void SetState(int stateID, int lr);
	virtual void SetState(std::wstring stateName, int lr);
	virtual void DeltaTime(float deltaTime);//Ƹ
	virtual void Collision();//ִײ
	virtual void ClearCollisionResult();//һεײ
	virtual void BeginMovingPlatform();//ƶƽ̨ڴٶ֮ǰã
	virtual void EndMovingPlatform();//ƶƽ̨ڴٶ֮ã
	virtual void LoadSaveData();//ر
	virtual void WriteSaveData();//д뱣
	virtual bool Touch(std::weak_ptr<Entity> e);//ܺ
	virtual bool DeathByMovingPlatform();//ⱻƶƽ̨ѹ
	virtual bool Pathfinding(float targetX, float targetY, float* outDirX, float* outDirY);//Ѱ·ֻ16x16Сķ
	virtual int GetMapPxa(int x, int y);//ȡͼĳεpxaֵ
	virtual float GetShootingAngle();//ȡ
	virtual void KeepOnSlopes();//б
	virtual void GetCameraPos(float* outX, float* outY);//ȡ
	virtual void ImmUpdate();//ĳЩ
	virtual void KeepInMap();//ˮƽֹͼ
	virtual bool IsOutOfMap(int r = 8);//Ƿڵͼ֮
	virtual void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList);//ȡʵͼ
	virtual void Wind();//ܷӰ
	virtual void Destroy();//ɾʵ
	virtual void CopyFrom(std::shared_ptr<Entity>& another);//ԼһԼͬʵһģһ
	virtual void GetAnimateOffset(float& outDx, float& outDy);//ȡƫ
	//Ϸʼֵ\
	GameFunc* gameFunc = nullptr;
	//Ա
	float x = 0, y = 0;//
	float draw_x = 0, draw_y = 0;//꣨Lerpƣ
	float last_x = 0, last_y = 0;//꣨Lerpƣ
	float vx = 0, vy = 0;//ٶ
	int lr = 0, ud = 0;//
	bool initCheck = false;//ǿInit飬Ϊfalseлᵯʾ
	bool speedDir = false;//岻ʹ÷ʹٶֵΪ򣬸ñӰһЩ񵲼ܵж
	bool noDir = false;//޷ȫ򣩷Է赲̣
	//ʵײ
	CbRect cbRect;
	//ʾͼ
	Animation ani;
	//Ƿʹ
	bool inUsing = true;
	//
	bool hide = false;//ػֹͣʵ Ҳжϲ
	bool drawBeforeOtherEntity = false;//ʵ֮ǰ
	bool drawAfterPlayer = false;//Ƿʾ֮
	bool topDraw = false;//Ƿ񶥼ƣfade֮ϣ
	//
	EntityLoad el;
	//ʼ
	int type = 0;//0ʵ 1 2ҩ 3
	//
	DWORD color = 0xffffffff;//Ⱦɫ
	GameInput input;//Ϸ
	GameInput inputLock;//סϷ
	bool enableAI = false;//AI
	std::weak_ptr<Entity> ai;//AI
	std::wstring aiName;//õAI
	float axis[19];//ҡ˷ òеĻ
	//ʱ
	int coyote_counter = 0;
	int coyote_max =  3;
	//ǷǿʰȡƷ
	bool isItem = false;
	//ڵ¼ң
	bool inCheckingEvent = false;
	bool faceToBackEnd = false;//¼ź
	bool blockJump = false;//ֹ¼
	bool initCollision = true;//һʱִײ
	//ֵ
	int hp = 0;//ֵ
	int hp_max = 0;//ֵ
	int dropExp = 0;//ľ
	//
	int mp = 0;
	int mp_max = 0;
	//
	bool ignoreTrap = false;//
	int ignoreTrap_counter = 0;//ʱ
	int shock_counter = 0;//ζʱ䣨ֻͼƻζ
	//
	std::map<Entity*, int> damaged;//Entity*ֹȡ
	bool attackState = true;//Ƿù״̬ʵã
	int attackState_reset_counter_max = -1;//״̬ʧЧ״̬ʱ䣬 -1Ϊ
	int attackState_reset_counter = -1;
	int damaged_counter = 0;//ѹĴ
	int damaged_limit = 0;// 0
	int damage_reset_counter = -1;//Ŀٴˢ¹֡ʱ䣬 -1Ϊ
	std::weak_ptr<Entity> attackParent;//ĸʵ
	bool isTrap = false;//ʵ壨ʵ᳢Թʵ壩
	virtual bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage);
	virtual void Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy);
	virtual void Feedback(std::weak_ptr<Entity> target);
	virtual void AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage);//Ч
	virtual void AddDamagedEntity(Entity* e);//ⲿdamagedıд
	//ץȡ
	virtual std::weak_ptr<Entity> BeginCaught(std::weak_ptr<Entity> e);//ʼĳλץȡлץȡ״̬Ĳ
	virtual void EndCaught(std::weak_ptr<Entity> e);//ĳλץȡ(˳ץȡ״̬
	float caughtDifficulty = 0;//ץȡõλѶȣһЩֱץȡõλļжã0ǳ򵥣0.5ͨ1ѣ
	bool ignoreCaught = false;//ץȡ
	int ignoreCaught_counter = 0;//ץȡʱ
	//Ӵ
	std::vector<std::weak_ptr<Entity>> touchList;//Ӵʵб
	virtual void GridTouch(EntityLayer* targetLayer = nullptr);//½Ӵʵб
	virtual void AddTouchList(std::weak_ptr<Entity> e);//ⲿtouchListıд
	//Ʒ
	virtual bool Item(std::weak_ptr<Entity> src);//isItem=trueʹãΪʰȡƷʵ壨һңӴãܱĿʰȡ
	virtual void Gain(std::weak_ptr<Entity> item);//ʵ壨һңʰȡƷ
	//һЩϢ
	virtual void ReloadLanguage();//Ϸ
	//㼶 ʵڲ
	MapLayer* mapLayer = nullptr;
	EntityLayer* entityLayer = nullptr;
	//Զ
	std::vector<PenVertex> lineList;
	virtual int AddLine(std::vector<PenVertex>& lineList, int index, float x1, float y1, DWORD c1, float x2, float y2, DWORD c2);
	virtual int AddRect(std::vector<PenVertex>& lineList, int index, float left, float top, float right, float bottom,
		DWORD c_lu, DWORD c_ru, DWORD c_ld, DWORD c_rd);
	virtual int AddArc(std::vector<PenVertex>& lineList, int index, float r, float startAngle, float endAngle, DWORD c_start, DWORD c_end);
	std::vector<PenVertex> fillList;
	virtual int AddFillRect(std::vector<PenVertex>& fillList, int index, float left, float top, float right, float bottom,
		DWORD c_lu, DWORD c_ru, DWORD c_ld, DWORD c_rd);
	virtual int AddFillFadeCircle(std::vector<PenVertex>& fillList, int index, float radius, float featherSize, DWORD c);
	virtual int AddFillFadeRect(std::vector<PenVertex>& fillList, int index, float left, float top, float right, float bottom, float featherSize,
		DWORD c_lu, DWORD c_ru, DWORD c_ld, DWORD c_rd);
	//ɫ
	EntityShader shader;
	//ʵ
	EntityLight light;
	//ȫʵID
	std::wstring globalEntityID;
	//һ
	std::weak_ptr<Entity> self;
};

//ʵ
class ActionEntity :
	public Entity
{
public:
	int action_timecounter = 0;//ʱ
	int action_timecounter_max = INT_MAX;//ʱֵ
	//ֱ
	int atkFeedBack = 0;
	bool InAction();
	void CopyFrom(std::shared_ptr<Entity>& another) override;//ԼһԼͬʵһģһ
};
class EntityState;
class EntitySkillState;
//ҽɫʵ
class MyCharEntity :
	public ActionEntity
{
public:
	MyCharEntity();
	void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	void ImmUpdate() override;//ĳЩ
	void CopyFrom(std::shared_ptr<Entity>& another) override;//ԼһԼͬʵһģһ
	void KeepInMap();//ֹͼ
	virtual void SetPhysice(bool bInWater);//õˮ
	virtual void ChangeState(int stateID);//״̬
	virtual bool CheckCrush(std::wstring* pCrushEvent = nullptr);//鱻ѹ
	//
	int stateID = 0;
	//״̬
	std::vector<EntityState*> stateList;//״̬
	virtual void AddState(EntityState* state);
	//¼
	bool faceToBack = false;//򱳺
	//ܰ
	virtual void SetSkillBindIndex(EntitySkillState* skillState, int skillIndex);//Ѽܰ󶨵Ŀ±
	virtual void SetSkillBindAdd(EntitySkillState* skillState);//ԶѰһܿλ
	virtual void RemoveSkillBind(EntitySkillState* skillStat);//һ
	//ģ
	EntitySkillState* lastSkill = nullptr;
	//ܱ
	std::vector<EntitySkillState*> skillList;//ܱ
	virtual void AddSkill(EntitySkillState* skillState);
	std::wstring uiName;
	std::wstring saveName;
	//ͶƷ
	int throwItem = 0;
	int throwItem_max = 0;
	int throwItem_type = 0;
	std::vector<int> throwItemOther;//ͶƷ
	virtual void UpdateUI();
	//
	std::wstring lastAI_followTarget;
	float levelResetPos_x = 0;
	float levelResetPos_y = 0;
};

//UI
struct PlayerUIData
{
	std::wstring uiName;//ʹõUI
	int face = 0;//ʾUI±
	int Hp = 50;
	int HpMax = 50;
	int HpBar_flash_counter = 0;//˸ʱ
	int Mp = 50;
	int MpMax = 50;
	int MpBar_flash_counter = 0;//ħ˸ʱ
	int o2 = 0;//ֵ
	bool o2_show = false;//ʾֵ
	bool o2_effect = false;//Ч
	int SkillArr[6] = { -1 ,-1,-1 ,-1 ,-1 ,-1 };
	float SkillCDArr[6] = { 1,1,1,1,1,1 };
	bool SkillDisable[6] = { false ,false ,false ,false ,false ,false };
	std::wstring SkillName[6];//Ʒеļʾ
	std::wstring SkillCheckName[6];//Ʒеļ˵
	bool SwapOp = false;//λ
	int SwapSrc = -1, SwapDst = -1;//λõ±
	std::vector<int> throwItem;//Ͷб0ʹãxʾͶƷid-xʾյͶƷid
	std::vector<bool> appearEffect;
	std::vector<int> appearEffect_counter;//ͶƷЧ
	std::vector<bool> disappearEffect;
	std::vector<int> disappearEffect_counter;//ͶƷʧЧ
	//Ӳ˵
	bool bShowChildMenu = false;//ʾӲ˵
	int SkillArr_ChildMenu[6] = { -1 ,-1,-1 ,-1 ,-1 ,-1 };
	float SkillCDArr_ChildMenu[6] = { 1,1,1,1,1,1 };
	bool SkillDisable_ChildMenu[6] = { false ,false ,false ,false ,false ,false };
};

struct MyRect
{
	float left = 0, right = 0, top = 0, bottom = 0, z = 1;
};

struct MapLayer
{
	bool visible = true;//Ƿɼ
	std::wstring layerName;//ͼ
	//
	std::wstring pxaName;//ʹõĵ
	//ͼ
	int layerType = 0;
	//ͼ
	float offx = 0.0f;//ͼxƫ
	float offy = 0.0f;//ͼyƫ
	float myFar = 0;//Ӱʾƶ
	//ѭ
	bool loopH = false;
	bool loopV = false;
	float speedH = 0;
	float speedV = 0;
	//ͨ
	float order = 100.0f;
	int jumpFrame = 0;//ŵͼ󣬻ȽʵԾ֡
	//
	float dayLight = 1.0f;//
	float tinyHSV[3];//ϸ΢HSV
	float lightConst = 1.0f;//յĹӰ0-1
	//ɫ
	DWORD color;//rgbaȾɫ
	//Ƽ
	bool enableClipZone = false;
	MyRect clipZone;
};