#include "PeBlade.h"

PeBlade::PeBlade()
{
	type = 3;
	ani.png = L"pe_effect_obj";
	ani.sprite_index = GetSprite(Random(0, 5));
	action_timecounter = 6;
}

void PeBlade::Step()
{
	//ʱ
	if (action_timecounter > 0)
		action_timecounter--;
	else
		Destroy();
}

const wchar_t* PeBlade::GetSprite(int index)
{
	index %= 6;
	switch (index)
	{
	default:
	case 0:
		return L"blade1_angle_0";
	case 1:
		return L"blade1_angle_30";
	case 2:
		return L"blade1_angle_60";
	case 3:
		return L"blade1_angle_90";
	case 4:
		return L"blade1_angle_120";
	case 5:
		return L"blade1_angle_150";
	}
}

std::shared_ptr<Entity> CreatePeBlade()
{
	return std::make_shared<PeBlade>();
}

void SetPeBlade(std::shared_ptr<Entity> parent, float x, float y)
{
	auto peBlade = std::make_shared<PeBlade>();
	peBlade->x = x;
	peBlade->y = y;
	parent->gameFunc->SetEntity(parent, peBlade);
}
