#include "NameToEntity.h"
#include <map>
/*-----------------------------------------------Ai---------------------------------------------------*/
#include "AiMoveRecord.h"
#include "AiUpRecord.h"
#include "AiAdjustUp.h"
#include "AiDownRecord.h"
#include "AiMoveEnd.h"
#include "AiSingleBlock.h"
#include "AiMoveStop.h"
#include "AiKey.h"
#include "AiAction.h"
#include "AiStation.h"
/*----------------------------------------------Mc-------------------------------------------------*/
#include "MenuCursor.h"
#include "PauseMenuCursor.h"
/*-----------------------------------------------Sys---------------------------------------------------*/
#include "SysNull.h"
#include "SysSavePoint.h"
#include "SysTriggerH_AllPlayer.h"
#include "SysTriggerV_AllPlayer.h"
#include "SysTriggerH_Player1.h"
#include "SysTriggerV_Player1.h"
#include "SysTriggerH_Player2.h"
#include "SysTriggerV_Player2.h"
#include "SysLocalCamera.h"
#include "SysLocalCamera_H.h"
#include "SysLocalCamera_V.h"
/*-----------------------------------------------Entity---------------------------------------------------*/
/*-----------------------------------------------MenuText---------------------------------------------------*/
#include "MenuTextFullScreen.h"
#include "MenuTextShowDebug.h"
#include "MenuTextMusicVolume.h"
#include "MenuTextSoundVolume.h"
#include "MenuTextJoystick1Name.h"
#include "MenuTextJoystick2Name.h"
#include "MenuTextPlayer1JoystickName.h"
#include "MenuTextPlayer2JoystickName.h"
#include "MenuTextMsgPlayerPress.h"
#include "MenuTextP1Ball.h"
#include "MenuTextP2Ball.h"
//1̣
#include "MenuTextUp_Player1Keyboard.h"
#include "MenuTextDown_Player1Keyboard.h"
#include "MenuTextLeft_Player1Keyboard.h"
#include "MenuTextRight_Player1Keyboard.h"
#include "MenuTextOk_Player1Keyboard.h"
#include "MenuTextCancel_Player1Keyboard.h"
#include "MenuTextJump_Player1Keyboard.h"
#include "MenuTextAtk_Player1Keyboard.h"
#include "MenuTextMenu_Player1Keyboard.h"
#include "MenuTextInventory_Player1Keyboard.h"
#include "MenuTextMap_Player1Keyboard.h"
#include "MenuTextPagePrev_Player1Keyboard.h"
#include "MenuTextPageNext_Player1Keyboard.h"
#include "MenuResetKey_Player1Keyboard.h"
#include "MenuTextSk1_Player1Keyboard.h"
#include "MenuTextSk2_Player1Keyboard.h"
#include "MenuTextSk3_Player1Keyboard.h"
#include "MenuTextSk4_Player1Keyboard.h"
#include "MenuTextSk5_Player1Keyboard.h"
#include "MenuTextSk6_Player1Keyboard.h"
#include "MenuTextSwitchMc_Player1Keyboard.h"
//1ֱ
#include "MenuTextUp_Player1Joystick.h"
#include "MenuTextDown_Player1Joystick.h"
#include "MenuTextLeft_Player1Joystick.h"
#include "MenuTextRight_Player1Joystick.h"
#include "MenuTextOk_Player1Joystick.h"
#include "MenuTextCancel_Player1Joystick.h"
#include "MenuTextJump_Player1Joystick.h"
#include "MenuTextAtk_Player1Joystick.h"
#include "MenuTextMenu_Player1Joystick.h"
#include "MenuTextInventory_Player1Joystick.h"
#include "MenuTextMap_Player1Joystick.h"
#include "MenuTextPagePrev_Player1Joystick.h"
#include "MenuTextPageNext_Player1Joystick.h"
#include "MenuResetKey_Player1Joystick.h"
#include "MenuTextSk1_Player1Joystick.h"
#include "MenuTextSk2_Player1Joystick.h"
#include "MenuTextSk3_Player1Joystick.h"
#include "MenuTextSk4_Player1Joystick.h"
#include "MenuTextSk5_Player1Joystick.h"
#include "MenuTextSk6_Player1Joystick.h"
#include "MenuTextSwitchMc_Player1Joystick.h"
//2̣
#include "MenuTextUp_Player2Keyboard.h"
#include "MenuTextDown_Player2Keyboard.h"
#include "MenuTextLeft_Player2Keyboard.h"
#include "MenuTextRight_Player2Keyboard.h"
#include "MenuTextOk_Player2Keyboard.h"
#include "MenuTextCancel_Player2Keyboard.h"
#include "MenuTextJump_Player2Keyboard.h"
#include "MenuTextAtk_Player2Keyboard.h"
#include "MenuTextMenu_Player2Keyboard.h"
#include "MenuTextInventory_Player2Keyboard.h"
#include "MenuTextMap_Player2Keyboard.h"
#include "MenuTextPagePrev_Player2Keyboard.h"
#include "MenuTextPageNext_Player2Keyboard.h"
#include "MenuResetKey_Player2Keyboard.h"
#include "MenuTextSk1_Player2Keyboard.h"
#include "MenuTextSk2_Player2Keyboard.h"
#include "MenuTextSk3_Player2Keyboard.h"
#include "MenuTextSk4_Player2Keyboard.h"
#include "MenuTextSk5_Player2Keyboard.h"
#include "MenuTextSk6_Player2Keyboard.h"
#include "MenuTextSwitchMc_Player2Keyboard.h"
//2ֱ
#include "MenuTextUp_Player2Joystick.h"
#include "MenuTextDown_Player2Joystick.h"
#include "MenuTextLeft_Player2Joystick.h"
#include "MenuTextRight_Player2Joystick.h"
#include "MenuTextOk_Player2Joystick.h"
#include "MenuTextCancel_Player2Joystick.h"
#include "MenuTextJump_Player2Joystick.h"
#include "MenuTextAtk_Player2Joystick.h"
#include "MenuTextMenu_Player2Joystick.h"
#include "MenuTextInventory_Player2Joystick.h"
#include "MenuTextMap_Player2Joystick.h"
#include "MenuTextPagePrev_Player2Joystick.h"
#include "MenuTextPageNext_Player2Joystick.h"
#include "MenuResetKey_Player2Joystick.h"
#include "MenuTextSk1_Player2Joystick.h"
#include "MenuTextSk2_Player2Joystick.h"
#include "MenuTextSk3_Player2Joystick.h"
#include "MenuTextSk4_Player2Joystick.h"
#include "MenuTextSk5_Player2Joystick.h"
#include "MenuTextSk6_Player2Joystick.h"
#include "MenuTextSwitchMc_Player2Joystick.h"
#include "MenuTextSlotEmpty.h"
#include "MenuTextSlotRoomName.h"
#include "MenuTextDate.h"
/*-----------------------------------------------Enemy---------------------------------------------------*/

/*-----------------------------------------------Pe---------------------------------------------------*/
#include "PeBlade.h"
#include "PeSpark.h"
#include "PeSpray.h"
#include "PeSplash.h"
#include "PeLightPx.h"
#include "PeSmog.h"
#include "PeRainDrip.h"
#include "PeRain.h"
#include "PePointLight.h"
#include "PePixelCrack.h"
/*--------------------------------------------------------------------------------------------------*/
std::unordered_map<std::wstring, std::shared_ptr<Entity> (*)() > nameToEntity;

const wchar_t* EntityNameList[] =
{
	//Ai
	AIMOVERECORD_CREATENAME,
	AIUPRECORD_CREATENAME,
	AIADJUSTUP_CREATENAME,
	AIDOWNRECORD_CREATENAME,
	AIMOVEEND_CREATENAME,
	AISINGLEBLOCK_CREATENAME,
	AIMOVESTOP_CREATENAME,
	AIKEY_CREATENAME,
	AIACTION_CREATENAME,
	AISTATION_CREATENAME,
	//Mc
	MENUCURSOR_CREATENAME,
	PAUSEMENUCURSOR_CREATENAME,
	//Sys
	SYSNULL_CREATENAME,
	SYSSAVEPOINT_CREATENAME,
	SYSTRIGGERH_ALLPLAYER_CREATENAME,
	SYSTRIGGERV_ALLPLAYER_CREATENAME,
	SYSTRIGGERH_PLAYER1_CREATENAME,
	SYSTRIGGERV_PLAYER1_CREATENAME,
	SYSTRIGGERH_PLAYER2_CREATENAME,
	SYSTRIGGERV_PLAYER2_CREATENAME,
	SYSLOCALCAMERA_CREATENAME,
	SYSLOCALCAMERA_H_CREATENAME,
	SYSLOCALCAMERA_V_CREATENAME,
	//Entity
	//MenuText
	MENUTEXTFULLSCREEN_CREATENAME,
	MENUTEXTSHOWDEBUG_CREATENAME,
	MENUTEXTMUSICVOLUME_CREATENAME,
	MENUTEXTSOUNDVOLUME_CREATENAME,
	MENUTEXTJOYSTICK1NAME_CREATENAME,
	MENUTEXTJOYSTICK2NAME_CREATENAME,
	MENUTEXTPLAYER1JOYSTICKNAME_CREATENAME,
	MENUTEXTPLAYER2JOYSTICKNAME_CREATENAME,
	MENUTEXT_MSG_PLAYERPRESS_CREATENAME,
	MENUTEXTP1BALL_CREATENAME,
	MENUTEXTP2BALL_CREATENAME,
	//1̣
	MENUTEXTUP_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTDOWN_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTLEFT_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTRIGHT_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTOK_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTCANCEL_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTJUMP_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTATK_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTMENU_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTINVENTORY_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTMAP_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTPAGEPREV_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTPAGENEXT_PLAYER1KEYBOARD_CREATENAME,
	MENURESETKEY_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTSK1_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTSK2_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTSK3_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTSK4_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTSK5_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTSK6_PLAYER1KEYBOARD_CREATENAME,
	MENUTEXTSWITCHMC_PLAYER1KEYBOARD_CREATENAME,
	//1ֱ
	MENUTEXTUP_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTDOWN_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTLEFT_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTRIGHT_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTOK_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTCANCEL_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTJUMP_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTATK_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTMENU_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTINVENTORY_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTMAP_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTPAGEPREV_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTPAGENEXT_PLAYER1JOYSTICK_CREATENAME,
	MENURESETKEY_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTSK1_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTSK2_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTSK3_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTSK4_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTSK5_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTSK6_PLAYER1JOYSTICK_CREATENAME,
	MENUTEXTSWITCHMC_PLAYER1JOYSTICK_CREATENAME,
	//2̣
	MENUTEXTUP_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTDOWN_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTLEFT_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTRIGHT_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTOK_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTCANCEL_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTJUMP_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTATK_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTMENU_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTINVENTORY_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTMAP_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTPAGEPREV_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTPAGENEXT_PLAYER2KEYBOARD_CREATENAME,
	MENURESETKEY_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTSK1_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTSK2_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTSK3_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTSK4_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTSK5_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTSK6_PLAYER2KEYBOARD_CREATENAME,
	MENUTEXTSWITCHMC_PLAYER2KEYBOARD_CREATENAME,
	//2ֱ
	MENUTEXTUP_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTDOWN_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTLEFT_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTRIGHT_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTOK_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTCANCEL_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTJUMP_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTATK_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTMENU_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTINVENTORY_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTMAP_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTPAGEPREV_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTPAGENEXT_PLAYER2JOYSTICK_CREATENAME,
	MENURESETKEY_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSK1_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSK2_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSK3_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSK4_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSK5_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSK6_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSWITCHMC_PLAYER2JOYSTICK_CREATENAME,
	MENUTEXTSLOTEMPTY_CREATENAME,
	MENUTEXTSLOTROOMNAME_CREATENAME,
	MENUTEXTDATE_CREATENAME,
	//Enemy
	//Pe
	PEBLADE_CREATENAME,
	PESPARK_CREATENAME,
	PESPRAY_CREATENAME,
	PESPLASH_CREATENAME,
	PELIGHTPX_CREATENAME,
	PESMOG_CREATENAME,
	PERAINDRIP_CREATENAME,
	PERAIN_CREATENAME,
	PEPOINTLIGHT_CREATENAME,
	PEPIXELCRACK_CREATENAME,
};

struct NameCreateFunc
{
	const wchar_t* name;
	std::shared_ptr<Entity>(*func)();
}nameCreateFunc[] =
{
	//Ai
	{AIMOVERECORD_CREATENAME, CreateAiMoveRecord},
	{AIUPRECORD_CREATENAME, CreateAiUpRecord},
	{AIADJUSTUP_CREATENAME, CreateAiAdjustUp},
	{AIDOWNRECORD_CREATENAME, CreateAiDownRecord},
	{AIMOVEEND_CREATENAME, CreateAiMoveEnd},
	{AISINGLEBLOCK_CREATENAME, CreateAiSingleBlock},
	{AIMOVESTOP_CREATENAME, CreateAiMoveStop},
	{AIKEY_CREATENAME, CreateAiKey},
	{AIACTION_CREATENAME, CreateAiAction},
	{AISTATION_CREATENAME, CreateAiStation},
	//Mychar
	{MENUCURSOR_CREATENAME, CreateMenuCursor},
	{PAUSEMENUCURSOR_CREATENAME, CreatePauseMenuCursor},
	//Sys
	{SYSNULL_CREATENAME, CreateSysNull},
	{SYSSAVEPOINT_CREATENAME, CreateSysSavePoint},
	{SYSTRIGGERH_ALLPLAYER_CREATENAME, CreateSysTriggerH_AllPlayer},
	{SYSTRIGGERV_ALLPLAYER_CREATENAME, CreateSysTriggerV_AllPlayer},
	{SYSTRIGGERH_PLAYER1_CREATENAME, CreateSysTriggerH_Player1},
	{SYSTRIGGERV_PLAYER1_CREATENAME, CreateSysTriggerV_Player1},
	{SYSTRIGGERH_PLAYER2_CREATENAME, CreateSysTriggerH_Player2},
	{SYSTRIGGERV_PLAYER2_CREATENAME, CreateSysTriggerV_Player2},
	{SYSLOCALCAMERA_CREATENAME, CreateSysLocalCamera},
	{SYSLOCALCAMERA_H_CREATENAME, CreateSysLocalCamera_H},
	{SYSLOCALCAMERA_V_CREATENAME, CreateSysLocalCamera_V},
	//Entity
	//MenuText
	{MENUTEXTFULLSCREEN_CREATENAME, CreateMenuTextFullScreen},
	{MENUTEXTSHOWDEBUG_CREATENAME, CreateMenuTextShowDebug},
	{MENUTEXTMUSICVOLUME_CREATENAME, CreateMenuTextMusicVolume},
	{MENUTEXTSOUNDVOLUME_CREATENAME, CreateMenuTextSoundVolume},
	{MENUTEXTJOYSTICK1NAME_CREATENAME, CreateMenuTextJoystick1Name},
	{MENUTEXTJOYSTICK2NAME_CREATENAME, CreateMenuTextJoystick2Name},
	{MENUTEXTPLAYER1JOYSTICKNAME_CREATENAME, CreateMenuTextPlayer1JoystickName},
	{MENUTEXTPLAYER2JOYSTICKNAME_CREATENAME, CreateMenuTextPlayer2JoystickName},
	{MENUTEXT_MSG_PLAYERPRESS_CREATENAME, CreateMenuTextMsgPlayerPress},
	{MENUTEXTP1BALL_CREATENAME, CreateMenuTextP1Ball},
	{MENUTEXTP2BALL_CREATENAME, CreateMenuTextP2Ball},
	//1̣
	{MENUTEXTUP_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextUp_Player1Keyboard},
	{MENUTEXTDOWN_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextDown_Player1Keyboard},
	{MENUTEXTLEFT_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextLeft_Player1Keyboard},
	{MENUTEXTRIGHT_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextRight_Player1Keyboard},
	{MENUTEXTOK_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextOk_Player1Keyboard},
	{MENUTEXTCANCEL_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextCancel_Player1Keyboard},
	{MENUTEXTJUMP_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextJump_Player1Keyboard},
	{MENUTEXTATK_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextAtk_Player1Keyboard},
	{MENUTEXTMENU_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextMenu_Player1Keyboard},
	{MENUTEXTINVENTORY_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextInventory_Player1Keyboard},
	{MENUTEXTMAP_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextMap_Player1Keyboard},
	{MENUTEXTPAGEPREV_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextPagePrev_Player1Keyboard},
	{MENUTEXTPAGENEXT_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextPageNext_Player1Keyboard},
	{MENURESETKEY_PLAYER1KEYBOARD_CREATENAME, CreateMenuResetKey_Player1Keyboard},
	{MENUTEXTSK1_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSk1_Player1Keyboard},
	{MENUTEXTSK1_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSk1_Player1Keyboard},
	{MENUTEXTSK2_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSk2_Player1Keyboard},
	{MENUTEXTSK3_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSk3_Player1Keyboard},
	{MENUTEXTSK4_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSk4_Player1Keyboard},
	{MENUTEXTSK5_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSk5_Player1Keyboard},
	{MENUTEXTSK6_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSk6_Player1Keyboard},
	{MENUTEXTSWITCHMC_PLAYER1KEYBOARD_CREATENAME, CreateMenuTextSwitchMc_Player1Keyboard},
	//1ֱ
	{MENUTEXTUP_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextUp_Player1Joystick},
	{MENUTEXTDOWN_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextDown_Player1Joystick},
	{MENUTEXTLEFT_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextLeft_Player1Joystick},
	{MENUTEXTRIGHT_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextRight_Player1Joystick},
	{MENUTEXTOK_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextOk_Player1Joystick},
	{MENUTEXTCANCEL_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextCancel_Player1Joystick},
	{MENUTEXTJUMP_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextJump_Player1Joystick},
	{MENUTEXTATK_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextAtk_Player1Joystick},
	{MENUTEXTMENU_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextMenu_Player1Joystick},
	{MENUTEXTINVENTORY_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextInventory_Player1Joystick},
	{MENUTEXTMAP_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextMap_Player1Joystick},
	{MENUTEXTPAGEPREV_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextPagePrev_Player1Joystick},
	{MENUTEXTPAGENEXT_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextPageNext_Player1Joystick},
	{MENURESETKEY_PLAYER1JOYSTICK_CREATENAME, CreateMenuResetKey_Player1Joystick},
	{MENUTEXTSK1_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextSk1_Player1Joystick},
	{MENUTEXTSK2_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextSk2_Player1Joystick},
	{MENUTEXTSK3_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextSk3_Player1Joystick},
	{MENUTEXTSK4_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextSk4_Player1Joystick},
	{MENUTEXTSK5_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextSk5_Player1Joystick},
	{MENUTEXTSK6_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextSk6_Player1Joystick},
	{MENUTEXTSWITCHMC_PLAYER1JOYSTICK_CREATENAME, CreateMenuTextSwitchMc_Player1Joystick},
	//2̣
	{MENUTEXTUP_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextUp_Player2Keyboard},
	{MENUTEXTDOWN_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextDown_Player2Keyboard},
	{MENUTEXTLEFT_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextLeft_Player2Keyboard},
	{MENUTEXTRIGHT_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextRight_Player2Keyboard},
	{MENUTEXTOK_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextOk_Player2Keyboard},
	{MENUTEXTCANCEL_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextCancel_Player2Keyboard},
	{MENUTEXTJUMP_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextJump_Player2Keyboard},
	{MENUTEXTATK_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextAtk_Player2Keyboard},
	{MENUTEXTMENU_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextMenu_Player2Keyboard},
	{MENUTEXTINVENTORY_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextInventory_Player2Keyboard},
	{MENUTEXTMAP_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextMap_Player2Keyboard},
	{MENUTEXTPAGEPREV_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextPagePrev_Player2Keyboard},
	{MENUTEXTPAGENEXT_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextPageNext_Player2Keyboard},
	{MENURESETKEY_PLAYER2KEYBOARD_CREATENAME, CreateMenuResetKey_Player2Keyboard},
	{MENUTEXTSK1_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextSk1_Player2Keyboard},
	{MENUTEXTSK2_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextSk2_Player2Keyboard},
	{MENUTEXTSK3_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextSk3_Player2Keyboard},
	{MENUTEXTSK4_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextSk4_Player2Keyboard},
	{MENUTEXTSK5_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextSk5_Player2Keyboard},
	{MENUTEXTSK6_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextSk6_Player2Keyboard},
	{MENUTEXTSWITCHMC_PLAYER2KEYBOARD_CREATENAME, CreateMenuTextSwitchMc_Player2Keyboard},
	//2ֱ
	{MENUTEXTUP_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextUp_Player2Joystick},
	{MENUTEXTDOWN_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextDown_Player2Joystick},
	{MENUTEXTLEFT_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextLeft_Player2Joystick},
	{MENUTEXTRIGHT_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextRight_Player2Joystick},
	{MENUTEXTOK_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextOk_Player2Joystick},
	{MENUTEXTCANCEL_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextCancel_Player2Joystick},
	{MENUTEXTJUMP_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextJump_Player2Joystick},
	{MENUTEXTATK_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextAtk_Player2Joystick},
	{MENUTEXTMENU_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextMenu_Player2Joystick},
	{MENUTEXTINVENTORY_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextInventory_Player2Joystick},
	{MENUTEXTMAP_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextMap_Player2Joystick},
	{MENUTEXTPAGEPREV_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextPagePrev_Player2Joystick},
	{MENUTEXTPAGENEXT_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextPageNext_Player2Joystick},
	{MENURESETKEY_PLAYER2JOYSTICK_CREATENAME, CreateMenuResetKey_Player2Joystick},
	{MENUTEXTSK1_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextSk1_Player2Joystick},
	{MENUTEXTSK2_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextSk2_Player2Joystick},
	{MENUTEXTSK3_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextSk3_Player2Joystick},
	{MENUTEXTSK4_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextSk4_Player2Joystick},
	{MENUTEXTSK5_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextSk5_Player2Joystick},
	{MENUTEXTSK6_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextSk6_Player2Joystick},
	{MENUTEXTSWITCHMC_PLAYER2JOYSTICK_CREATENAME, CreateMenuTextSwitchMc_Player2Joystick},
	{MENUTEXTSLOTEMPTY_CREATENAME, CreateMenuTextSlotEmpty},
	{MENUTEXTSLOTROOMNAME_CREATENAME, CreateMenuTextSlotRoomName},
	{MENUTEXTDATE_CREATENAME, CreateMenuTextDate},
	//Enemy
	//Pe
	{PEBLADE_CREATENAME, CreatePeBlade},
	{PESPARK_CREATENAME, CreatePeSpark},
	{PESPRAY_CREATENAME, CreatePeSpray},
	{PESPLASH_CREATENAME, CreatePeSplash},
	{PELIGHTPX_CREATENAME, CreatePeLightPx},
	{PESMOG_CREATENAME, CreatePeSmog},
	{PERAINDRIP_CREATENAME, CreatePeRainDrip},
	{PERAIN_CREATENAME, CreatePeRain},
	{PEPOINTLIGHT_CREATENAME, CreatePePointLight},
	{PEPIXELCRACK_CREATENAME, CreatePePixelCrack},
};
void InitNameToEntity()
{
	nameToEntity.clear();
	for (auto& p : nameCreateFunc)
		nameToEntity.insert(std::make_pair(p.name, p.func));
}
/*----------------------------------------------dll--------------------------------------------*/
DLLAPI void __stdcall GameCreateEntity(const wchar_t* name, std::shared_ptr<Entity>* sp)
{
	if (nameToEntity.empty())
		InitNameToEntity();
	auto iter = nameToEntity.find(name);
	if (iter != nameToEntity.end())
	{
		*sp = iter->second();
	}
	else
	{
		*sp = nullptr;
	}
}

extern "C" DLLAPI int __stdcall GetEntityCount()
{
	return _countof(EntityNameList);
}

extern "C" DLLAPI const wchar_t* __stdcall GetEntityName(int id)
{
	return EntityNameList[id];
}
