#include "MenuResetKey_Player2Keyboard.h"

#include "MenuTextUp_Player2Keyboard.h"
#include "MenuTextDown_Player2Keyboard.h"
#include "MenuTextLeft_Player2Keyboard.h"
#include "MenuTextRight_Player2Keyboard.h"
#include "MenuTextOk_Player2Keyboard.h"
#include "MenuTextCancel_Player2Keyboard.h"
#include "MenuTextJump_Player2Keyboard.h"
#include "MenuTextAtk_Player2Keyboard.h"
#include "MenuTextMenu_Player2Keyboard.h"
#include "MenuTextInventory_Player2Keyboard.h"
#include "MenuTextMap_Player2Keyboard.h"
#include "MenuTextPagePrev_Player2Keyboard.h"
#include "MenuTextPageNext_Player2Keyboard.h"
#include "MenuTextSk1_Player2Keyboard.h"
#include "MenuTextSk2_Player2Keyboard.h"
#include "MenuTextSk3_Player2Keyboard.h"
#include "MenuTextSk4_Player2Keyboard.h"
#include "MenuTextSk5_Player2Keyboard.h"
#include "MenuTextSk6_Player2Keyboard.h"
#include "MenuTextSwitchMc_Player2Keyboard.h"
MenuResetKey_Player2Keyboard::MenuResetKey_Player2Keyboard()
{
	ani.png = L"menu_CS_title";
	ani.sprite_index = L"msg_reset";
}

void MenuResetKey_Player2Keyboard::Step()
{
	if (gameFunc->GetInputSetting_Player2Keyboard)
	{
		if (gameFunc->GetKey(SDL_SCANCODE_ESCAPE))
		{
			if (counter == 1)
			{
				gameFunc->PlaySound(L"MenuCancel");
				gameFunc->ResetKeySetting_Player2Keyboard();
				gameFunc->SaveConfig();
				//޸bug
				std::weak_ptr<Entity> eArr[] = {
					GetEntityByType(MENUTEXTUP_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTMAP_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTDOWN_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTJUMP_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTLEFT_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTATK_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTRIGHT_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK1_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTOK_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK2_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTCANCEL_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK3_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTMENU_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK4_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTINVENTORY_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK5_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTPAGEPREV_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK6_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTPAGENEXT_PLAYER2KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSWITCHMC_PLAYER2KEYBOARD_CREATENAME)
				};
				for (int i = 0; i < _countof(eArr); i++)
				{
					auto we = eArr[i].lock();
					if (we)
					{
						we->ani.png = we->ani.sprite_index = L"";
						we->el.flag.text = true;
						we->SetState(0, 0);
					}
				}
			}
			if (counter > 0)
				counter--;
		}
		else
			counter = counter_max;
		if (counter == 0)
		{
			ani.sprite_index = L"msg_resetDone";
		}
		else if (counter >= counter_max)
		{
			ani.sprite_index = L"msg_reset";
		}
		else
		{
			int num = counter / 40;
			if (num >= 0 && num <= 4)
			{
				wchar_t buff[MAX_PATH];
				swprintf_s(buff, L"msg_count%d", num);
				ani.sprite_index = buff;
			}
		}
	}
}

std::weak_ptr<Entity> MenuResetKey_Player2Keyboard::GetEntityByType(const wchar_t* name)
{
	auto loadedEntity = gameFunc->GetLoadedEntity(gameFunc->entityRes);
	for (auto& p : *loadedEntity)
	{
		for (auto& e : p.second.Ls)
		{
			if (e->el.name == name)
				return e;
		}
	}
	return std::weak_ptr<Entity>();
}

std::shared_ptr<Entity> CreateMenuResetKey_Player2Keyboard()
{
	return std::make_shared<MenuResetKey_Player2Keyboard>();
}