#include "CS_TorokoAni.h"

CS_TorokoAni::CS_TorokoAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_TorokoAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_TorokoAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 3://ܲ
		if (lr == 0)
		{
			vx -= 0x10 / ts;
		}
		else
		{
			vx += 0x10 / ts;
		}
		if (vx > 0x400 / ts)
			vx = 0x400 / ts;
		if (vx < -0x400 / ts)
			vx = -0x400 / ts;
		break;
	case 4://
		vx = 0;
		vy = 0;
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 5://ڴ˯
		vx = 0;
		vy = 0;
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_TorokoAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_toroko_stand_l" : L"mc_toroko_stand_r";
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				const wchar_t* move = L"";
				if (ud == -1)
					move = lr == 0 ? L"mc_toroko_move_lu" : L"mc_toroko_move_ru";
				else
					move = lr == 0 ? L"mc_toroko_move_l" : L"mc_toroko_move_r";
				ani.sprite_index = move;
			}
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_toroko_back_l" : L"mc_toroko_back_r";
			break;
		case 3://ܲ
			ani.sprite_index = lr == 0 ? L"mc_toroko_run_l" : L"mc_toroko_run_r";
			break;
		case 4://
			vx = 0;
			y -= 3;
			ani.sprite_index = lr == 0 ? L"mc_toroko_sit_l" : L"mc_toroko_sit_r";
			break;
		case 5://ڴ˯
			y -= 6;
			x -= 9;
			vx = 0;
			vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_toroko_sleep_l" : L"mc_toroko_sleep_r";
			break;
		case 6://ٶܲ
			if(lr == 0)
				vx = -0x400 / ts;
			else
				vx = 0x400 / ts;
			ani.sprite_index = lr == 0 ? L"mc_toroko_run_l" : L"mc_toroko_run_r";
			stateID = 3;
			break;
		}
	}
}

void CS_TorokoAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"run")
		SetState(3, lr);
	else if (stateName == L"jump")
		vy = -0x300 / ts;
	else if (stateName == L"sit_on_chair")
		SetState(4, lr);
	else if (stateName == L"sleep_on_bed")
		SetState(5, lr);
	else if (stateName == L"big_jump")
		vy = -0x700 / ts;
	else if (stateName == L"run_max_speed")
		SetState(6, lr);
}

std::shared_ptr<Entity> CreateCS_TorokoAni()
{
	return std::make_shared<CS_TorokoAni>();
}
