#include "CS_TeleporterLargeHead.h"
#include "CS_TeleporterLargeHeadHotWind.h"
CS_TeleporterLargeHead::CS_TeleporterLargeHead()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_teleporter_large_head";
	drawBeforeOtherEntity = true;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	//þο
	cbRect.top = 8;
	cbRect.bottom = 0;
	cbRect.left = cbRect.right = 16;
	//ͼʾ
	ani.hideLayerList.insert({ 0,1,2,3,4,5,6,7,8,9,10,11 });
}

CS_TeleporterLargeHead::~CS_TeleporterLargeHead()
{
	if (soundID != -1)
	{
		gameFunc->StopLoopSound(soundID);
	}
}

void CS_TeleporterLargeHead::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	srcY = y;
	Entity::Init(self);
}

void CS_TeleporterLargeHead::Step()
{
	stateGravity.SetPhysice(cbRect.inWater);
	stateSplash.SetPhysice(cbRect.inWater);
	switch (stateID)
	{
	case 0://ػ״̬
		[[fallthrough]];
	case 1://״̬ ƣûпɴ͵ص㣩
		stateGravity.Step();
		stateSplash.Step();
		break;
	case 2://״̬  ƣпɴ͵ص㣩
		break;
	case 3://⹦  ȵ
		SetHotWind();
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_TeleporterLargeHead::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (lr != 0)
		stateID = 2;
	this->stateID = stateID;
	switch (stateID)
	{
	case 0://ػ״̬
		ani.hideLayerList.insert({ 0,1,2,3,4,5,6,7,8,9,10,11 });
		break;
	case 1://״̬ ƣûпɴ͵ص㣩
		ani.hideLayerList.insert({ 0,1,2,3,8,9,10,11 });
		ani.hideLayerList.erase(4);
		ani.hideLayerList.erase(5);
		ani.hideLayerList.erase(6);
		ani.hideLayerList.erase(7);
		break;
	case 2://״̬  ƣпɴ͵ص㣩
		ani.hideLayerList.insert({ 4,5,6,7,8,9,10,11 });
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(1);
		ani.hideLayerList.erase(2);
		ani.hideLayerList.erase(3);
		vy = 0;
		break;
	case 3://⹦  ȵ
		ani.hideLayerList.insert({ 0,1,2,3,4,5,6,7 });
		ani.hideLayerList.erase(8);
		ani.hideLayerList.erase(9);
		ani.hideLayerList.erase(10);
		ani.hideLayerList.erase(11);
		vy = 0;
		y -= 96;
		soundID = gameFunc->PlayLoopSound(L"CS_dry");
		break;
	}
}

void CS_TeleporterLargeHead::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"off")
		SetState(0, lr);
	else if(stateName == L"empty")
		SetState(1, lr);
	else if (stateName == L"on")
		SetState(2, lr);
	else if (stateName == L"special")
		SetState(3, lr);
}

void CS_TeleporterLargeHead::SetHotWind()
{
	auto pe = std::make_shared<CS_TeleporterLargeHeadHotWind>();
	pe->y = srcY - 16;
	pe->x = x + (float)Random((int)-cbRect.left, (int)cbRect.right);
	gameFunc->SetEntity(shared_from_this(), pe);
}

std::shared_ptr<Entity> CreateCS_TeleporterLargeHead()
{
	return std::make_shared<CS_TeleporterLargeHead>();
}
