#include "CS_Sunstone.h"

CS_Sunstone::CS_Sunstone()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_sunstone";
	drawBeforeOtherEntity = true;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.left = 16;
	cbRect.top = 16;
	cbRect.right = 16;
	cbRect.bottom = 16;
}

void CS_Sunstone::Init(std::weak_ptr<Entity> self)
{
	x += 0x1000 / ts;
	y += 0x1000 / ts;
	last_x = x;
	last_y = y;
	Entity::Init(self);
}

void CS_Sunstone::Step()
{
	//ִ˶
	Entity::Step();
	switch (stateID)
	{
	case 0:
		break;
	case 1://
		y -= moveSpeed;
		MoveEffect();
		break;
	case 2://
		y += moveSpeed;
		MoveEffect();
		break;
	case 3://
		x -= moveSpeed;
		MoveEffect();
		break;
	case 4://
		x += moveSpeed;
		MoveEffect();
		break;
	}
	ani.image_index = lr == 0 ? 0 : 1;
}

void CS_Sunstone::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal" || stateName == L"stop")
	{
		stateID = 0;
		lr = 0;
	}
	else if (stateName == L"up")
	{
		stateID = 1;
		lr = 1;
	}
	else if (stateName == L"down")
	{
		stateID = 2;
		lr = 1;
	}
	else if (stateName == L"left")
	{
		stateID = 3;
		lr = 1;
	}
	else if (stateName == L"right")
	{
		stateID = 4;
		lr = 1;
	}
	ani.image_index = lr == 0 ? 0 : 1;
}

void CS_Sunstone::MoveEffect()
{
	if (++move_counter % 8 == 0)
		gameFunc->PlaySound(L"CS_026_quake");
	if (gameFunc->SetQuake)
		gameFunc->SetQuake(gameFunc->game, 20, 0);
}

std::shared_ptr<Entity> CreateCS_Sunstone()
{
	return std::make_shared<CS_Sunstone>();
}
