#include "CS_SueAni.h"

CS_SueAni::CS_SueAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_SueAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	Entity::Init(self);
}

void CS_SueAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 4://
		vx = 0;
		vy = 0;
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 5://ڴ˯
		vx = 0;
		vy = 0;
		break;
	case 6:
		stateResist.SetPhysice(cbRect.inWater);
		if (cbRect.cbBottom)
		{
			stateResist.Step();
			ani.sprite_index = lr == 0 ? L"mc_sue_lie_l" : L"mc_sue_lie_r";
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_SueAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_sue_stand_l" : L"mc_sue_stand_r";
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				const wchar_t* move = L"";
				if (ud == -1)
					move = lr == 0 ? L"mc_sue_move_lu" : L"mc_sue_move_ru";
				else
					move = lr == 0 ? L"mc_sue_move_l" : L"mc_sue_move_r";
				ani.sprite_index = move;
			}
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_sue_back_l" : L"mc_sue_back_r";
			break;
		case 3://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_sue_angry_l" : L"mc_sue_angry_r";
			break;
		case 4://
			vx = 0;
			y -= 3;
			ani.sprite_index = lr == 0 ? L"mc_sue_sit_l" : L"mc_sue_sit_r";
			break;
		case 5://ڴ˯
			y -= 6;
			x -= 9;
			vx = 0;
			vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_sue_sleep_l" : L"mc_sue_sleep_r";
			break;
		case 6://
			gameFunc->PlaySound(L"CS_050_mimiga_squeak");
			ani.sprite_index = lr == 0 ? L"mc_sue_hurt_l" : L"mc_sue_hurt_r";
			vy = -0x400 / ts;
			if (lr == 0)
				vx = 0x400 / ts;
			else
				vx = -0x200 / ts;
			cbRect.cbBottom = false;
			break;
		}
	}
}

void CS_SueAni::SetState(std::wstring stateName, int lr)
{
	if(stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"angry")
	{
		ani.image_index = 0;
		ani.image_counter = 0;
		SetState(3, lr);
	}
	else if (stateName == L"sit_on_chair")
		SetState(4, lr);
	else if(stateName == L"sleep_on_bed")
		SetState(5, lr);
	else if (stateName == L"hurt_down")
		SetState(6, lr);
}

std::shared_ptr<Entity> CreateCS_SueAni()
{
	return std::make_shared<CS_SueAni>();
}
