#include "CS_SoapWalkerAni.h"
#include "CS_PeSmoke.h"
CS_SoapWalkerAni::CS_SoapWalkerAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 12;
	cbRect.top = 8;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
}

void CS_SoapWalkerAni::Step()
{
	switch (stateID)
	{
	case 0://վ
		if (bWithChako)
			ani.sprite_index = L"mc_soapwalker_stand_chako";
		else
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_stand_l" : L"mc_soapwalker_stand_r";
		break;
	case 1://׹
		vy += 0x20 / ts;
		if (drop_counter > 0)
		{
			drop_counter--;
			cbRect.enableSoild = false;
		}
		else
		{
			cbRect.enableSoild = true;
		}
		if (cbRect.enableSoild)
		{
			if (cbRect.cbBottom)
			{
				for (int i = 0; i < 4; i++)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x + Random(-12, 12);
					pe->y = y + Random(-12, 12);
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				//лָվ״̬
				stateID = 0;
				gameFunc->PlaySound(L"CS_023_thud");
			}
		}
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		if (bWithChako)
			ani.sprite_index = L"mc_soapwalker_jump_chako";
		else
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_jump_l" : L"mc_soapwalker_jump_r";
		break;
	case 2://·
		if (bWithChako)
			ani.sprite_index = L"mc_soapwalker_move_chako";
		else
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_move_l" : L"mc_soapwalker_move_r";
		break;
	case 3://Ծ
	case 4:
		vy += 0x20 / ts;
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		break;
	case 5://⶯
		if (y < 0)
		{
			gameFunc->PlaySound(L"CS_026_quake");
			gameFunc->SetQuake(gameFunc->game, 30, 0);
			Destroy();
		}
		break;
	case 7://
		break;
	case 8://ζ
		if (action_timecounter / 2 % 2)
		{
			x++;
			gameFunc->PlaySound(L"CS_011_door");
		}
		else
		{
			x--;
		}
		if (action_timecounter > 0)
			action_timecounter--;
		break;
	case 10://볡
		if (action_timecounter > 0)
		{
			action_timecounter--;
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_landing_l" : L"mc_soapwalker_landing_r";
		}
		else
		{
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_jump_l" : L"mc_soapwalker_jump_r";
			vy = -0x800 / ts;
			cbRect.enableSoild = false;
			if (y < 0)
			{
				gameFunc->PlaySound(L"CS_026_quake");
				gameFunc->SetQuake(gameFunc->game, 30, 0);
				Destroy();
			}
		}
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_SoapWalkerAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_stand_l" : L"mc_soapwalker_stand_r";
			break;
		case 2://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				ani.sprite_index = lr == 0 ? L"mc_soapwalker_move_l" : L"mc_soapwalker_move_r";
			}
			break;
		case 3://Ծ
			vy = -0x300 / ts;
			break;
		case 4://Ծ
			vy = -0x700 / ts;
			break;
		case 5://⶯
			ani.sprite_index = L"mc_soapwalker_chako";
			ani.image_index = lr;
			if (lr == 7)
			{
				vy = -0x800 / ts;
				cbRect.enableSoild = false;
			}
			break;
		case 6://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_back_l" : L"mc_soapwalker_back_r";
			break;
		case 7://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_soapwalker_defeated_l" : L"mc_soapwalker_defeated_r";
			break;
		case 8://ûζ״̬
			action_timecounter = action_timecounter_max;
			break;
		case 9://ζ״̬
			action_timecounter = 0;
			gameFunc->PlaySound(L"CS_012_block_destroy");
			for (int i = 0; i < 8; ++i)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x;
				pe->y = y;
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
			SetState(0, lr);
			break;
		case 10://볡
			action_timecounter = 30;
			break;
		}
	}
	else
	{
		this->stateID = 1;
		drop_counter = stateID - 1000;
	}
}

void CS_SoapWalkerAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(2, lr);
	else if (stateName == L"jump")
		SetState(3, lr);
	else if (stateName == L"big_jump")
		SetState(4, lr);
	else if (stateName == L"look_normal")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"look_down")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.erase(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"look_bottom")
	{
		ani.hideLayerList.erase(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"look_up")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.erase(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"look_top")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.erase(3);
	}
	else if (stateName == L"catch_chako")
		SetState(5, lr);
	else if (stateName == L"with_chako")
	{
		ani.image_index = lr;
		bWithChako = true;
	}
	else if (stateName == L"without_chako")
		bWithChako = false;
	else if (stateName == L"back")
		SetState(6, lr);
	else if (stateName == L"defeated")
		SetState(7, lr);
	else if (stateName == L"shaking")
		SetState(8, lr);
	else if (stateName == L"wake")
		SetState(9, lr);
	else if (stateName == L"leave")
		SetState(10, lr);
}

std::shared_ptr<Entity> CreateCS_SoapWalkerAni()
{
	return std::make_shared<CS_SoapWalkerAni>();
}
