#include "CS_SantaGhostFireBladeTail.h"

CS_SantaGhostFireBladeTail::CS_SantaGhostFireBladeTail(std::shared_ptr<Entity> parent, int level)
{
	type = 3;
	x = parent->x;
	y = parent->y;
	vx = parent->vx;
	vy = parent->vy;
	drawBeforeOtherEntity = true;
	ani.sprite_index = L"am_ghostfire_tail";
	SetLevel(level);
}

void CS_SantaGhostFireBladeTail::Step()
{
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
	}
	//ͣϸ
	vx /= 1.05f;
	vy /= 1.05f;
	if (abs(vx) < 0.001f)
		vx = 0;
	if (abs(vy) < 0.001f)
		vy = 0;
	//if (level <= 1)
	//	vy -= 0x5 / ts;
	//if (vy <= -1)
	//	vy = -1;
	//ʧ
	if (levelDownTime_counter > 0)
	{
		levelDownTime_counter--;
		if (levelDownTime_counter == 0)
		{
			if (level > 0)
			{
				//˻
				level--;
				SetLevel(level);
				levelDownTime_counter = levelDownTime_counter_max;


			}
			else
			{
				Destroy();
			}
		}
	}
	//ִ˶
	Entity::Step();
}

void CS_SantaGhostFireBladeTail::SetLevel(int level)
{
	this->level = level;
	switch (level)
	{
	case 3:
		ani.image_index = 0;
		break;
	case 2:
		ani.image_index = 1;
		break;
	case 1:
		ani.image_index = 2;
		break;
	case 0:
		ani.image_index = 3;
		break;
	}
}
