#include "CS_SantaAni.h"

CS_SantaAni::CS_SantaAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_SantaAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_SantaAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ㶯
	AnimateStep();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 3://
		vx = 0;
		vy = 0;
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 4://
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_SantaAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_santa_stand_l" : L"mc_santa_stand_r";
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				ani.sprite_index = lr == 0 ? L"mc_santa_move_l" : L"mc_santa_move_r";
			}
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_santa_back_l" : L"mc_santa_back_r";
			break;
		case 3://
			vx = 0;
			y -= 3;
			ani.sprite_index = lr == 0 ? L"mc_santa_sit_l" : L"mc_santa_sit_r";
			break;
		case 4://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_santa_lie_l" : L"mc_santa_lie_r";
			break;
		case 5://
			ani.sprite_index = lr == 0 ? L"mc_santa_back_l" : L"mc_santa_back_r";
			break;
		}
	}
	AnimateStep();
}

void CS_SantaAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"sit_on_chair")
		SetState(3, lr);
	else if (stateName == L"lie")
		SetState(4, lr);
	else if (stateName == L"back")
		SetState(5, lr);
	AnimateStep();
}

void CS_SantaAni::AnimateStep()
{
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	if (showGun)
	{
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(3);
		ani.hideLayerList.erase(4);
	}
	else
	{
		ani.hideLayerList.erase(2);
	}
}

std::shared_ptr<Entity> CreateCS_SantaAni()
{
	return std::make_shared<CS_SantaAni>();
}
