#include "CS_SantaAi.h"
#include "CS_Santa.h"
#include "CS_Boss_ControlCore.h"
#include "CS_Boss_Puu.h"
CS_SantaAi::CS_SantaAi()
{
	el.name = CS_SANTAAI_CREATENAME;
}

void CS_SantaAi::Init(std::weak_ptr<Entity> self)
{
	auto watkZone = std::make_shared<CS_Ai_AtkZone>();
	atkZone = watkZone;
	//ýӴοΧ
	watkZone->cbRect.left = 5 * 16;
	watkZone->cbRect.right = 5 * 16;
	watkZone->cbRect.top = 10 * 16;
	watkZone->cbRect.bottom = 5 * 16;
	gameFunc->SetEntity(shared_from_this(), watkZone);
	CS_MyCharAi::Init(self);
}

void CS_SantaAi::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	if (atk_interval_counter > 0)
		atk_interval_counter--;

	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	if (!mychar)
	{
		InitControlTarget();
		return;
	}
	if (gameFunc->InBossFight)
	{
		if (stateID == 0)
		{
			if (gameFunc->InBossFight(gameFunc->game))
			{
				//ͼ
				if (gameFunc->ScriptIsRunning(gameFunc->gameScript))
					ani.sprite_index.clear();
				else
					ani.sprite_index = L"ai";
				//ѰҵͼϵBoss
				for (auto& e : entityLayer->Ls)
				{
					if (e->el.name == CS_BOSS_CONTROLCORE_CREATENAME)
					{
						controlCore = std::static_pointer_cast<CS_Boss_ControlCore>(e);
						SetState(L"fightboss_controlcore", 0);
						break;
					}
				}
				//ѰPuu&Tala
				if (stateID == 0)
				{
					for (auto& e : entityLayer->Am)
					{
						if (e->el.name == CS_BOSS_PUU_CREATENAME)
						{
							SetState(L"fightboss_puu&tala", 0);
							break;
						}
					}
				}
			}
		}
		else
		{
			if (!gameFunc->InBossFight(gameFunc->game))
			{
				//ͼ
				if (gameFunc->ScriptIsRunning(gameFunc->gameScript))
					ani.sprite_index.clear();
				else
					ani.sprite_index = L"ai";
				//˳bossսģʽ
				SetState(L"normal", 0);
			}
		}
	}
	switch (stateID)
	{
	case 0://ͨģʽ
		//ͣرվʰȡ
		bAutoPickUp = mychar->stateWater.o2 >= 50;
		CS_MyCharAi::Step();
		break;
	case 1://boss䳲&ħ
		FightControlCore();
		break;
	case 2://boss&
		FightPuuTala();
		break;
	}
	auto watkZone = atkZone.lock();
	if (watkZone)
	{
		//󶨹
		watkZone->x = mychar->x;
		watkZone->y = mychar->y;
		watkZone->last_x = mychar->last_x;
		watkZone->last_y = mychar->last_y;
		if (mychar->skillGhostFire.lock)
			watkZone->cbRect.top = 5 * 16;
		else
			watkZone->cbRect.top = 10 * 16;
		//Ŀͷ
		x = wattackParent->x;
		y = wattackParent->y - 16;
		last_x = wattackParent->last_x;
		last_y = wattackParent->last_y - 16;
	}
}

void CS_SantaAi::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
	{
		stateID = 0;
	}
	else if (stateName == L"fightboss_controlcore")
	{
		stateID = 1;
	}
	else if (stateName == L"fightboss_puu&tala")
	{
		stateID = 2;
	}
}

void CS_SantaAi::Destroy()
{
	auto watkZone = atkZone.lock();
	if (watkZone)
	{
		watkZone->Destroy();
		atkZone.reset();
	}
	CS_MyCharAi::Destroy();
}

bool CS_SantaAi::AttackAround()
{
	if (!FilterEnemy())
		return false;
	return StaticAttack(enemyList.front());
}

void CS_SantaAi::FaceAtWind()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	if (!mychar->cbRect.inWind)
		return;
	switch (mychar->cbRect.windDir)
	{
	case 7:
	case 4:
	case 1:
		if (mychar->lr != 0)
			mychar->input.SetLeft(true);
		break;
	case 9:
	case 6:
	case 3:
		if (mychar->lr == 0)
			mychar->input.SetRight(true);
		break;
	case 8:
		mychar->input.SetUp(true);
		break;
	case 2:
		mychar->input.SetDown(true);
		break;
	}
}

void CS_SantaAi::FightControlCore()
{
	auto wcontrolCore = controlCore.lock();
	if (!wcontrolCore)
		return;
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);

	auto& x = mychar->x;
	auto& y = mychar->y;
	mychar->input.key = 0;
	bool haveEnemy = FilterEnemy();
	if (wcontrolCore->demonflower_open)
	{
		//ɣߵħԾ
		auto we = wcontrolCore->demonflower.lock();
		if (we)
		{
			float posX = we->x + (we->cbRect.left + we->cbRect.right) / 2;
			if (x > posX + 16)
				mychar->input.SetLeft(true);
			else if (x < posX - 16)
				mychar->input.SetRight(true);
			if (abs(mychar->x - posX) <= 32)
			{
				mychar->stateJump.jumped = false;
				mychar->stateJump.jump_disable = false;
				mychar->input.SetJump(true);
			}
		}
		if (haveEnemy && enemyList.front().lock() == wcontrolCore->demonflower.lock())
		{
			if (abs(mychar->y - we->y) <= 16 && abs(mychar->x - we->x) <= 32)
			{
				if (atk_interval_counter == 0)
				{
					atk_interval_counter = atk_interval_counter_max;
					mychar->input.SetUp(true);
					mychar->input.SetAtk(true);
				}
			}
		}
	}
	else if (!haveEnemy || (haveEnemy && enemyList.front().lock() == wcontrolCore->demonflower.lock()))
	{
		//ӽ
		//ҷ
		auto wplayer = GetPlayer().lock();
		if (wplayer)
		{
			float posX = wplayer->x;
			if (x > posX + 16)
				mychar->input.SetLeft(true);
			else if (x < posX - 16)
				mychar->input.SetRight(true);
		}
	}
	MovingAttack(GetClosestEnemy());
}

void CS_SantaAi::FightPuuTala()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	//ʹӰģʽ
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	auto followTarget = mychar->attackParent.lock();
	if (followTarget)
	{
		//󹻽򽫸ģб
		if (abs(mychar->x - followTarget->x) <= 96)
		{
			shadowOpList.push_back(followTarget->input);
			if (shadowOpList.size() >= 20)
			{
				//ȡһΪĲ
				mychar->input = shadowOpList.front();
				shadowOpList.pop_front();
			}
		}
		else
		{
			CS_MyCharAi::Step();
		}
	}
	else
	{
		mychar->attackParent = gameFunc->GetMyChar_Player1(gameFunc->entityRes);
	}
}

bool CS_SantaAi::StaticAttack(std::weak_ptr<Entity> e)
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return false;
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	auto we = e.lock();
	if (!we)
		return false;

	//ԼͷϷԶϹ
	if (we->y < mychar->y - 20 && abs(mychar->x - we->x) <= 8)
	{
		mychar->input.SetUp(true);
		//ת
		if (we->x > mychar->x && mychar->lr == 0)
			mychar->input.SetRight(true);
		else if (we->x < mychar->x && mychar->lr == 1)
			mychar->input.SetLeft(true);
		SkillAttack(mychar);
		//ͣ¶
		if (atk_interval_counter == 0)
		{
			atk_interval_counter = atk_interval_counter_max;
			mychar->input.SetAtk(true);
		}
		return true;
	}
	if (we->y >= mychar->y)
	{
		//ת
		if (we->x > mychar->x && mychar->lr == 0)
			mychar->input.SetRight(true);
		else if (we->x < mychar->x && mychar->lr == 1)
			mychar->input.SetLeft(true);
		SkillAttack(mychar);
		//ͣ¶
		if (atk_interval_counter == 0)
		{
			atk_interval_counter = atk_interval_counter_max;
			mychar->input.SetAtk(true);
		}
		return true;
	}
	//ֱӹ
	if (atk_interval_counter == 0)
	{
		atk_interval_counter = atk_interval_counter_max;
		mychar->input.SetAtk(true);
	}
	return false;
}

bool CS_SantaAi::MovingAttack(std::weak_ptr<Entity> e)
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return false;
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	auto we = e.lock();
	if (!we)
		return false;

	auto& x = mychar->x;
	auto& y = mychar->y;
	//·
	if (we->y > mychar->y - 4 && abs(mychar->x - we->x) <= 16)
	{
		//·򹥻
		if (atk_interval_counter == 0)
		{
			//
			atk_interval_counter = atk_interval_counter_max;
			mychar->input.SetDown(true);
			mychar->input.SetAtk(true);
		}
		SkillAttack(mychar);
	}
	else if (we->x > x)
	{
		SkillAttack(mychar);
		//ҷ򹥻
		if (atk_interval_counter == 0)
		{
			//
			atk_interval_counter = atk_interval_counter_max;
			//ĬϹ
			if (abs(mychar->x - we->x) < 64)
				mychar->input.SetUp(true);
			else
				mychar->input.SetRight(true);
			mychar->input.SetAtk(true);
		}
		else
		{
			bool bFlee = false;
			//
			if (abs(mychar->x - we->x) <= 4 && abs(mychar->x - we->x) <= 4)
			{
				//ҷ
				auto wplayer = GetPlayer().lock();
				if (wplayer)
				{
					if (x > wplayer->x)
						mychar->input.SetLeft(true);
					else
						mychar->input.SetRight(true);
					bFlee = true;
				}

			}
			if(!bFlee)
			{
				//ƶ
				mychar->input.SetLeft(true);
			}
		}
	}
	else
	{
		SkillAttack(mychar);
		//򹥻
		if (atk_interval_counter == 0)
		{
			//
			atk_interval_counter = atk_interval_counter_max;
			//ĬϹ
			if (abs(mychar->x - we->x) < 64)
				mychar->input.SetUp(true);
			else
				mychar->input.SetLeft(true);
			mychar->input.SetAtk(true);
		}
		else
		{
			bool bFlee = false;
			//
			if (abs(mychar->x - we->x) <= 4 && abs(mychar->x - we->x) <= 4)
			{
				//ҷ
				auto wplayer = GetPlayer().lock();
				if (wplayer)
				{
					if (x > wplayer->x)
						mychar->input.SetLeft(true);
					else
						mychar->input.SetRight(true);
					bFlee = true;
				}

			}
			if (!bFlee)
			{
				//ƶ
				mychar->input.SetRight(true);
			}
		}
	}
	return false;
}

bool CS_SantaAi::FilterEnemy()
{
	auto watkZone = atkZone.lock();
	if (!watkZone)
		return false;

	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return false;
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	//鿴ǷԼΧ
	enemyList.clear();
	for (auto& e : watkZone->touchList)
	{
		auto we = e.lock();
		if (we)
		{
			//
			if (we->type != 2)
				continue;
			//
			if (we->isTrap)
				continue;
			if (we->hp == 0)
				continue;
			//ҷ
			auto we_attackParent = we->attackParent.lock();
			if (we_attackParent && we_attackParent->type == 1)
				continue;
			auto cell = gameFunc->GetPath(mychar, we->x / 16, we->y / 16, mychar->x / 16, mychar->y / 16);
			//ֱ߲
			if (gameFunc->LineTest(mychar, mychar->x / 16, mychar->y / 16, we->x / 16, we->y / 16))
				continue;
			//Ѱ·Զ
			if (cell->dis > 10)
				continue;
			enemyList.push_back(we);
		}
	}
	return !enemyList.empty();
}

std::weak_ptr<Entity> CS_SantaAi::GetClosestEnemy(float* outDis)
{
	//ɸвǸ
	//30غԼ
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return std::weak_ptr<Entity>();
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	auto& x = mychar->x;
	auto& y = mychar->y;
	int turn = 30;
	float minDis = 9999;
	std::weak_ptr<Entity> minEntity;
	
	for (auto& e : enemyList)
	{
		auto we = e.lock();
		if (we)
		{
			if (abs(we->x - mychar->x) <= 8 && abs(we->y - mychar->y) <= 8)
			{
				if (outDis)
					*outDis = 7;
				return we;
			}
			if (abs(we->vx) < 0.001f && abs(we->vy) < 0.001f)
				continue;
			//ٶ
			XMVECTOR vec_1Size = XMVector2Normalize(XMVectorSet(we->vx, we->vy, 0, 0));
			float vecX = XMVectorGetX(vec_1Size);
			float vecY = XMVectorGetY(vec_1Size);
			auto& x0 = we->x;
			auto& y0 = we->y;
			auto& x1 = x;
			auto& y1 = y;
			//
			float dis = abs((x1 - x0) * vecY - (y1 - y0) * vecX);
			//ᾭԼֱ
			if (dis >= 32)
				continue;
			//㴹
			float v = (x1 - x0) * vecX + (y1 - y0) * vecY;
			float xp = x0 + vecX * v;
			float yp = y0 + vecY * v;
			//㵽껨ѵĻغ
			XMVECTOR vec = XMVectorSet(we->vx, we->vy, 0, 0);
			float vec_model = XMVectorGetX(XMVector2Length(vec));
			float vecP_model = XMVectorGetX(XMVector2Length(XMVectorSet(xp - x0, yp - y0, 0, 0)));
			float comp_dis;
			if (vec_model * turn >= vecP_model)
			{
				//Ѿ˴㣬dis
				comp_dis = dis;
			}
			else
			{
				//û㣬30غϺ
				//30غϺ
				auto turnedVec = vec * (float)turn + XMVectorSet(we->x, we->y, 0, 0);
				//Ǹľ
				comp_dis = XMVectorGetX(XMVector2Length(turnedVec - XMVectorSet(x, y, 0, 0)));
			}
			//ĸ30غȽӽԼ
			if (comp_dis < minDis)
			{
				minDis = comp_dis;
				minEntity = e;
			}
		}
	}
	if (outDis)
		*outDis = minDis;
	return minEntity;
}

std::weak_ptr<Entity> CS_SantaAi::GetPlayer()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return std::weak_ptr<Entity>();
	auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
	auto wplayer = gameFunc->GetMyChar_Player1(gameFunc->entityRes).lock();
	if (wplayer != mychar)
		return wplayer;
	wplayer = gameFunc->GetMyChar_Player2(gameFunc->entityRes).lock();
	if (wplayer != mychar)
		return wplayer;
	return std::weak_ptr<Entity>();
}

void CS_SantaAi::SkillAttack(std::shared_ptr<CS_Santa>& mychar)
{
	mychar->input.key |= mychar->skillGhostFire.keyMask;
}

std::shared_ptr<Entity> CreateCS_SantaAi()
{
	return std::make_shared<CS_SantaAi>();
}
