#include "CS_RainbowBubble.h"

CS_RainbowBubble::CS_RainbowBubble()
{
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 12;
	cbRect.enableCbRect = true;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_rainbow_bubble";
	el.name = L"resetlevel_delete";
}

void CS_RainbowBubble::Step()
{
	auto wtarget = target.lock();
	if (wtarget)
	{
		wtarget->attackState = false;
		wtarget->attackState_reset_counter_max = -1;
		wtarget->damage_reset_counter = -1;
		wtarget->drawBeforeOtherEntity = true;
		if (wtarget->inUsing == false)
		{
			target.reset();
			SetSpray();
			Destroy();
			return;
		}
		MoveControl(wtarget);
		wtarget->vx = 0;
		wtarget->vy = 0;
		wtarget->ClearCollisionResult();
		wtarget->x = x;
		wtarget->last_x = last_x;
		wtarget->y = y;
		wtarget->last_y = last_y;
		//Ŀ곢Ծ
		if (!wtarget->input.GetJump())
			bJump = true;
		if (wtarget->input.GetJump() && bJump)
		{
			wtarget->cbRect.cbBottom = true;
			SetSpray();
			Destroy();
			wtarget->gameFunc->PlaySound(L"CS_021_bubble");
		}
	}
	else if(ignoreBreak == 0)
	{
		GridTouch();
		if (!touchList.empty())
		{
			//
			for (auto& e : touchList)
			{
				auto we = e.lock();
				if (we)
				{
					if (we->ignoreCaught)
						continue;
					if (we->ignoreCaught_counter > 0)
						continue;
					if (we->type == 2 ||
						we->hp > 0)
					{
						Catch(we);
						break;
					}
				}
			}
		}
	}
	if (abs(vx) < 0.0001f)
		vx = 0;
	else
		vx /= 1.05f;
	//ϸ
	if (cbRect.inWater)
	{
		if (vy > -0x300 / ts)
		{
			if (vy - 0x20 / ts > -0x300 / ts)
				vy -= 0x20 / ts;
			else
				vy = -0x300 / ts;
		}
	}
	else
	{
		if (vy > -0x100 / ts)
		{
			if (vy - 0x8 / ts > -0x100 / ts)
				vy -= 0x8 / ts;
			else
				vy = -0x100 / ts;
		}
	}
	if (ignoreBreak > 0)
	{
		ignoreBreak--;
		if(ignoreBreak == 0)
			cbRect.enableSoild = true;
	}
	//ǽʧ
	else if (cbRect.cbTop || cbRect.cbBottom || cbRect.cbLeft || cbRect.cbRight)
	{
		SetSpray();
		Destroy();
	}
	//糡
	Entity::Wind();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
}

void CS_RainbowBubble::Destroy()
{
	auto wtarget = target.lock();
	if (wtarget)
	{
		//ָ״̬
		wtarget->attackState = target_attackState;
		wtarget->damage_reset_counter = target_damage_reset_counter;
		wtarget->attackState_reset_counter_max = target_attackState_reset_counter_max;
		wtarget->drawBeforeOtherEntity = target_drawBeforeOtherEntity;
		wtarget->ignoreCaught_counter = 0;
		wtarget->EndCaught(shared_from_this());
	}
	Entity::Destroy();
}

void CS_RainbowBubble::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

bool CS_RainbowBubble::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	auto wtarget = target.lock();
	if (wtarget)
	{
		*outRealDamage = getDamage;
		SetSpray();
		Destroy();
		return true;
	}
	else
	{
		return false;
	}
}

void CS_RainbowBubble::Catch(std::weak_ptr<Entity> target)
{
	this->target = target;
	auto wtarget = target.lock();
	if (wtarget)
	{
		wtarget->x = x;
		wtarget->y = y;
		vx += wtarget->vx;
		vy += wtarget->vy;
		//沢رղ׽Ĺ״̬
		target_attackState = wtarget->attackState;
		target_damage_reset_counter = wtarget->damage_reset_counter;
		target_attackState_reset_counter_max = wtarget->attackState_reset_counter_max;
		target_drawBeforeOtherEntity = wtarget->drawBeforeOtherEntity;
		wtarget->attackState = false;
		wtarget->attackState_reset_counter_max = -1;
		wtarget->damage_reset_counter = -1;
		wtarget->drawBeforeOtherEntity = true;
		wtarget->ignoreCaught_counter = INT_MAX;
		gameFunc->PlaySound(L"CS_021_bubble");
	}
	//ò׽ͱը
	//ִײ
	Collision();
	//һײ
	Entity::ClearCollisionResult();
}

void CS_RainbowBubble::SetSpray()
{
	int num = Random(2, 6);
	for (int i = 0; i < num; i++)
	{
		auto pe = gameFunc->GameCreateEntity(L"pe_spray");
		pe->x = x + Random(-8, 8);
		pe->y = y - 8 + Random(-8, 8);
		gameFunc->SetEntity(shared_from_this(), pe);
	}
}

void CS_RainbowBubble::MoveControl(std::shared_ptr<Entity>& we)
{
	//ƶ
	float move = cbRect.inWater ? 0x2A / ts : 0x55 / ts;
	float move2 = cbRect.inWater ? 0x10 / ts : 0x20 / ts;
	float max_move = cbRect.inWater ? 0x196 / ts : 0x32c / ts;
	//
	if (we->input.GetLeft() || we->axis[2] < 0)
	{
		//Ƿֱ
		float joyMax_move;
		if (we->axis[2] < 0)
		{
			joyMax_move = max_move * -we->axis[2];
			//ı䶯ٶ
			we->ani.image_counter_speed = -we->axis[2];
		}
		else
		{
			joyMax_move = max_move;
			we->ani.image_counter_speed = 1;
		}
		if (vx > -joyMax_move)
		{
			if (vx - move2 > -joyMax_move)
				vx -= move2;
			else
				vx = -joyMax_move;
		}
	}
	//
	else if (we->input.GetRight() || we->axis[3] > 0)
	{
		//Ƿֱ
		float joyMax_move;
		if (we->axis[3] > 0)
		{
			joyMax_move = max_move * we->axis[3];
			//ı䶯ٶ
			we->ani.image_counter_speed = we->axis[3];
		}
		else
		{
			joyMax_move = max_move;
			we->ani.image_counter_speed = 1;
		}
		if (vx < joyMax_move)
		{
			if (vx + move2 < joyMax_move)
				vx += move2;
			else
				vx = joyMax_move;
		}
	}
	//
	if (we->input.GetUp() || we->axis[0] < 0)
	{
		//Ƿֱ
		float joyMax_move;
		if (we->axis[0] < 0)
		{
			joyMax_move = max_move * -we->axis[0];
			//ı䶯ٶ
			we->ani.image_counter_speed = -we->axis[0];
		}
		else
		{
			joyMax_move = max_move;
			we->ani.image_counter_speed = 1;
		}
		if (vy > -joyMax_move)
		{
			if (vy - move2 > -joyMax_move)
				vy -= move2;
			else
				vy = -joyMax_move;
		}
	}
}

std::shared_ptr<Entity> CreateCS_RainbowBubble()
{
	return std::make_shared<CS_RainbowBubble>();
}
