#include "CS_QuoteSpurBlade.h"
#include "CS_Quote.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
CS_QuoteSpurBlade::CS_QuoteSpurBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	auto move = 0x1000 / ts;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y - 8;
		vx = 0;
		vy = -move;
		SetCS_PeGunShotSpark(parent, x, y);
	}
	else if (ud == 0)
	{
		y = parent->y + 3;
		if (lr == 0)
		{
			x = parent->x - 6;
			SetCS_PeGunShotSpark(parent, parent->x - 0x1800 / ts, y);
		}
		else
		{
			x = parent->x + 6;
			SetCS_PeGunShotSpark(parent, parent->x + 0x1800 / ts, y);
		}
		vx = lr == 0 ? -move : move;
		vy = 0;
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 8;
		vx = 0;
		vy = move;
		SetCS_PeGunShotSpark(parent, x, y);
	}
	//Ч
	parent->gameFunc->PlaySound(L"CS_049_polar_star_l3");
	//ö
	ani.sprite_index = ud == 0 ? L"am_polarstar3_lr" : L"am_polarstar3_ud";
	//ʱ
	action_timecounter_max = 16;
	action_timecounter = action_timecounter_max;
	//ǽײ
	SetCbRect_Collision();
}

void CS_QuoteSpurBlade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ǽײ
	SetCbRect_Collision();
	//ִ˶
	Entity::Step();//
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_028_shot_hit");
		SetCS_PeGunShotHit(shared_from_this(), x, y);
		Destroy();
	}
}

void CS_QuoteSpurBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_QuoteSpurBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_QuoteSpurBlade::Feedback(std::weak_ptr<Entity> target)
{
	Destroy();
}

void CS_QuoteSpurBlade::Destroy()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto mychar = std::static_pointer_cast<CS_Quote>(wattackParent);
		auto& amList = mychar->skillSpur.amList;
		for (auto iter = amList.begin(); iter != amList.end(); iter++)
		{
			if ((*iter).lock() == shared_from_this())
			{
				amList.erase(iter);
				break;
			}
		}
	}
	ActionEntity::Destroy();
}

void CS_QuoteSpurBlade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_QuoteSpurBlade::SetCbRect_Entity()
{
	cbRect.left = 6;
	cbRect.right = 6;
	cbRect.top = 6;
	cbRect.bottom = 6;
	cbRect.breakStarBlock = false;
}

void CS_QuoteSpurBlade::SetCbRect_Collision()
{
	cbRect.left = 2;
	cbRect.right = 2;
	cbRect.top = 2;
	cbRect.bottom = 2;
	cbRect.breakStarBlock = true;
}
