#include "CS_Quote.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Heart.h"

CS_Quote::CS_Quote()
{
	type = 1;
	//ʼ
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.lavaDmg = 10;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	//ʼֵ
	uiName = L"quote";
	saveName = CS_QUOTE_CREATENAME;
	throwItem = 0;
	throwItem_max = 0;
	hp_max = hp = 55;
	mp_max = mp = 200;

	lastGun = &skillSpur;
	GunAnimate();
	//ai
	//aiName = L"CS_jack_ai";
}

void CS_Quote::Init(std::weak_ptr<Entity> self)
{
	//״̬Ҳִ˳
	AddState(&stateFlash);
	AddState(&stateInvincible);
	AddState(&stateGravity);
	AddState(&stateWater);
	AddState(&stateDrown);
	AddState(&stateControl);
	AddState(&stateResist);//stateControl
	AddState(&stateJump);
	AddState(&stateStand);
	AddState(&stateMove);
	AddState(&stateAir);
	AddState(&stateFaceToBack);
	AddState(&stateHurt);
	AddState(&stateBooster);
	//Ӽ
	AddSkill(&skillFire);
	AddSkill(&skillSpur);
	AddSkill(&skillSuperMissile);
	AddSkill(&skillLock);
	//óʼ״̬
	ChangeState(stateStand.GetStateID());
	//óʼ״̬
	SetPhysice(false);
	//óʼܰ
	SetSkillBindIndex(&skillFire, 0);
	skillFire.lock = false;
	SetSkillBindIndex(&skillSpur, 1);
	skillSpur.lock = false;
	SetSkillBindIndex(&skillSuperMissile, 2);
	skillSuperMissile.lock = false;
	SetSkillBindIndex(&skillLock, 3);
	skillLock.lock = false;
	MyCharEntity::Init(self);
}

void CS_Quote::Step()
{
	//ֹͼ
	Entity::KeepInMap();
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ㶯
	GunAnimate();
	//ⱻƶƽ̨ѹ
	CheckCrush();
	//״̬
	if (stateID == 0 && type == 1)
	{
		//ҿ
		for (auto& p : stateList)
			p->Step();
		if (atkFeedBack > 0)
			atkFeedBack--;
		else if (action_timecounter > 0)
			action_timecounter--;
	}
	else if (type == 0 || stateID != 0)
	{
		//
		switch (stateID)
		{
		case 0://վ
			stateStand.State();
			vx = 0;
			//
			stateGravity.State();
			break;
		case 1://·
			stateMove.State();
			stateGravity.State();
			break;
		case 2://
			break;
		}
	}
	//UI
	MyCharEntity::UpdateUI();
	//糡
	Entity::Wind();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Quote::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->stateID = stateID;
		this->lr = lr;
		switch (stateID)
		{
		case 0://ûжָҿƣ
			faceToBack = false;
			vx = 0;
			break;
		case 1://·
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			stateMove.State();
			//
			stateGravity.State();
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_quote_back_l" : L"mc_quote_back_r";
			break;
		}
	}
	else
	{
		switch (stateID)
		{
		case 200:
			cbRect.left = cbRect.right = 5;
			cbRect.top = 4;
			cbRect.bottom = 4;
			cbRect.fullWaterBlock = true;
			fishState = true;
			fishState_counter = lr;
			break;
		case 201:
			cbRect.left = cbRect.right = 5;
			cbRect.top = 6;
			cbRect.bottom = 8;
			cbRect.fullWaterBlock = false;
			fishState = false;
			fishState_counter = 0;
			break;
		}
	}
}

void CS_Quote::SetState(std::wstring stateName, int lr)
{
	MyCharEntity::SetState(stateName, lr);
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"fish_state")
		SetState(200, lr);
	else if (stateName == L"change_back")
		SetState(201, lr);
}

void CS_Quote::LoadSaveData()
{
	MyCharEntity::LoadSaveData();
}

void CS_Quote::WriteSaveData()
{
	MyCharEntity::WriteSaveData();
}

bool CS_Quote::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	//¼ʱ޵״̬
	if (gameFunc->ScriptIsRunning)
	{
		if (gameFunc->ScriptIsRunning(gameFunc->gameScript))
			return false;
	}
	//״̬
	for (auto& p : stateList)
	{
		bool retVal = true;
		if (p->Hurt(src, &getDamage, &angle, &bTakedown, &elemType, &shockForce, &heavy, outRealDamage, &retVal))
			return retVal;
	}
	//ܴ
	for (auto& p : skillList)
	{
		bool retVal = true;
		if (p->Hurt(src, &getDamage, &angle, &bTakedown, &elemType, &shockForce, &heavy, outRealDamage, &retVal))
			return retVal;
	}
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	stateInvincible.SetDamage(getDamage);
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_016_quote_hurt");
	}
	if (hp <= 0)
	{
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		UpdateUI();
		//Ϸ
		hide = true;
		//
		if (gameFunc->StartEvent)
		{
			gameFunc->PlaySound(L"CS_017_quote_die");
			gameFunc->StopMusic();
			gameFunc->StartEvent(gameFunc->gameScript, L"Died", L"tDeath");
		}
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//
	stateFlash.flash_counter = 5;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 1, shared_from_this());
	//ת״̬
	ChangeState(stateHurt.GetStateID());
	return true;
}

void CS_Quote::Gain(std::weak_ptr<Entity> item)
{
	//ʰȡ˾
	auto witem = item.lock();
	if (!witem)
		return;
	if (witem->el.name == CS_EXP_CREATENAME && witem->inUsing)
	{
		//Mp˸
		if (gameFunc->GetPlayerIndex)
		{
			int playerIndex = gameFunc->GetPlayerIndex(gameFunc->game, shared_from_this());
			if (playerIndex >= 0)
			{
				auto& ui = *gameFunc->GetPlayerUIData(gameFunc->gameUI, playerIndex);
				ui.MpBar_flash_counter = 30;
			}
		}
		mp += witem->dropExp;
		if (mp > mp_max)
			mp = mp_max;
		gameFunc->PlaySound(L"CS_014_get_xp");
		//ʾֵ
		if (gameFunc->dmgNum)
			gameFunc->SetDmgNum(gameFunc->dmgNum, witem->dropExp, x, y - 16, 3, shared_from_this());
		witem->Destroy();
	}
	//ʰȡ
	else if (witem->el.name == CS_HEART_CREATENAME && witem->inUsing)
	{
		//ָ
		hp += witem->hp;
		if (hp > hp_max)
			hp = hp_max;
		gameFunc->PlaySound(L"CS_020_health_refill");
		witem->Destroy();
	}
}

void CS_Quote::Destroy()
{
	MyCharEntity::Destroy();
}

void CS_Quote::GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList)
{
	png = L"CS_CaveStoryMod";
	sprite_index = L"mc_quote_stand_r";
	image_index = 0;
	hideLayerList = ani.hideLayerList;
}

void CS_Quote::CrushDeath()
{
	//
	SetCS_PeSmokeMedium(shared_from_this(), x, y);
	hp = 0;
	UpdateUI();
	//Ϸ
	hide = true;
	//Ϸ
	if (gameFunc->StartEvent)
	{
		gameFunc->PlaySound(L"CS_017_quote_die");
		gameFunc->StopMusic();
		if (crushEvent.length())
			gameFunc->StartEvent(gameFunc->gameScript, crushEvent.c_str(), L"tCrush");
		else
			gameFunc->StartEvent(gameFunc->gameScript, L"DeathByMovingPlatform", L"tCrush");
	}
}

void CS_Quote::GunAnimate()
{
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	ani.hideLayerList.insert(5);
	ani.hideLayerList.insert(6);
	ani.hideLayerList.insert(7);
	ani.hideLayerList.insert(8);
	ani.hideLayerList.insert(9);
	ani.hideLayerList.insert(10);
	//ʾ
	if (lastGun == &skillSpur)
		ani.hideLayerList.erase(10);
	else if(lastGun == &skillSuperMissile)
		ani.hideLayerList.erase(8);
}

std::shared_ptr<Entity> CreateCS_Quote()
{
	return std::make_shared<CS_Quote>();
}
