#include "CS_PuuAni.h"
#include "CS_PeSmoke.h"
CS_PuuAni::CS_PuuAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 12;
	cbRect.top = 8;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
}

void CS_PuuAni::Step()
{
	switch (stateID)
	{
	case 0://վ
		ani.sprite_index = lr == 0 ? L"mc_puu_stand_l" : L"mc_puu_stand_r";
		break;
	case 1://׹
		vy += 0x20 / ts;
		if (drop_counter > 0)
		{
			drop_counter--;
			cbRect.enableSoild = false;
		}
		else
		{
			cbRect.enableSoild = true;
		}
		if (cbRect.enableSoild)
		{
			if (cbRect.cbBottom)
			{
				for (int i = 0; i < 4; i++)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x + Random(-12, 12);
					pe->y = y + Random(-12, 12);
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				//лָվ״̬
				stateID = 2;
				action_timecounter = 16;
				gameFunc->PlaySound(L"CS_026_quake");
				if (gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 30, 0);
			}
		}
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		ani.sprite_index = lr == 0 ? L"mc_puu_jump_l" : L"mc_puu_jump_r";
		break;
	case 2://ָվ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 0;
		ani.sprite_index = lr == 0 ? L"mc_puu_landing_l" : L"mc_puu_landing_r";
		break;
	case 3://
		ani.sprite_index = lr == 0 ? L"mc_puu_openmouth_l" : L"mc_puu_openmouth_r";
		break;
	case 4://·
		break;
	case 5://볡
		if (action_timecounter > 0)
		{
			action_timecounter--;
			ani.sprite_index = lr == 0 ? L"mc_puu_landing_l" : L"mc_puu_landing_r";
		}
		else
		{
			ani.sprite_index = lr == 0 ? L"mc_puu_jump_l" : L"mc_puu_jump_r";
			vy = -0x800 / ts;
			cbRect.enableSoild = false;
			if (y < 0)
			{
				gameFunc->PlaySound(L"CS_026_quake");
				gameFunc->SetQuake(gameFunc->game, 30, 0);
				Destroy();
			}
		}
		break;
	case 8://
		break;
	case 11://
		break;
	case 12:
		if (action_timecounter / 2 % 2)
		{
			x++;
			gameFunc->PlaySound(L"CS_011_door");
		}
		else
		{
			x--;
		}
		if (action_timecounter > 0)
			action_timecounter--;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_PuuAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
		switch (stateID)
		{
		case 0:
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_puu_stand_l" : L"mc_puu_stand_r";
			break;
		case 4://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				ani.sprite_index = lr == 0 ? L"mc_puu_move_l" : L"mc_puu_move_r";
			}
			break;
		case 5://볡
			action_timecounter = 30;
			break;
		case 6://ʾ͹
			ani.hideLayerList.erase(1);
			break;
		case 7://͹
			ani.hideLayerList.insert(1);
			break;
		case 8://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_puu_back_l" : L"mc_puu_back_r";
			break;
		case 9://ʾˢ
			ani.hideLayerList.erase(2);
			break;
		case 10://ˢ
			ani.hideLayerList.insert(2);
			break;
		case 11://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_puu_defeated_l" : L"mc_puu_defeated_r";
			break;
		case 12://ûζ״̬
			action_timecounter = action_timecounter_max;
			break;
		case 13://ζ״̬
			action_timecounter = 0;
			gameFunc->PlaySound(L"CS_012_block_destroy");
			for (int i = 0; i < 8; ++i)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x;
				pe->y = y;
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
			SetState(0, lr);
			break;
		}
	}
	else
	{
		this->stateID = 1;
		drop_counter = stateID - 1000;
	}
}

void CS_PuuAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"dark")
		color = RGBA(0, 0, 0, 0xff);
	else if (stateName == L"open_mouth")
		SetState(3, lr);
	else if (stateName == L"walk")
		SetState(4, lr);
	else if (stateName == L"leave")
		SetState(5, lr);
	else if (stateName == L"show_tank")
		SetState(6, lr);
	else if (stateName == L"hide_tank")
		SetState(7, lr);
	else if (stateName == L"back")
		SetState(8, lr);
	else if (stateName == L"show_brush")
		SetState(9, lr);
	else if (stateName == L"hide_brush")
		SetState(10, lr);
	else if (stateName == L"defeated")
		SetState(11, lr);
	else if (stateName == L"shaking")
		SetState(12, lr);
	else if (stateName == L"wake")
		SetState(13, lr);
}

std::shared_ptr<Entity> CreateCS_PuuAni()
{
	return std::make_shared<CS_PuuAni>();
}
