#include "CS_PuppyFishStand.h"
const int CS_PuppyFishSTATENAME_STAND = ++entityStateID;
CS_PuppyFishStand::CS_PuppyFishStand()
{
	stateID = CS_PuppyFishSTATENAME_STAND;
	wink_counter = 0;
}

void CS_PuppyFishStand::State()
{
	auto we = e.lock();
	if (!we)
		return;

	const wchar_t* stand = L"";
	if (we->ud == -1)
		stand = we->lr == 0 ? L"mc_puppyfish_stand_lu" : L"mc_puppyfish_stand_ru";
	else if (we->ud == 0)
		stand = we->lr == 0 ? L"mc_puppyfish_stand_l" : L"mc_puppyfish_stand_r";
	else if (we->ud == 1)
		stand = we->lr == 0 ? L"mc_puppyfish_stand_ld" : L"mc_puppyfish_stand_rd";
	we->ani.sprite_index = stand;
	//գ
	if (Random(0, 120) == 10)
	{
		wink_counter = 8;
	}
	if (wink_counter > 0)
	{
		wink_counter--;
		we->ani.image_index = 1;
	}
	else
	{
		we->ani.image_index = 0;
	}
}

void CS_PuppyFishStand::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
		enable = true;
	else
		enable = false;
}
