#include "CS_PeDizzy.h"

CS_PeDizzy::CS_PeDizzy(std::shared_ptr<Entity> parent)
{
	type = 3;
	attackParent = parent;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_dizzy";
	int dx = parent->lr == 0 ? -16 : 16;
	int dy = -16;
	x = parent->x + dx;
	last_x = parent->last_x + dx;
	y = parent->y + dy;
	last_y = parent->last_y + dy;
}

void CS_PeDizzy::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	int dx = wattackParent->lr == 0 ? -16 : 16;
	int dy = -16;
	x = wattackParent->x + dx;
	last_x = wattackParent->last_x + dx;
	y = wattackParent->y + dy;
	last_y = wattackParent->last_y + dy;
}
