#include "CS_PastryChefAni.h"

CS_PastryChefAni::CS_PastryChefAni()
{
	ani.png = L"CS_CaveStoryMod";
}

void CS_PastryChefAni::Step()
{
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		ani.sprite_index = lr == 0 ? L"mc_pastrychef_stand_l" : L"mc_pastrychef_stand_r";
		break;
	}
}

void CS_PastryChefAni::SetState(int stateID, int lr)
{
	if (el.arg.length() > 0)
	{
		SetState(el.arg, lr);
		el.arg.clear();
	}
	this->stateID = stateID;
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"mc_pastrychef_stand_l" : L"mc_pastrychef_stand_r";
}

void CS_PastryChefAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"in_counter")
	{
		drawBeforeOtherEntity = true;
		y -= 3;
	}
	else if (stateName == L"leave_counter")
	{
		drawBeforeOtherEntity = false;
		y += 3;
	}
}

std::shared_ptr<Entity> CreateCS_PastryChefAni()
{
	return std::make_shared<CS_PastryChefAni>();
}
