#include "CS_MovingPlatform_LR.h"
#include "CS_PeSmoke.h"
CS_MovingPlatform_LR::CS_MovingPlatform_LR()
{
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.left = 16;
	cbRect.top = 16;
	cbRect.right = 16;
	cbRect.bottom = 16;
}

void CS_MovingPlatform_LR::Step()
{
	switch (act_no)
	{
	case 10:
		if (gameFunc->GetGlobalEntityTable)
		{
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer)
				{
					if (wplayer->el.name == L"null")
						continue;
					if (wplayer->hide)
						continue;
					if (wplayer)
					{
						if (wplayer->x < x + 0x3200 / ts &&
							wplayer->x > x - 0x64000 / ts &&
							wplayer->y < y + 0x3200 / ts &&
							wplayer->y > y - 0x3200 / ts)
						{
							act_no = 11;
							act_wait = 0;
						}
					}
				}
			}
		}
		break;
	case 11:
		if (++act_wait % 10 == 6)
			gameFunc->PlaySound(L"CS_107_block_move");

		if (cbRect.cbLeft)
		{
			vx = 0;
			direct = 2;
			act_no = 20;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 10, 0);
			gameFunc->PlaySound(L"CS_026_quake");
			for (int i = 0; i < 4; ++i)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x - 0x2000 / ts;
				pe->y = y + Random(-12, 12);
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
		}
		else
		{
			vx -= 0x20 / ts;
		}
		break;
	case 20:
		if (gameFunc->GetGlobalEntityTable)
		{
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer)
				{
					if (wplayer->el.name == L"null")
						continue;
					if (wplayer->hide)
						continue;
					if (wplayer)
					{
						if (wplayer->x > x - 0x3200 / ts &&
							wplayer->x < x + 0x64000 / ts &&
							wplayer->y < y + 0x3200 / ts &&
							wplayer->y > y - 0x3200 / ts)
						{
							act_no = 21;
							act_wait = 0;
						}
					}
				}
			}
		}
		break;
	case 21:
		if (++act_wait % 10 == 6)
			gameFunc->PlaySound(L"CS_107_block_move");
		if (cbRect.cbRight)
		{
			vx = 0;
			direct = 0;
			act_no = 10;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 10, 0);
			gameFunc->PlaySound(L"CS_026_quake");
			for (int i = 0; i < 4; ++i)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x + 0x2000 / ts;
				pe->y = y + Random(-12, 12);
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
		}
		else
		{
			vx += 0x20 / ts;
		}
		break;
	}
	if (vx > 0x200 / ts)
		vx = 0x200 / ts;
	if (vx < -0x200 / ts)
		vx = -0x200 / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_MovingPlatform_LR::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		switch (stateID)
		{
		case 0:
			x += 0x1000 / ts;
			y += 0x1000 / ts;
			direct = lr == 0 ? 0 : 2;
			if (direct == 0)
				act_no = 10;
			else
				act_no = 20;
			vx = 0;
			vy = 0;
			ani.sprite_index = el.arg;
			break;
		}
	}
}

std::shared_ptr<Entity> CreateCS_MovingPlatform_LR()
{
	return std::make_shared<CS_MovingPlatform_LR>();
}
