#include "CS_MiseryBat.h"

CS_MiseryBat::CS_MiseryBat()
{
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 7;
	cbRect.bottom = 4;
	cbRect.waterBlock = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
}

void CS_MiseryBat::Init(std::weak_ptr<Entity> self)
{
	auto wlight = std::make_shared<CS_PeLightFade>();
	light = wlight;
	gameFunc->SetEntity(shared_from_this(), wlight);
	Entity::Init(self);
}

void CS_MiseryBat::Step()
{
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		if (Random(0, 120) == 10)
		{
			act_no = 2;
			act_wait = 0;
			ani.sprite_index = lr == 0 ? L"ls_bat_sleep_l" : L"ls_bat_sleep_r";
		}
		break;
	case 2:
		if (++act_wait > 8)
		{
			act_no = 1;
			ani.sprite_index = lr == 0 ? L"ls_bat_wake_l" : L"ls_bat_wake_r";
		}
		break;
	}
	auto wlight = light.lock();
	if (wlight)
	{
		wlight->x = x;
		wlight->y = y;
		wlight->last_x = last_x;
		wlight->last_y = last_y;
		wlight->SetRadius(1);
	}
}

void CS_MiseryBat::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_bat_wake_l" : L"ls_bat_wake_r";
}

void CS_MiseryBat::Destroy()
{
	auto wlight = light.lock();
	if (wlight)
		wlight->Destroy();
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_MiseryBat()
{
	return std::make_shared<CS_MiseryBat>();
}
