#include "CS_KingSwordV3Blade.h"
#include "CS_PeHurt.h"
#include "CS_King.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeGunShotSpark.h"
#include "CS_KingSwordV3BladeEdge.h"
CS_KingSwordV3Blade::CS_KingSwordV3Blade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = 6;
	cbRect.right = 6;
	cbRect.top = 6;
	cbRect.bottom = 6;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y - 12;
		vx = 0;
		vy = -0x800 / ts;
		ani.sprite_index = L"am_sword3_u";
	}
	else if (ud == 0)
	{
		x = parent->x;
		y = parent->y;
		vy = 0;
		if (lr == 0)
		{
			vx = -0x800 / ts;
			ani.sprite_index = L"am_sword3_l";
		}
		else
		{
			vx = 0x800 / ts;
			ani.sprite_index = L"am_sword3_r";
		}
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 10;
		vx = 0;
		vy = 0x800 / ts;
		ani.sprite_index = L"am_sword3_d";
	}
	
	action_timecounter = 30;
	//
	damaged_limit = 3;
	damage_reset_counter = 0;
}

void CS_KingSwordV3Blade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ǽײ
	SetCbRect_Collision();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	if (bMark)
	{
		if (action_timecounter > 0)
		{
			action_timecounter--;
			if (action_timecounter == 0)
				Destroy();
		}
		if (Random(-1, 1) == 0)
		{
			gameFunc->PlaySound(L"CS_106");
			auto wattackParent = attackParent.lock();
			if (wattackParent)
			{
				auto am = std::make_shared<CS_KingSwordV3BladeEdge>(wattackParent);
				am->x = x + Random(-0x40, 0x40);
				am->y = y + Random(-0x40, 0x40);
				if (Random(0, 1) % 2)
					am->lr = 0;
				else
					am->lr = 1;
				gameFunc->SetEntity(shared_from_this(), am);
				am->SetState(0, am->lr);
			}
		}
	}
	else
	{
		if (action_timecounter % 4 == 2)
		{
			gameFunc->PlaySound(L"CS_106");
			auto wattackParent = attackParent.lock();
			if (wattackParent)
			{
				auto am = std::make_shared<CS_KingSwordV3BladeEdge>(wattackParent);
				am->x = x;
				am->y = y;
				if (++count1 % 2)
					am->lr = 0;
				else
					am->lr = 1;
				gameFunc->SetEntity(shared_from_this(), am);
				am->SetState(0, am->lr);
			}
		}
		if (action_timecounter > 0)
		{
			action_timecounter--;
			if (action_timecounter == 0)
			{
				SetCS_PeGunShotSpark(shared_from_this(), x, y);
				Destroy();
			}
		}
	}
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if(cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_028_shot_hit");
		SetCS_PeGunShotHit(shared_from_this(), x, y);
		Destroy();
	}
	if (action_timecounter % 2 == 0)
		color = 0;
	else
		color = RGBA(0xff, 0xff, 0xff, 0xff);
}

void CS_KingSwordV3Blade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_KingSwordV3Blade::Feedback(std::weak_ptr<Entity> target)
{
}

void CS_KingSwordV3Blade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage > 0)
	{
		//رչ״̬
		attackState = false;
		vx = vy = 0;
		action_timecounter = 50;
		bMark = true;
	}
}

void CS_KingSwordV3Blade::Destroy()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	auto mychar = std::static_pointer_cast<CS_King>(wattackParent);
	auto& amList = mychar->amList;
	for (auto iter = amList.begin(); iter != amList.end(); iter++)
	{
		if ((*iter).lock() == shared_from_this())
		{
			amList.erase(iter);
			break;
		}
	}
	Entity::Destroy();
}

void CS_KingSwordV3Blade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_KingSwordV3Blade::SetCbRect_Entity()
{
	cbRect.left = 6;
	cbRect.right = 6;
	cbRect.top = 6;
	cbRect.bottom = 6;
	cbRect.breakStarBlock = false;
}

void CS_KingSwordV3Blade::SetCbRect_Collision()
{
	cbRect.left = 4;
	cbRect.right = 4;
	cbRect.top = 4;
	cbRect.bottom = 4;
	cbRect.breakStarBlock = true;
}
