#include "CS_KingSwordV2Blade.h"
#include "CS_PeHurt.h"
#include "CS_King.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeGunShotSpark.h"
CS_KingSwordV2Blade::CS_KingSwordV2Blade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = 10;
	cbRect.right = 10;
	cbRect.top = 10;
	cbRect.bottom = 10;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y - 12;
		vx = 0;
		vy = -0x800 / ts;
	}
	else if (ud == 0)
	{
		x = parent->x;
		y = parent->y;
		vx = lr == 0 ? -0x800 / ts : 0x800 / ts;
		vy = 0;
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 10;
		vx = 0;
		vy = 0x800 / ts;
	}
	ani.sprite_index = lr == 0 ? L"am_sword2_l" : L"am_sword2_r";
	action_timecounter = 18;
	//
	damaged_limit = 3;
	damage_reset_counter = 0;
}

void CS_KingSwordV2Blade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ǽײ
	SetCbRect_Collision();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	if (action_timecounter % 7 == 4)
		gameFunc->PlaySound(L"CS_106");
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_028_shot_hit");
		SetCS_PeGunShotHit(shared_from_this(), x, y);
		Destroy();
	}
}

void CS_KingSwordV2Blade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 6;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_KingSwordV2Blade::Feedback(std::weak_ptr<Entity> target)
{
	if (damaged_counter == damaged_limit)
		Destroy();
}

void CS_KingSwordV2Blade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_KingSwordV2Blade::Destroy()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	auto mychar = std::static_pointer_cast<CS_King>(wattackParent);
	auto& amList = mychar->amList;
	for (auto iter = amList.begin(); iter != amList.end(); iter++)
	{
		if ((*iter).lock() == shared_from_this())
		{
			amList.erase(iter);
			break;
		}
	}
	Entity::Destroy();
}

void CS_KingSwordV2Blade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_KingSwordV2Blade::SetCbRect_Entity()
{
	cbRect.left = 10;
	cbRect.right = 10;
	cbRect.top = 10;
	cbRect.bottom = 10;
	cbRect.breakStarBlock = false;
}

void CS_KingSwordV2Blade::SetCbRect_Collision()
{
	cbRect.left = 4;
	cbRect.right = 4;
	cbRect.top = 2;
	cbRect.bottom = 2;
	cbRect.breakStarBlock = true;
}
