#include "CS_KingSwordV2.h"
#include "CS_King.h"
#include "CS_KingSwordV2Blade.h"
const int CS_KingSTATENAME_SWORDV2 = ++entityStateID;
CS_KingSwordV2::CS_KingSwordV2()
{
	stateID = CS_KingSTATENAME_SWORDV2;
	cd_counter = 0;
	cd_counter_max = 1;
	iconIndex = 0;
}

const wchar_t* CS_KingSwordV2::GetSaveName()
{
	return L"SwordV2";
}

void CS_KingSwordV2::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_King>(we);
	bUIShowDisableSkill = !((
		!mychar->InAction() &&
		mychar->amList.size() < 1
		) &&
		!lock
		);

	bool a1 = !lock && !mychar->InAction();
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//UI
	EntitySkillState::SubStep();
}

void CS_KingSwordV2::ChangeStateMsg(int stateID)
{
	//ʼ
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_King>(we);
	if (stateID == GetStateID() && mychar->amList.size() < 1)
	{
		enable = false;
		//
		auto& bClimb = mychar->stateControl.bClimb;
		auto lrSrc = mychar->lr;
		if (bClimb)
			mychar->lr = mychar->lr == 0 ? 1 : 0;
		auto am = std::make_shared<CS_KingSwordV2Blade>(we);
		mychar->lr = lrSrc;
		we->gameFunc->SetEntity(we, am);
		mychar->amList.push_back(am);
		//ס
		mychar->inputLock.key |= keyMask;
	}
	else
		enable = false;
}
