#include "CS_KingFishAni.h"

CS_KingFishAni::CS_KingFishAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 4;
	cbRect.bottom = 4;
	cbRect.fullWaterBlock = true;
}

void CS_KingFishAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_KingFishAni::Step()
{
	switch (stateID)
	{
	case 0:
		{
			const wchar_t* stand = L"";
			if (ud == -1)
				stand = lr == 0 ? L"mc_santafish_stand_lu" : L"mc_santafish_stand_ru";
			else if (ud == 0)
				stand = lr == 0 ? L"mc_santafish_stand_l" : L"mc_santafish_stand_r";
			else if (ud == 1)
				stand = lr == 0 ? L"mc_santafish_stand_ld" : L"mc_santafish_stand_rd";
			ani.sprite_index = stand;
			//գ
			if (Random(0, 120) == 10)
			{
				wink_counter = 8;
			}
			if (wink_counter > 0)
			{
				wink_counter--;
				ani.image_index = 1;
			}
			else
			{
				ani.image_index = 0;
			}
		}
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_KingFishAni::SetState(int stateID, int lr)
{
}

void CS_KingFishAni::SetState(std::wstring stateName, int lr)
{
}

std::shared_ptr<Entity> CreateCS_KingFishAni()
{
	return std::make_shared<CS_KingFishAni>();
}
