#include "CS_KanpaStepOnBlade.h"
#include "CS_Kanpa.h"
#include "PeSpark.h"
#include "CS_PeHurt.h"
#include "CS_PeGunShotHit.h"
CS_KanpaStepOnBlade::CS_KanpaStepOnBlade(std::shared_ptr<Entity> parent, bool(*LeaveFunc)(std::weak_ptr<Entity> e))
{
	type = 2;
	attackParent = parent;
	this->LeaveFunc = LeaveFunc;
	//ʵĵһܻ֡
	//ùλ
	ud = parent->ud;
	lr = parent->lr;
	dy = 8;
	cbRect.left = 8;
	cbRect.right = 8;
	cbRect.top = 0;
	cbRect.bottom = 4;
	ani.sprite_index = L"am_stepon_l1";
}

void CS_KanpaStepOnBlade::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	auto mychar = std::static_pointer_cast<CS_Kanpa>(wattackParent);
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	if (mychar->mp < 5)
		ani.sprite_index = L"am_stepon_l1";
	else if (mychar->mp < 10)
		ani.sprite_index = L"am_stepon_l2";
	else
		ani.sprite_index = L"am_stepon_l3";
	x = wattackParent->x + dx;
	last_x = wattackParent->last_x + dx;
	y = wattackParent->y + dy;
	last_y = wattackParent->last_y + dy;
	if (!leave)
		leave = LeaveFunc(wattackParent);
	if (leave)
	{
		Destroy();
	}
	if (alpha + 0.05f < 1)
	{
		alpha += 0.05f;
		if (alpha > 1)
			alpha = 1;
	}
	color = RGBA(0xff, 0xff, 0xff, (BYTE)(alpha * 0xff));
}

void CS_KanpaStepOnBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(wattackParent);
	if (mychar->mp < 5)
		*outDamage = 1;
	else if(mychar->mp < 10)
		*outDamage = 2;
	else
		*outDamage = 4;
	*outAngle = 90;
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x400 / ts;
	*outHeavy = 2;
}

void CS_KanpaStepOnBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else 
	{
		if (realDamage > 0)
			SetPeSpark(shared_from_this(), centerX, centerY, 1, 3, 270);
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_KanpaStepOnBlade::Feedback(std::weak_ptr<Entity> target)
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(wattackParent);
	mychar->stateJump.SetJump();
}
