#include "CS_KanpaStepOn.h"
#include "CS_Kanpa.h"
#include "PeLightTail.h"
#include "CS_KanpaStepOnBlade.h"
#include "PeSmog.h"
const int CS_KanpaSTATENAME_STEPON = ++entityStateID;
CS_KanpaStepOn::CS_KanpaStepOn()
{
	stateID = CS_KanpaSTATENAME_STEPON;
	cd_counter = 0;
	cd_counter_max = 1;
	iconIndex = 0;
}

const wchar_t* CS_KanpaStepOn::GetSaveName()
{
	return L"StepOn";
}

void CS_KanpaStepOn::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	//ʱԶ
	if (mychar->moveMode == 0 || mychar->InAction())
		return;
	if (bSetAm && mychar->vy > 0 && !mychar->cbRect.cbBottom && !mychar->cbRect.inWater)
	{
		bSetAm = false;
		bSetSmog = true;
		auto am = std::make_shared<CS_KanpaStepOnBlade>(we, &CS_KanpaStepOn::FallAtk_Leave);
		we->gameFunc->SetEntity(we, am);
	}
	//̳
	if (mychar->cbRect.inWater)
		bSetSmog = false;
	if (bSetSmog && mychar->cbRect.cbBottom)
	{
		bSetSmog = false;
		SetPeSmog(we, we->x, we->y, 1, 1, 135);
		SetPeSmog(we, we->x, we->y, 1, 1, 45);
	}
	//
	bool bReset = mychar->cbRect.cbBottom || mychar->cbRect.inWater || mychar->vy <= 0;
	if (bReset)
	{
		mychar->skillStepOn.bSetAm = true;
	}
}

bool CS_KanpaStepOn::FallAtk_Leave(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return false;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	auto& skillStepOn = mychar->skillStepOn;
	bool bReset = mychar->cbRect.cbBottom || mychar->cbRect.inWater || mychar->vy <= 0;
	if (bReset)
	{
		skillStepOn.bSetAm = true;
	}
	return mychar->InAction() || bReset;
}
