#include "CS_KanpaFishing.h"
#include "CS_Kanpa.h"

const int CS_KanpaSTATENAME_FISHING = ++entityStateID;
CS_KanpaFishing::CS_KanpaFishing()
{
	stateID = CS_KanpaSTATENAME_FISHING;
	cd_counter = 0;
	cd_counter_max = 60;
	iconIndex = 0;
}

const wchar_t* CS_KanpaFishing::GetSaveName()
{
	return L"Fishing";
}

const wchar_t* CS_KanpaFishing::GetFuncName()
{
	return L"KanpaSkill_Fishing";
}

const wchar_t* CS_KanpaFishing::GetCheckFuncName()
{
	return L"KanpaSkill_Fishing_check";
}

void CS_KanpaFishing::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	auto wfishhook = fishhook.lock();
	//ȡ
	if (mychar->input.key & keyMask ||
		!wfishhook)
	{
		//˳
		if (!wfishhook)
			QuitFishing();
		else
		{
			//Ϲ״̬ڼ޷˳Ϲڼ޵еģ
			if (!wfishhook->waitForHit)
				QuitFishing();
		}
	}
}

void CS_KanpaFishing::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	bUIShowDisableSkill = !((
		!mychar->InAction() &&
		we->cbRect.cbBottom && 
		!we->cbRect.inWater
		) &&
		!lock
		);
	bool a1 = !mychar->InAction() &&
		we->cbRect.cbBottom &&
		!we->cbRect.inWater &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	//
	if (a && b && c)
	{
		mychar->faceToBack = false;
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (!GetEnable())
	{
		//ζ
		if (a && b && !c)
		{
			we->shock_counter = 30;
			//ס
			mychar->inputLock.key |= keyMask;
		}
		if (cd_counter > 0)
			cd_counter--;
	}
	EntitySkillState::SubStep();
}

void CS_KanpaFishing::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
		enable = true;
		//
		mychar->action_timecounter = mychar->action_timecounter_max;
		cd_counter = cd_counter_max;
		//סüܼ
		mychar->input.key &= ~keyMask;
		mychar->inputLock.key |= keyMask;
		mychar->input.SetJump(false);
		mychar->inputLock.SetJump(true);
		mychar->input.SetAtk(false);
		mychar->inputLock.SetAtk(true);
		//ö
		mychar->ani.sprite_index = we->lr == 0 ? L"mc_kanpa_sit_l" : L"mc_kanpa_sit_r";
		mychar->ani.image_index = 1;
		//
		auto wfishhook = std::make_shared<CS_KanpaFishingBlade>(we);
		fishhook = wfishhook;
		wfishhook->x = we->x + (we->lr == 0 ? -16 : 16);
		wfishhook->y = we->y;
		we->gameFunc->SetEntity(we, wfishhook);
	}
	else
		enable = false;
}

bool CS_KanpaFishing::Hurt(std::weak_ptr<Entity> src, int* pGetDamage, float* pAngle, bool* pTakedown, int* pElemType, float* pShockForce, float* pHeavy, int* outRealDamage, bool* outRetVal)
{
	//Ϲʱ޵е
	auto wfishhook = fishhook.lock();
	if (wfishhook && wfishhook->waitForHit)
	{
		*outRetVal = false;//Է趨Ϊδ
		return true;//ֱӷ
	}
	return false;
}

void CS_KanpaFishing::QuitFishing()
{
	auto we = e.lock();
	if (we)
	{
		auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
		//˳
		mychar->action_timecounter = 0;
		mychar->input.key &= ~keyMask;
		mychar->inputLock.key |= keyMask;
	}
	fishhook.reset();
}
