#include "CS_Kanpa.h"
#include "CS_PeSmoke.h"
#include "CS_PeLevelUp.h"
#include "CS_PeSweat.h"
#include "CS_Exp.h"
#include "CS_Heart.h"
CS_Kanpa::CS_Kanpa()
{
	type = 1;
	//ʼ
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	//ʼֵ
	uiName = L"mimiga";
	saveName = CS_KANPA_CREATENAME;
	throwItem = 0;
	throwItem_max = 0;
	throwItem_type = 1;
	hp_max = 3;
	hp = 3;
	mp_max = 20;
	mp = 0;
}

void CS_Kanpa::Init(std::weak_ptr<Entity> self)
{
	//״̬Ҳִ˳
	AddState(&stateFlash);
	AddState(&stateInvincible);
	AddState(&stateGravity);
	AddState(&stateGravity2);
	AddState(&stateWater);
	AddState(&stateDrown);
	AddState(&stateControl);
	AddState(&stateControl2);
	AddState(&stateResist);//stateControl
	AddState(&stateResist2);
	AddState(&stateJump);
	AddState(&stateStand);
	AddState(&stateMove);
	AddState(&stateAir);
	AddState(&stateFaceToBack);
	AddState(&stateHurt);
	//Ӽ
	AddSkill(&skillStepOn);
	AddSkill(&skillFishing);
	//óʼ״̬
	ChangeState(stateStand.GetStateID());
	//óʼ״̬
	SetPhysice(false);
	//óʼܰ
	SetSkillBindIndex(&skillFishing, 1);
	skillFishing.lock = false;
	stateStand.Step();
	AnimateStep();
	MyCharEntity::Init(self);
}

void CS_Kanpa::Step()
{
	//ֹͼ
	Entity::KeepInMap();
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ㶯
	AnimateStep();
	//ⱻƶƽ̨ѹ
	if (CheckCrush(&crushEvent))
		CrushDeath();
	//״̬
	if (stateID == 0 && type == 1)
	{
		stateGravity.SetEnable(moveMode == 0);
		stateResist.SetEnable(moveMode == 0);
		stateGravity2.SetEnable(moveMode != 0);
		stateResist2.SetEnable(moveMode != 0);
		//ҿ
		for (auto& p : stateList)
			p->Step();
		if (atkFeedBack > 0)
			atkFeedBack--;
		else if (action_timecounter > 0)
			action_timecounter--;
	}
	else if (type == 0 || stateID != 0)
	{
		//
		switch (stateID)
		{
		case 0://վ
			stateStand.State();
			vx = 0;
			//
			stateGravity.State();
			break;
		case 1://·
			stateMove.State();
			stateGravity.State();
			break;
		case 6://
			for (auto& p : stateList)
				p->Step();
			break;
		case 7:
		case 8:
			vx = 0;
			vy = 0;
			break;
		}
	}
	//UI
	MyCharEntity::UpdateUI();
	//糡
	Entity::Wind();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Kanpa::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->stateID = stateID;
		this->lr = lr;
		//ö
		switch (stateID)
		{
		case 0://ûжָҿƣ
			faceToBack = false;
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				stateMove.State();
				//
				stateGravity.State();
			}
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_kanpa_back_l" : L"mc_kanpa_back_r";
			//
			stateGravity.State();
			break;
		case 3://
			vx = vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_kanpa_sit_l" : L"mc_kanpa_sit_r";
			break;
		case 4://ʼƶ
			showSweat = true;
			face = 1;
			cbRect.enableMovePlatform = true;
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed / 4;
			else
				vx = animation_moveSpeed / 4;
			ani.sprite_index = lr == 0 ? L"mc_kanpa_push_l" : L"mc_kanpa_push_r";
			//
			stateGravity.State();
			break;
		case 5://ƶ
			showSweat = false;
			face = 0;
			cbRect.enableMovePlatform = false;
			stateID = 0;
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_kanpa_stand_l" : L"mc_kanpa_stand_r";
			break;
		case 6://
			vy = -2;
			if (lr == 0)//
				vx = 4;
			else//
				vx = -4;
			break;
		case 7://
			ani.sprite_index = lr == 0 ? L"mc_kanpa_lie_l" : L"mc_kanpa_lie_r";
			break;
		case 8://Ͽ
			ani.sprite_index = lr == 0 ? L"mc_kanpa_stand_lu" : L"mc_kanpa_stand_ru";
			break;
		}
	}
	else
	{
		//ö
		switch (stateID)
		{
		case 200://ʾ
			showFishingRod = true;
			break;
		case 201://
			showFishingRod = false;
			break;
		case 202://
			ani.image_index = 0;
			break;
		case 203://
			ani.image_index = 1;
			break;
		case 204://ƶģʽ2
			moveMode = 1;
			break;
		case 205://ƶģʽ1
			moveMode = 0;
			break;
		case 206://
			showSweat = true;
			break;
		case 207://ر
			showSweat = false;
			break;
		case 208://Ĭ
			face = 0;
			break;
		case 209://> <
			face = 1;
			break;
		}
	}
}

void CS_Kanpa::SetState(std::wstring stateName, int lr)
{
	MyCharEntity::SetState(stateName, lr);
	if (stateName == L"show_sweat")
		SetState(206, lr);
	else if(stateName == L"hide_sweat")
		SetState(207, lr);
	else if (stateName == L"normal_face")
		face = 0;
	else if (stateName == L"> <_face")
		face = 1;
	else if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"sit")
		SetState(3, lr);
	else if (stateName == L"start_push")
		SetState(4, lr);
	else if (stateName == L"end_push")
		SetState(5, lr);
	else if (stateName == L"MYB")
		SetState(6, 0);
	else if(stateName == L"walk")
		SetState(1, lr);
	else if(stateName == L"lie")
		SetState(7, lr);
	else if (stateName == L"up_look")
		SetState(8, lr);
	else if (stateName == L"show_fishing_rod")
		SetState(200, lr);
	else if (stateName == L"hide_fishing_rod")
		SetState(201, lr);
	else if (stateName == L"open_the_eyes")
		SetState(202, lr);
	else if (stateName == L"close_the_eyes")
		SetState(203, lr);
}

void CS_Kanpa::LoadSaveData()
{
	MyCharEntity::LoadSaveData();
	//ȡƶģʽ
	showFishingRod = std::stoi(gameFunc->ReadData(CS_KANPA_CREATENAME, L"showFishingRod", L"0")) != 0;
	moveMode = std::stoi(gameFunc->ReadData(CS_KANPA_CREATENAME, L"moveMode", L"0"));
}

void CS_Kanpa::WriteSaveData()
{
	MyCharEntity::WriteSaveData();
	//дƶģʽ
	gameFunc->WriteData(CS_KANPA_CREATENAME, L"showFishingRod", std::to_wstring(showFishingRod ? 1 : 0).c_str());
	gameFunc->WriteData(CS_KANPA_CREATENAME, L"moveMode", std::to_wstring(moveMode).c_str());
}

bool CS_Kanpa::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	//¼ʱ޵״̬
	if (gameFunc->ScriptIsRunning)
	{
		if (gameFunc->ScriptIsRunning(gameFunc->gameScript))
			return false;
	}
	//״̬
	for (auto& p : stateList)
	{
		bool retVal = true;
		if (p->Hurt(src, &getDamage, &angle, &bTakedown, &elemType, &shockForce, &heavy, outRealDamage, &retVal))
			return retVal;
	}
	//ܴ
	for (auto& p : skillList)
	{
		bool retVal = true;
		if (p->Hurt(src, &getDamage, &angle, &bTakedown, &elemType, &shockForce, &heavy, outRealDamage, &retVal))
			return retVal;
	}
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	stateInvincible.SetDamage(getDamage);
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_050_mimiga_squeak");
		//ȼ½
		if ((mp >= 10 && mp - 2 * getDamage < 10) ||
			(mp >= 5 && mp - 2 * getDamage < 5))
			SetCS_PeLevelDown(shared_from_this(), x, y);
	}
	if (hp <= 0)
	{
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		UpdateUI();
		//Ϸ
		hide = true;
		//
		if (gameFunc->StartEvent)
		{
			gameFunc->PlaySound(L"CS_017_quote_die");
			gameFunc->StopMusic();
			gameFunc->StartEvent(gameFunc->gameScript, L"Died", L"tDeath");
		}
	}
	//
	mp -= 2 * getDamage;
	if (mp < 0)
		mp = 0;
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//
	stateFlash.flash_counter = 5;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 1, shared_from_this());
	//ת״̬
	ChangeState(stateHurt.GetStateID());
	return true;
}

void CS_Kanpa::Gain(std::weak_ptr<Entity> item)
{
	auto witem = item.lock();
	if (!witem)
		return;

	//ʰȡ˾
	if (witem->el.name == CS_EXP_CREATENAME && witem->inUsing)
	{
		//Mp˸
		if (gameFunc->GetPlayerIndex)
		{
			int playerIndex = gameFunc->GetPlayerIndex(gameFunc->game, shared_from_this());
			if (playerIndex >= 0)
			{
				auto& ui = *gameFunc->GetPlayerUIData(gameFunc->gameUI, playerIndex);
				ui.MpBar_flash_counter = 30;
			}
		}
		//ȼ
		if ((mp < 5 && mp + witem->dropExp >= 5) ||
			(mp < 10 && mp + witem->dropExp >= 10))
			SetCS_PeLevelUp(shared_from_this(), x, y);
		mp += witem->dropExp;
		if (mp > mp_max)
			mp = mp_max;
		gameFunc->PlaySound(L"CS_014_get_xp");
		//ʾֵ
		if (gameFunc->dmgNum)
			gameFunc->SetDmgNum(gameFunc->dmgNum, witem->dropExp, x, y - 16, 3, shared_from_this());
		witem->Destroy();
	}
	//ʰȡ
	else if (witem->el.name == CS_HEART_CREATENAME && witem->inUsing)
	{
		//ָ
		hp += witem->hp;
		if (hp > hp_max)
			hp = hp_max;
		gameFunc->PlaySound(L"CS_020_health_refill");
		witem->Destroy();
	}
}

void CS_Kanpa::GetCameraPos(float* outX, float* outY)
{
	auto wfishhook = skillFishing.fishhook.lock();
	if (wfishhook)
	{
		*outX = wfishhook->x;
		*outY = wfishhook->y;
	}
	else
	{
		*outX = x;
		*outY = y;
	}
}

void CS_Kanpa::GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList)
{
	png = L"CS_CaveStoryMod";
	sprite_index = L"mc_kanpa_stand_r";
	image_index = 0;
	hideLayerList = ani.hideLayerList;
}

void CS_Kanpa::CrushDeath()
{
	//
	SetCS_PeSmokeMedium(shared_from_this(), x, y);
	hp = 0;
	UpdateUI();
	//Ϸ
	hide = true;
	//Ϸ
	if (gameFunc->StartEvent)
	{
		gameFunc->PlaySound(L"CS_017_quote_die");
		gameFunc->StopMusic();
		if (crushEvent.length())
			gameFunc->StartEvent(gameFunc->gameScript, crushEvent.c_str(), L"tCrush");
		else
			gameFunc->StartEvent(gameFunc->gameScript, L"DeathByMovingPlatform", L"tCrush");
	}
}

void CS_Kanpa::AnimateStep()
{
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	ani.hideLayerList.insert(5);
	if(moveMode == 0)
		ani.hideLayerList.erase(3);
	else
		ani.hideLayerList.erase(4);
	if (showFishingRod)
	{
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(5);
	}
	if(face == 0)
		ani.hideLayerList.erase(1);
	else
		ani.hideLayerList.erase(2);
	if (showSweat)
	{
		if (showSweat_counter == 0)
		{
			SetCS_PeSweat(shared_from_this());
			showSweat_counter = showSweat_counter_max;
		}
		if (showSweat_counter > 0)
			showSweat_counter--;
	}
}

std::shared_ptr<Entity> CreateCS_Kanpa()
{
	return std::make_shared<CS_Kanpa>();
}
