#include "CS_JackWater.h"
#include "CS_Jack.h"
const int CS_JackSTATENAME_WATER = ++entityStateID;
CS_JackWater::CS_JackWater()
{
	enable = true;
	stateID = CS_JackSTATENAME_WATER;
	o2_counter_max = 20;
}

void CS_JackWater::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Jack>(we);
	auto& stateGravity = mychar->stateGravity;
	mychar->SetPhysice(we->cbRect.inWater);
	if (we->cbRect.pxaBottom == 0x12)
		mychar->SetPhysice(true);

	//ˮˮЧ
	if (we->cbRect.inWater)
	{
		o2_show = true;
		o2_hide_counter = 60;
		if (fallToWater && setSplash && we->vy >= stateGravity.max_fall_speed / 2)
		{
			//ˮ
			auto nE = we->gameFunc->GameCreateEntity(L"pe_splash");
			nE->x = we->x;
			nE->y = we->y;
			//ҽ
			if (we->cbRect.inLava)
				nE->color = RGBA(0xff, 0, 0, 0xff);
			we->gameFunc->SetEntity(we, nE);
			fallToWater = false;
		}
		else
		{
			//ٶδﵽȻˮ
			setSplash = false;
		}
		//ֵ
		if (o2_counter > 0)
			o2_counter--;
		if (o2_counter == 0)
		{
			o2_counter = o2_counter_max;
			if (o2 > 0)
				o2--;
		}
		if (o2 == 0)
		{
			//Ϣ
			mychar->ChangeState(mychar->stateDrown.GetStateID());
			if (we->gameFunc->StartEvent)
			{
				we->gameFunc->StopMusic();
				we->gameFunc->StartEvent(we->gameFunc->gameScript, L"Drown", L"tBoot");
			}
		}
	}
	else
	{
		//ˮ
		fallToWater = true;
		setSplash = true;
		//ʾ
		o2 = 100;
		if (o2_hide_counter > 0)
			o2_hide_counter--;
		if (o2_hide_counter == 0)
			o2_show = false;
	}
	//UI
	if (we->gameFunc)
	{
		int playerIndex = we->gameFunc->GetPlayerIndex(we->gameFunc->game, we);
		if (playerIndex < 0)
			return;
		auto& ui = *we->gameFunc->GetPlayerUIData(we->gameFunc->gameUI, playerIndex);
		ui.o2_show = o2_show;
		ui.o2 = o2;
		ui.o2_effect = we->cbRect.inWater;
	}
}
