#include "CS_JackLevelReset.h"
#include "CS_Jack.h"
const int CS_JackSTATENAME_LEVELRESET = ++entityStateID;
CS_JackLevelReset::CS_JackLevelReset()
{
	stateID = CS_JackSTATENAME_LEVELRESET;
	cd_counter = 0;
	cd_counter_max = 1;
	iconIndex = 3;
}

const wchar_t* CS_JackLevelReset::GetSaveName()
{
	return L"LevelReset";
}

void CS_JackLevelReset::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Jack>(we);
	bool a1 = !lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	//
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	EntitySkillState::SubStep();
}

void CS_JackLevelReset::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_Jack>(we);
		enable = false;
		//
		cd_counter = cd_counter_max;
		//¼
		mychar->gameFunc->StartEvent(mychar->gameFunc->gameScript, L"LevelReset_Skill", L"tSkill");
		//סüܼ
		mychar->inputLock.key |= keyMask;
	}
	else
		enable = false;
}
