#include "CS_JackCatcherBombBlaster.h"
#include "CS_JackCatcherBubble.h"

CS_JackCatcherBombBlaster::CS_JackCatcherBombBlaster(std::shared_ptr<Entity> parent, int styleIndex)
{
	type = 2;
	attackParent = parent;
	SetStyle(styleIndex);
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	hp_max = hp = 1;
}

void CS_JackCatcherBombBlaster::Step()
{
	if (sleepTime_counter > 0)
	{
		sleepTime_counter--;
		return;
	}
	if (birthTime_counter > 0)
		birthTime_counter--;
	if (birthTime_counter == 0)
	{
		if (blasterTime_counter > 0)
		{
			blasterTime_counter--;
			if (blasterTime_counter == 0)
			{
				ani.sprite_index = endAni;
				ani.image_index = 0;
			}
		}
	}
	if (blasterTime_counter == 0 && ani.image_index == 7)
		Destroy();
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
	}
}

void CS_JackCatcherBombBlaster::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wdst = dst.lock();
	if (!wdst)
		return;
	if (birthTime_counter > 0)
		return;
	if (blasterTime_counter == 0)
		return;
	if (wdst->ignoreCaught)
		return;
	if (wdst->ignoreCaught_counter > 0)
		return;
	//
	auto wsrcTarget = wdst;
	auto wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
	if (wcaughtTarget)
	{
		while (wcaughtTarget != wsrcTarget)
		{
			wsrcTarget = wcaughtTarget;
			wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
			if (!wcaughtTarget)
			{
				wcaughtTarget = wsrcTarget;
				break;
			}
		}
	}
	else
	{
		//Ჶһ
		if (wsrcTarget->type == 0)
			return;
		wcaughtTarget = wsrcTarget;
	}
	if (wcaughtTarget)
	{
		//
		auto bubble = std::make_shared<CS_JackCatcherBubble>(wcaughtTarget,true);
		gameFunc->SetEntity(shared_from_this(), bubble);
		wcaughtTarget->ignoreCaught_counter = INT_MAX;
	}
}

bool CS_JackCatcherBombBlaster::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	auto wsrc = src.lock();
	if (!wsrc)
		return false;
	if (birthTime_counter > 0)
		return false;
	if (blasterTime_counter == 0)
		return false;
	if (!wsrc)
		return false;
	if (wsrc->ignoreCaught)
		return false;
	if (wsrc->ignoreCaught_counter > 0)
		return false;
	
	int srcType = wsrc->type;
	auto wsrc_attackParent = wsrc->attackParent.lock();
	if (wsrc_attackParent)
		srcType = wsrc_attackParent->type;
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		//зӪ
		if (srcType == wattackParent->type)
			return false;
	}
	//
	auto wsrcTarget = wsrc;
	auto wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
	if (wcaughtTarget)
	{
		while (wcaughtTarget != wsrcTarget)
		{
			wsrcTarget = wcaughtTarget;
			wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
			if (!wcaughtTarget)
			{
				wcaughtTarget = wsrcTarget;
				break;
			}
		}
	}
	else
	{
		//Ჶһ
		if (wsrcTarget->type == 0)
			return false;
		wcaughtTarget = wsrcTarget;
	}
	//Ŀ
	if (wcaughtTarget)
	{
		auto bubble = std::make_shared<CS_JackCatcherBubble>(wcaughtTarget);
		gameFunc->SetEntity(shared_from_this(), bubble);
			wcaughtTarget->ignoreCaught_counter = INT_MAX;
	}
	return false;
}

void CS_JackCatcherBombBlaster::SetStyle(int styleIndex)
{
	switch (styleIndex)
	{
	case 8:
		ani.sprite_index = L"am_catcher_blaster_u_start";
		endAni = L"am_catcher_blaster_u_end";
		break;
	case 2:
		ani.sprite_index = L"am_catcher_blaster_d_start";
		endAni = L"am_catcher_blaster_d_end";
		break;
	case 4:
		ani.sprite_index = L"am_catcher_blaster_l_start";
		endAni = L"am_catcher_blaster_l_end";
		break;
	case 6:
		ani.sprite_index = L"am_catcher_blaster_r_start";
		endAni = L"am_catcher_blaster_r_end";
		break;
	case 5:
		ani.sprite_index = L"am_catcher_blaster_c_start";
		endAni = L"am_catcher_blaster_c_end";
		break;
	case 0:
		ani.sprite_index = L"am_catcher_blaster_lr_start";
		endAni = L"am_catcher_blaster_lr_end";
		break;
	case 1:
		ani.sprite_index = L"am_catcher_blaster_ud_start";
		endAni = L"am_catcher_blaster_ud_end";
		break;
	}
}

void SetCS_JackCatcherBombBlaster(std::shared_ptr<Entity> parent, int styleIndex, float x, float y, int sleepTime)
{
	auto am = std::make_shared<CS_JackCatcherBombBlaster>(parent, styleIndex);
	am->x = x;
	am->y = y;
	am->sleepTime_counter = sleepTime;
	parent->gameFunc->SetEntity(parent, am);
}
