#include "CS_JackBubbler.h"
#include "CS_Jack.h"
#include "CS_PeOutOfAmmo.h"
const int CS_JackSTATENAME_BUBBLER = ++entityStateID;
CS_JackBubbler::CS_JackBubbler()
{
	stateID = CS_JackSTATENAME_BUBBLER;
	cd_counter = 0;
	cd_counter_max = 7;
	iconIndex = 0;
}

const wchar_t* CS_JackBubbler::GetSaveName()
{
	return L"Bubbler";
}

void CS_JackBubbler::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Jack>(we);
	bool a1 = !lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	//ȼ
	if (mychar->mp >= 30)
		level = 2;
	else if (mychar->mp >= 10)
		level = 1;
	else
		level = 0;
	//ӵ
	fcounter = (float)ammo_count / ammo_count_max;
	//ӵľЧʱ
	if (outOfAmmo_counter > 0)
		outOfAmmo_counter--;
	//ӵָ
	if (!we->input.GetAtk())
	{
		if (shootingToRefill_counter > 0)
			shootingToRefill_counter--;
		if (shootingToRefill_counter == 0)
		{
			int targetLevel = level;
			//һֱάǹ3̬
			if (mychar->skillCatcher.lock == false)
				targetLevel = 2;
			switch (targetLevel)
			{
			case 0:
				ammoRefill_counter_max = 20;
				break;
			case 1:
			case 2:
				ammoRefill_counter_max = 2;
				break;
			}
			if (ammoRefill_counter > 0)
				ammoRefill_counter--;
			if (ammoRefill_counter == 0 && ammo_count < ammo_count_max)
			{
				ammo_count++;
				ammoRefill_counter = ammoRefill_counter_max;
			}
		}
	}
	//ҪUI
	if (ammo_count < ammo_count_max)
	{
		if (ammoBar.expired())
		{
			auto wammoBar = std::make_shared<PeReadyBar>(mychar, &fcounter, RGBA(0xff, 0xff, 0xff, 0xff), 0, -16,
				&CS_JackBubbler::ReadyBar_Leave,
				&CS_JackBubbler::ReadyBar_Destroy);
			ammoBar = wammoBar;
			we->gameFunc->SetEntity(we, wammoBar);
		}
	}
}

void CS_JackBubbler::ChangeStateMsg(int stateID)
{
	//ʼ
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_Jack>(we);

	if (stateID == GetStateID() &&
		(
			(level == 0 && amList.size() < 4) ||
			(level != 0) ||
			!mychar->skillCatcher.lock
		))
	{
		enable = false;
		//ӵ
		if (ammo_count > 0)
		{
			ammo_count--;
			shootingToRefill_counter = shootingToRefill_counter_max;
			//
			int targetLevel = level;
			//һֱάǹ3̬
			if (mychar->skillCatcher.lock == false)
				targetLevel = 2;
			auto am = std::make_shared<CS_JackBubblerBlade>(we, keyMask, targetLevel);
			we->gameFunc->SetEntity(we, am);
			amList.push_back(am);
			//ס
			if (targetLevel == 0)
				mychar->inputLock.key |= keyMask;
			else
				cd_counter = cd_counter_max;
		}
		else
		{
			if (outOfAmmo_counter == 0)
			{
				SetCS_PeOutOfAmmo(we, we->x, we->y);
				outOfAmmo_counter = outOfAmmo_counter_max;
				we->gameFunc->PlaySound(L"CS_037_gun_click");
			}
		}
	}
	else
		enable = false;
}

bool CS_JackBubbler::ReadyBar_Leave(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return true;

	auto mychar = std::static_pointer_cast<CS_Jack>(we);
	auto& skillBubbler = mychar->skillBubbler;
	bool bLeave = skillBubbler.ammo_count == skillBubbler.ammo_count_max;
	if (bLeave)
		skillBubbler.ammoBar.reset();
	return bLeave;
}

void CS_JackBubbler::ReadyBar_Destroy(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Jack>(we);
	auto& skillBubbler = mychar->skillBubbler;
	skillBubbler.ammoBar.reset();
}
