#include "CS_JackAni.h"
#include "CS_PeZzz.h"

CS_JackAni::CS_JackAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_JackAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_JackAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ㶯
	AnimateStep();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 2://ǻ
		if (wonder_counter > 0)
		{
			wonder_counter--;
			if (wonder_counter == 0)
			{
				lr = lr == 0 ? 1 : 0;
				wonder_counter = wonder_counter_max;
			}
		}
		if (lr == 0)
			vx = -animation_moveSpeed / 2;
		else
			vx = animation_moveSpeed / 2;
		ani.image_counter_speed = 0.5f;
		ani.sprite_index = lr == 0 ? L"mc_jack_move_l" : L"mc_jack_move_r";
		break;
	case 3://˯
		vx = 0;
		vy = 0;
		//zzz
		if (++act_wait > 100)
		{
			act_wait = 0;
			SetPeCS_Zzz(shared_from_this(), x, y);
		}
		break;
	case 4://
		break;
	case 5://
		vx = 0;
		vy = 0;
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_JackAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_jack_stand_l" : L"mc_jack_stand_r";
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				ani.sprite_index = lr == 0 ? L"mc_jack_move_l" : L"mc_jack_move_r";
			}
			break;
		case 2://ǻ
			wonder_counter = wonder_counter_max;
			break;
		case 3://˯
			vx = 0;
			vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_jack_sleep_l" : L"mc_jack_sleep_r";
			break;
		case 4://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_jack_lie_l" : L"mc_jack_lie_r";
			break;
		case 5://
			vx = 0;
			y -= 3;
			ani.sprite_index = lr == 0 ? L"mc_jack_sit_l" : L"mc_jack_sit_r";
			break;
		case 6://
			ani.sprite_index = lr == 0 ? L"mc_jack_back_l" : L"mc_jack_back_r";
			break;
		}
	}
	//ͼ㶯
	AnimateStep();
}

void CS_JackAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if(stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"wander")
		SetState(2, lr);
	else if (stateName == L"sleep")
		SetState(3, lr);
	else if (stateName == L"lie")
		SetState(4, lr);
	else if (stateName == L"sit_on_chair")
		SetState(5, lr);
	else if (stateName == L"back")
		SetState(6, lr);
	//ͼ㶯
	AnimateStep();
}

void CS_JackAni::AnimateStep()
{
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(3);
	if (showGun)
	{
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(3);
	}
}

std::shared_ptr<Entity> CreateCS_JackAni()
{
	return std::make_shared<CS_JackAni>();
}
